/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.spec.agent.beans.dynamicinstrumentation;

import com.wily.introscope.spec.agent.beans.dynamicinstrumentation.DynamicInstrumentationResult;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Collection;
import java.util.List;

public class MethodCallsResult
extends DynamicInstrumentationResult {
    private Collection methodCalls;
    private String requestedClassName;
    private String actualClassImplementingMethod;

    public MethodCallsResult() {
    }

    public MethodCallsResult(MethodCallsResult input) {
        this.importAll(input);
    }

    public MethodCallsResult(int status) {
        super(status);
    }

    public MethodCallsResult(Integer status) {
        super(status);
    }

    public void importAll(MethodCallsResult input) {
        super.importAll(input);
        this.setMethodCalls(input.getMethodCalls());
        this.setRequestedClassName(input.getRequestedClassName());
        this.setActualClassImplementingMethod(input.getActualClassImplementingMethod());
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
        this.methodCalls = (List)in.readObject();
        this.requestedClassName = (String)in.readObject();
        this.actualClassImplementingMethod = (String)in.readObject();
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        out.writeObject(this.methodCalls);
        out.writeObject(this.requestedClassName);
        out.writeObject(this.actualClassImplementingMethod);
    }

    public Collection getMethodCalls() {
        return this.methodCalls;
    }

    public DynamicInstrumentationResult setMethodCalls(Collection calls) {
        this.methodCalls = calls;
        return this;
    }

    public void setRequestedClassName(String className) {
        this.requestedClassName = className;
    }

    public String getRequestedClassName() {
        return this.requestedClassName;
    }

    public void setActualClassImplementingMethod(String actualClassImplementingMethod) {
        this.actualClassImplementingMethod = actualClassImplementingMethod;
    }

    public String getActualClassImplementingMethod() {
        return this.actualClassImplementingMethod;
    }
}

