/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.stat.gatherer;

import com.wily.introscope.stat.gatherer.ALongCombiningGatherer;
import com.wily.introscope.stat.timeslice.LongTimeslicedValue;
import com.wily.wilyassert.Assertion;

public class LongSummingGatherer
extends ALongCombiningGatherer {
    private long fMin;
    private long fMax;
    private long fValue;

    public LongSummingGatherer(int typeCookie, long startTimestamp) {
        super(typeCookie, startTimestamp);
        this.reset();
        Assertion.wilyAssert(false);
    }

    protected void doAcceptAggregateLongTimeslicedValue(LongTimeslicedValue typedAggregate) {
        this.addToDataPointCount(typedAggregate.getDataPointCount());
        this.fValue += typedAggregate.getValue();
        this.fMin += typedAggregate.getMinimum();
        this.fMax += typedAggregate.getMaximum();
    }

    public long getLongValue() {
        return this.fValue;
    }

    public long getLongMinimum() {
        return this.fMin;
    }

    public long getLongMaximum() {
        return this.fMax;
    }

    protected void directSetLongMinimum(long minimum) {
        this.fMin = minimum;
    }

    protected void directSetLongMaximum(long maximum) {
        this.fMax = maximum;
    }

    protected void doResetCombiningGatherer(long when) {
        this.reset();
    }

    protected void doReinitializeCombiningGatherer() {
        this.reset();
    }

    private void reset() {
        this.fMin = 0L;
        this.fMax = 0L;
        this.fValue = 0L;
    }
}

