/*
 * Decompiled with CFR 0.152.
 */
package com.wily.isengard.container.beans;

import com.wily.isengard.container.MessageServiceRegistration;
import com.wily.isengard.container.beans.AIsengardBean;
import com.wily.isengard.util.parameter.CheckParameter;
import com.wily.wilyassert.Assertion;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

public class IsengardBeanDescriptor
implements Externalizable {
    private static final long serialVersionUID = 4550248712957364951L;
    private static final MessageServiceRegistration[] kEmptyMessageServiceRegistrationArray = new MessageServiceRegistration[0];
    private String fBeanClassName;
    private String fInstanceName;
    private String fContainerName;
    private String fPostOfficeName = "main";
    private Object fInstanceData;
    private MessageServiceRegistration[] fMessageServices = kEmptyMessageServiceRegistrationArray;
    private transient Class fBeanClass;
    private transient AIsengardBean fInstance;

    public IsengardBeanDescriptor() {
    }

    public IsengardBeanDescriptor(String containerName, Class beanClass) {
        this(containerName, beanClass.getName(), beanClass);
    }

    public IsengardBeanDescriptor(String containerName, String instanceName, Class beanClass) {
        this.fBeanClass = beanClass;
        this.setContainerName(containerName);
        this.setInstanceName(instanceName);
        this.setBeanClassName(beanClass.getName());
    }

    public IsengardBeanDescriptor(AIsengardBean localBean) {
        this.fInstance = localBean;
        this.fBeanClass = localBean.getClass();
        this.setContainerName("controller");
        this.setInstanceName(this.fBeanClass.getName());
        this.setBeanClassName(this.fBeanClass.getName());
    }

    public AIsengardBean getInstance() {
        return this.fInstance;
    }

    public Class getBeanClass() {
        return this.fBeanClass;
    }

    public String getContainerName() {
        return this.fContainerName;
    }

    public String getPostOfficeName() {
        return this.fPostOfficeName;
    }

    public void setPostOfficeName(String postOfficeName) {
        CheckParameter.notNull("Post Office Name", postOfficeName);
        this.fPostOfficeName = postOfficeName.equals("main") ? "main" : postOfficeName;
    }

    public String getBeanClassName() {
        return this.fBeanClassName;
    }

    public String getInstanceName() {
        return this.fInstanceName;
    }

    public Object getInstanceData() {
        return this.fInstanceData;
    }

    public void setInstanceData(Object instanceData) {
        this.fInstanceData = instanceData;
    }

    public MessageServiceRegistration[] getMessageServices() {
        return this.fMessageServices;
    }

    public void setMessageServices(MessageServiceRegistration[] messageServices) {
        this.fMessageServices = messageServices == null ? kEmptyMessageServiceRegistrationArray : messageServices;
    }

    public String toString() {
        return String.valueOf(this.getInstanceName()) + " (" + this.getBeanClassName() + ")";
    }

    public static final IsengardBeanDescriptor getInitialBeanDescriptor(String container, Class beanClass) {
        Assertion.wilyAssert(beanClass != null);
        return new IsengardBeanDescriptor(container, beanClass);
    }

    public static final IsengardBeanDescriptor getInitialBeanDescriptor(String container, Class beanClass, String postOfficeName) {
        IsengardBeanDescriptor des = new IsengardBeanDescriptor(container, beanClass);
        des.setPostOfficeName(postOfficeName);
        return des;
    }

    public static final IsengardBeanDescriptor getInitialBeanDescriptor(String container, String relativeInstanceName, Class beanClass) {
        return new IsengardBeanDescriptor(container, String.valueOf(beanClass.getName()) + '/' + relativeInstanceName, beanClass);
    }

    public static final IsengardBeanDescriptor getInitialBeanDescriptor(String container, String relativeInstanceName, Class beanClass, String postOfficeName) {
        IsengardBeanDescriptor des = new IsengardBeanDescriptor(container, String.valueOf(beanClass.getName()) + '/' + relativeInstanceName, beanClass);
        des.setPostOfficeName(postOfficeName);
        return des;
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.setBeanClassName((String)in.readObject());
        this.setInstanceName((String)in.readObject());
        this.setContainerName((String)in.readObject());
        this.setPostOfficeName((String)in.readObject());
        this.setInstanceData(in.readObject());
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.getBeanClassName());
        out.writeObject(this.getInstanceName());
        out.writeObject(this.getContainerName());
        out.writeObject(this.getPostOfficeName());
        out.writeObject(this.getInstanceData());
    }

    private void setContainerName(String containerName) {
        CheckParameter.notNull("Container Name", containerName);
        this.fContainerName = containerName.equals("controller") ? "controller" : containerName;
    }

    private void setInstanceName(String instanceName) {
        CheckParameter.notNull("Instance Name", instanceName);
        this.fInstanceName = instanceName;
    }

    private void setBeanClassName(String beanClassName) {
        CheckParameter.notNull("Bean Class Name", beanClassName);
        this.fBeanClassName = beanClassName;
    }

    public Object createBean(ClassLoader classLoader) throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        if (this.fInstance != null) {
            return this.fInstance;
        }
        if (this.fBeanClass == null) {
            this.fBeanClass = Class.forName(this.fBeanClassName, true, classLoader);
        }
        return this.fBeanClass.newInstance();
    }
}

