/*
 * Decompiled with CFR 0.152.
 */
package com.wily.ui.swing;

import com.wily.properties.KUICommonStringsKeys;
import com.wily.ui.IGenericServices;
import com.wily.ui.KWilyUserInterfaceConstants;
import com.wily.ui.WilyIntegerTextField;
import com.wily.ui.WilyMultiLineLabel;
import com.wily.ui.WilyUIUtilities;
import com.wily.ui.action.IExtendedAction;
import com.wily.ui.action.ProducingModalDialogAction;
import com.wily.ui.swing.AValidatableProducingModalDialog;
import com.wily.ui.swing.ExtendedJPanel;
import com.wily.ui.swing.layout.SimpleVerticalLayout;
import com.wily.ui.swing.layout.TitleComponentPair;
import com.wily.ui.swing.layout.TitleComponentPairsPanelFactory;
import com.wily.util.IObjectFactory;
import com.wily.util.text.SimpleLocalizableMessage;
import com.wily.util.validate.IValidatable;
import com.wily.util.validate.KValidationConstants;
import com.wily.util.validate.ValidationException;
import com.wily.util.validate.ValidationUIUtilities;
import com.wily.wilyassert.Assertion;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.lang.reflect.InvocationTargetException;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JPanel;

public class ChooseDimensionDialog
extends AValidatableProducingModalDialog
implements KUICommonStringsKeys,
KWilyUserInterfaceConstants,
KValidationConstants {
    private String fPrompt;
    private ChooseDimensionPanel fChooseDimensionPanel;

    public ChooseDimensionDialog(IGenericServices genericServices, Component parentComponent, String localizedTitle, String prompt) {
        super(genericServices, parentComponent, localizedTitle);
        this.fPrompt = prompt;
        this.initUI();
    }

    private void setDimension(Dimension d) {
        this.fChooseDimensionPanel.setDimension(d);
    }

    private void initUI() {
        this.setResizable(false);
        JPanel contentPane = new JPanel();
        this.setContentPane(contentPane);
        contentPane.setLayout(new BoxLayout(contentPane, 1));
        contentPane.setBorder(kStandardEmptyBorder);
        contentPane.add(new WilyMultiLineLabel(this.fPrompt));
        this.fChooseDimensionPanel = new ChooseDimensionPanel(this.getGenericServices());
        contentPane.add(this.fChooseDimensionPanel);
        JButton cancelButton = new JButton(this.getStringLocalizer().IStringLocalizer_getLocalizedString("Cancel"));
        WilyUIUtilities.setActionForButton(this.getCancelAction(), cancelButton);
        JButton acceptButton = new JButton(this.getStringLocalizer().IStringLocalizer_getLocalizedString("OK"));
        WilyUIUtilities.setActionForButton(this.getValidateAndAcceptAction(this.getTitle(), new SimpleLocalizableMessage("InvalidDimensionValidationErrorPrefix")), acceptButton);
        this.getRootPane().setDefaultButton(acceptButton);
        JPanel buttonsBar = new JPanel(new FlowLayout(0));
        buttonsBar.add(acceptButton);
        buttonsBar.add(cancelButton);
        JPanel buttonsPanel = new JPanel();
        buttonsPanel.setLayout(new BorderLayout());
        buttonsPanel.add((Component)buttonsBar, "East");
        contentPane.add(buttonsPanel);
    }

    protected IValidatable getValidatable() {
        return this.fChooseDimensionPanel;
    }

    public Dimension getDimension() {
        return this.fChooseDimensionPanel.getDimension();
    }

    public Object getProduction() {
        return this.getDimension();
    }

    public void setConsumable(Object consumable) {
        Assertion.wilyAssert(consumable instanceof Dimension);
        this.setDimension((Dimension)consumable);
    }

    public static IExtendedAction getChooseDimensionAction(final IGenericServices genericServices, final Component parentComponent, final String localizedTitle, final String prompt) {
        IObjectFactory instantiator = new IObjectFactory(){

            public Object instantiate() throws NoSuchMethodException, InvocationTargetException, IllegalAccessException, InstantiationException {
                return new ChooseDimensionDialog(genericServices, parentComponent, localizedTitle, prompt);
            }
        };
        return new ProducingModalDialogAction(genericServices.IGenericServices_getStringLocalizer(), instantiator);
    }

    private class ChooseDimensionPanel
    extends ExtendedJPanel
    implements IValidatable {
        private static final long serialVersionUID = -9007304197107669972L;
        private IGenericServices fGenericServices;
        private WilyIntegerTextField fWidthIntegerTextField;
        private WilyIntegerTextField fHeightIntegerTextField;
        private static final int kIntegerTextFieldColumnWidth = 4;

        public ChooseDimensionPanel(IGenericServices genericServices) {
            this.fGenericServices = genericServices;
            this.initUI();
        }

        public IGenericServices getGenericServices() {
            return this.fGenericServices;
        }

        private void initUI() {
            new SimpleVerticalLayout(1);
            TitleComponentPair[] pairs = new TitleComponentPair[2];
            this.fWidthIntegerTextField = new WilyIntegerTextField(this.getGenericServices(), 4);
            String widthTitle = ChooseDimensionDialog.this.getStringLocalizer().IStringLocalizer_getLocalizedString("WidthLabel");
            pairs[0] = new TitleComponentPair(widthTitle, this.fWidthIntegerTextField);
            String heightTitle = ChooseDimensionDialog.this.getStringLocalizer().IStringLocalizer_getLocalizedString("HeightLabel");
            this.fHeightIntegerTextField = new WilyIntegerTextField(this.getGenericServices(), 4);
            pairs[1] = new TitleComponentPair(heightTitle, this.fHeightIntegerTextField);
            this.add(TitleComponentPairsPanelFactory.getDefaultTitleComponentPairsPanel(pairs, 0, ChooseDimensionDialog.this.getStringLocalizer()));
        }

        public void setDimension(Dimension d) {
            this.fWidthIntegerTextField.setIntValue(d.width);
            this.fHeightIntegerTextField.setIntValue(d.height);
        }

        public Dimension getDimension() {
            return new Dimension(this.fWidthIntegerTextField.getIntValue(), this.fHeightIntegerTextField.getIntValue());
        }

        public void IValidatable_validate() throws ValidationException {
            this.IValidatable_validate(0);
        }

        public void IValidatable_validate(int validationConstraints) throws ValidationException {
            ValidationUIUtilities.validateChildComponents(this, validationConstraints | 4 | 8, true);
        }
    }
}

