/*
 * Decompiled with CFR 0.152.
 */
package com.ca.apm.introscope.upgrade;

import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Vector;
import java.util.jar.JarFile;

public class ClassLoaderUtils {
    protected HashSet<String> fJarFileNames2Close = new HashSet();

    public void close(ClassLoader clazzLoader) {
        this.fJarFileNames2Close.clear();
        this.retrieveJarNames(clazzLoader);
        this.finalizeNativeLibs(clazzLoader);
        this.cleanupJarFileFactory();
    }

    private boolean retrieveJarNames(ClassLoader clazzLoader) {
        boolean result = false;
        if (clazzLoader == null) {
            return result;
        }
        Class<URLClassLoader> classURLClassLoader = URLClassLoader.class;
        Field field = null;
        try {
            field = classURLClassLoader.getDeclaredField("ucp");
        }
        catch (NoSuchFieldException noSuchFieldException) {}
        if (field != null) {
            field.setAccessible(true);
            Object obj = null;
            try {
                obj = field.get(clazzLoader);
            }
            catch (IllegalAccessException illegalAccessException) {}
            if (obj != null) {
                Object ucp = obj;
                field = null;
                try {
                    field = ucp.getClass().getDeclaredField("loaders");
                }
                catch (NoSuchFieldException noSuchFieldException) {}
                if (field != null) {
                    field.setAccessible(true);
                    ArrayList loaders = null;
                    try {
                        loaders = (ArrayList)field.get(ucp);
                        result = true;
                    }
                    catch (IllegalAccessException illegalAccessException) {}
                    int i = 0;
                    while (loaders != null && i < loaders.size()) {
                        obj = loaders.get(i);
                        field = null;
                        try {
                            field = obj.getClass().getDeclaredField("jar");
                        }
                        catch (NoSuchFieldException noSuchFieldException) {}
                        if (field != null) {
                            field.setAccessible(true);
                            try {
                                obj = field.get(obj);
                            }
                            catch (IllegalAccessException illegalAccessException) {}
                            if (obj instanceof JarFile) {
                                JarFile jarFile = (JarFile)obj;
                                this.fJarFileNames2Close.add(jarFile.getName());
                                try {
                                    jarFile.close();
                                }
                                catch (IOException iOException) {}
                            }
                        }
                        ++i;
                    }
                }
            }
        }
        return result;
    }

    private boolean finalizeNativeLibs(ClassLoader clazzLoader) {
        boolean res = false;
        Class<ClassLoader> classClassLoader = ClassLoader.class;
        Field nativeLibrariesField = null;
        try {
            nativeLibrariesField = classClassLoader.getDeclaredField("nativeLibraries");
        }
        catch (NoSuchFieldException noSuchFieldException) {}
        if (nativeLibrariesField == null) {
            return res;
        }
        nativeLibrariesField.setAccessible(true);
        Object obj = null;
        try {
            obj = nativeLibrariesField.get(clazzLoader);
        }
        catch (IllegalAccessException illegalAccessException) {}
        if (!(obj instanceof Vector)) {
            return res;
        }
        res = true;
        Vector nativeLibraries = (Vector)obj;
        for (Object lib : nativeLibraries) {
            Method finalize = null;
            try {
                finalize = lib.getClass().getDeclaredMethod("finalize", new Class[0]);
            }
            catch (NoSuchMethodException noSuchMethodException) {}
            if (finalize == null) continue;
            finalize.setAccessible(true);
            try {
                finalize.invoke(lib, new Object[0]);
            }
            catch (IllegalAccessException illegalAccessException) {
            }
            catch (InvocationTargetException invocationTargetException) {}
        }
        return res;
    }

    private boolean cleanupJarFileFactory() {
        boolean res = false;
        Class classJarURLConnection = null;
        try {
            classJarURLConnection = ClassLoaderUtils.classForName("sun.net.www.protocol.jar.JarURLConnection");
        }
        catch (ClassNotFoundException classNotFoundException) {}
        if (classJarURLConnection == null) {
            return res;
        }
        Field field = null;
        try {
            field = classJarURLConnection.getDeclaredField("factory");
        }
        catch (NoSuchFieldException noSuchFieldException) {}
        if (field == null) {
            return res;
        }
        field.setAccessible(true);
        Object obj2 = null;
        try {
            obj2 = field.get(null);
        }
        catch (IllegalAccessException illegalAccessException) {}
        if (obj2 == null) {
            return res;
        }
        Class<?> classJarFileFactory = obj2.getClass();
        HashMap fileCache = null;
        try {
            field = classJarFileFactory.getDeclaredField("fileCache");
            field.setAccessible(true);
            obj2 = field.get(null);
            if (obj2 instanceof HashMap) {
                fileCache = (HashMap)obj2;
            }
        }
        catch (NoSuchFieldException noSuchFieldException) {
        }
        catch (IllegalAccessException illegalAccessException) {}
        HashMap urlCache = null;
        try {
            field = classJarFileFactory.getDeclaredField("urlCache");
            field.setAccessible(true);
            obj2 = field.get(null);
            if (obj2 instanceof HashMap) {
                urlCache = (HashMap)obj2;
            }
        }
        catch (NoSuchFieldException noSuchFieldException) {
        }
        catch (IllegalAccessException illegalAccessException) {}
        if (urlCache != null) {
            HashMap urlCacheTmp = (HashMap)urlCache.clone();
            for (Object obj2 : urlCacheTmp.keySet()) {
                if (!(obj2 instanceof JarFile)) continue;
                JarFile jarFile = (JarFile)obj2;
                if (this.fJarFileNames2Close.contains(jarFile.getName())) {
                    try {
                        jarFile.close();
                    }
                    catch (IOException iOException) {}
                    if (fileCache != null) {
                        fileCache.remove(urlCache.get(jarFile));
                    }
                    urlCache.remove(jarFile);
                    continue;
                }
                try {
                    jarFile.close();
                }
                catch (IOException iOException) {}
                if (fileCache == null) continue;
                fileCache.remove(urlCache.get(jarFile));
            }
            res = true;
        } else if (fileCache != null) {
            HashMap fileCacheTmp = (HashMap)fileCache.clone();
            for (Object key : fileCacheTmp.keySet()) {
                obj2 = fileCache.get(key);
                if (!(obj2 instanceof JarFile)) continue;
                JarFile jarFile = (JarFile)obj2;
                if (this.fJarFileNames2Close.contains(jarFile.getName())) {
                    try {
                        jarFile.close();
                    }
                    catch (IOException iOException) {}
                    fileCache.remove(key);
                    continue;
                }
                try {
                    jarFile.close();
                }
                catch (IOException iOException) {}
                fileCache.remove(key);
            }
            res = true;
        }
        this.fJarFileNames2Close.clear();
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clearSunSoftCache(Class clazz, String fieldName) {
        Map cache = null;
        try {
            Field field = clazz.getDeclaredField(fieldName);
            field.setAccessible(true);
            cache = (Map)field.get(null);
        }
        catch (Throwable throwable) {}
        if (cache != null) {
            Map map = cache;
            synchronized (map) {
                cache.clear();
            }
        }
    }

    private void releaseCommonsLoggingCache(ClassLoader clazzLoader) {
        try {
            Class<?> logFactory = clazzLoader.loadClass("org.apache.commons.logging.LogFactory");
            Method release = logFactory.getMethod("release", ClassLoader.class);
            release.invoke(null, this);
        }
        catch (Throwable throwable) {}
    }

    private static Class classForName(String name) throws ClassNotFoundException {
        try {
            ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
            if (contextClassLoader != null) {
                return contextClassLoader.loadClass(name);
            }
        }
        catch (Throwable throwable) {}
        return Class.forName(name);
    }
}

