/*
 * Decompiled with CFR 0.152.
 */
package com.wily.soaextension.webmethods.triggers.nameformatter;

import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.trace.ICacheableBlameKeyNameFormatter;
import com.wily.introscope.agent.trace.InvocationData;
import com.wily.introscope.agent.trace.cas.IBlameComponent;
import com.wily.introscope.agent.trace.hc2.ABlameComponent;
import com.wily.soaextension.webmethods.util.WMUtils;
import com.wily.util.StringUtils;
import com.wily.util.feedback.IModuleFeedbackChannel;

public class TriggerNameFormatter
implements ICacheableBlameKeyNameFormatter {
    private IAgent fAgent;

    public TriggerNameFormatter(IAgent agent) {
        this.fAgent = agent;
    }

    protected IAgent getAgent() {
        return this.fAgent;
    }

    public String INameFormatter_format(String name, InvocationData data) {
        try {
            String triggername = null;
            if (name.indexOf("{triggername}", 0) >= 0) {
                triggername = this.getTriggerName(data);
                triggername = WMUtils.convertToServiceNode(triggername);
            }
            name = StringUtils.replace((String)name, (String)"{triggername}", (String)triggername);
            WMUtils.getLogger().debug("BrokerTriggerNameFormatter::Trigger name:" + triggername);
        }
        catch (Throwable bomb) {
            WMUtils.handleError(this.getAgent(), "ERROR_IN_NAMEFORMATTER", bomb);
        }
        return name;
    }

    private String getTriggerName(InvocationData data) {
        String triggername = null;
        Object invObj = data.getInvocationObject();
        try {
            if (invObj != null) {
                Object triggerNSObj = WMUtils.invokeMethodOnObject(invObj, "getNSName");
                triggername = triggerNSObj.toString();
            }
        }
        catch (Exception e) {
            WMUtils.getLogger().error(e.getMessage());
        }
        if (triggername == null || triggername.length() == 0) {
            triggername = "UnknownTrigger";
        }
        return triggername;
    }

    public Object getObjectKey(IModuleFeedbackChannel imodulefeedbackchannel, int i, InvocationData invocationdata) {
        return null;
    }

    public IBlameComponent getKey(IModuleFeedbackChannel imodulefeedbackchannel, String name, InvocationData data) {
        try {
            return ABlameComponent.getArrayInstance((Object[])new Object[]{name, this.getTriggerName(data)});
        }
        catch (Exception e) {
            imodulefeedbackchannel.error(e.getMessage());
            return null;
        }
    }
}

