/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.extension.deployer;

import com.wily.introscope.agent.extension.deployer.CompressionUtils;
import com.wily.introscope.agent.extension.deployer.DeploymentManager;
import com.wily.introscope.agent.sustainability.SustainabilityService;
import com.wily.util.feedback.IModuleFeedbackChannel;
import com.wily.util.feedback.Module;
import com.wily.util.io.ExtendedFile;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.util.ArrayList;
import java.util.Date;
import java.util.concurrent.TimeUnit;

public class DeploymentWatcher
implements Runnable {
    private final DeploymentManager fManager;
    private final Module kModule;
    private final IModuleFeedbackChannel fFeedback;
    private final ExtendedFile fExtensionsDir;
    private final ExtendedFile fDeploymentDir;
    private WatchService fWatcher;
    private Path fExtensionProfile;
    private WatchService fProfileWatcher;
    private long fProfileWatcherStamp = 0L;
    public static final long kProfileMinimumInterval = 500L;
    private long fDeploymentStartTime = 0L;
    private long fDeploymentFinishTime = 0L;
    public static long fDeploymentCounter = 0L;
    public static long fDeploymentFailureCounter = 0L;
    public static boolean fDeploymentFailed = false;

    public DeploymentWatcher(DeploymentManager manager) {
        this.fManager = manager;
        this.kModule = manager.getModule();
        this.fFeedback = manager.getFeedback();
        this.fExtensionsDir = this.fManager.getExtensionDirectory();
        this.fDeploymentDir = this.fManager.getDeployDirectory();
        this.fExtensionProfile = FileSystems.getDefault().getPath(this.fManager.getExtensionProfileResource().IResource_getLocation(), new String[0]);
    }

    public void start() {
        try {
            this.fWatcher = FileSystems.getDefault().newWatchService();
            Path deployDir = FileSystems.getDefault().getPath(this.fDeploymentDir.getAbsolutePath(), new String[0]);
            deployDir.register(this.fWatcher, StandardWatchEventKinds.ENTRY_CREATE, StandardWatchEventKinds.ENTRY_MODIFY, StandardWatchEventKinds.ENTRY_DELETE);
            this.fProfileWatcher = FileSystems.getDefault().newWatchService();
            Path extensionProfileDir = FileSystems.getDefault().getPath(this.fExtensionsDir.getAbsolutePath(), new String[0]);
            extensionProfileDir.register(this.fProfileWatcher, StandardWatchEventKinds.ENTRY_MODIFY);
        }
        catch (IOException e) {
            this.fFeedback.error(this.kModule, "Failed to create filesystem watcher service: " + e.getMessage());
            this.fFeedback.debug(this.kModule, "Watcher creation failed", (Throwable)e);
        }
        Thread t = new Thread((Runnable)this, "Deployment Watcher");
        t.setDaemon(true);
        t.start();
        Thread t2 = new Thread(new Runnable(){

            @Override
            public void run() {
                DeploymentWatcher.this.profileWatcherRun();
            }
        }, "Extension Profile Watcher");
        t2.setDaemon(true);
        t2.start();
    }

    public void profileWatcherRun() {
        while (true) {
            try {
                while (true) {
                    long now;
                    WatchKey key = this.fProfileWatcher.take();
                    boolean fileChanged = false;
                    for (WatchEvent<?> event : key.pollEvents()) {
                        WatchEvent.Kind<?> kind = event.kind();
                        WatchEvent<?> ev = event;
                        Path fileName = (Path)ev.context();
                        this.fFeedback.debug(this.kModule, "ProfileWatcer noticed " + kind.name() + ": " + fileName.getFileName());
                        if (!fileName.getFileName().equals(this.fExtensionProfile.getFileName())) continue;
                        fileChanged = true;
                    }
                    key.reset();
                    if (!fileChanged || this.fProfileWatcherStamp >= (now = System.currentTimeMillis())) continue;
                    this.fFeedback.info(this.kModule, "Notifying ConfgirationWatcher.");
                    this.fManager.notifyConfigurationWatcher();
                    this.fProfileWatcherStamp = now + 500L;
                }
            }
            catch (InterruptedException interruptedException) {
                continue;
            }
            break;
        }
    }

    private boolean lockDeploymentDir(boolean bootLoad) {
        if (bootLoad) {
            int i = 0;
            while (i < 5) {
                this.fFeedback.debug(this.kModule, "Trying to get exclusive deploy lock");
                if (this.fManager.getDeploymenLock().tryExclusiveLock() != null) {
                    this.fFeedback.debug(this.kModule, "Acquired exclusive deploy lock");
                    return true;
                }
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException interruptedException) {}
                ++i;
            }
            this.fFeedback.debug(this.kModule, "Failed to get exclusive deploy lock");
            return false;
        }
        this.fFeedback.debug(this.kModule, "Getting exclusive deploy lock");
        this.fManager.getDeploymenLock().acquireExclusiveLock();
        this.fFeedback.debug(this.kModule, "Acquired exclusive deploy lock");
        return true;
    }

    private boolean releaseDeploymentDir() {
        this.fFeedback.debug(this.kModule, "Releasing exclusive deploy lock");
        this.fManager.getDeploymenLock().releaseLock();
        this.fFeedback.debug(this.kModule, "Released exclusive deploy lock");
        return true;
    }

    public void checkFilesAndDeploy(boolean bootLoad) {
        SustainabilityService sustainabilityService = SustainabilityService.getSustainabilityServiceInstance();
        if (sustainabilityService != null) {
            sustainabilityService.setOptionalExtensionsDeploymentStatus(1);
        }
        this.fDeploymentStartTime = System.currentTimeMillis();
        if (!this.lockDeploymentDir(bootLoad)) {
            return;
        }
        try {
            if (this.fDeploymentDir != null && this.fDeploymentDir.isDirectory()) {
                FilenameFilter filterOnlyExtensions = new FilenameFilter(){

                    @Override
                    public boolean accept(File dir, String name) {
                        return name.endsWith(".tar.gz");
                    }
                };
                File[] files = this.fDeploymentDir.listFiles(filterOnlyExtensions);
                ArrayList<DeploymentManager.ExtensionDeploymentDescriptor> newExtensions = new ArrayList<DeploymentManager.ExtensionDeploymentDescriptor>(10);
                ArrayList<DeploymentManager.ExtensionDeploymentDescriptor> upgradedExtensions = new ArrayList<DeploymentManager.ExtensionDeploymentDescriptor>(10);
                ArrayList<DeploymentManager.ExtensionDeploymentDescriptor> deletedExtensions = new ArrayList<DeploymentManager.ExtensionDeploymentDescriptor>(10);
                int i = 0;
                while (i < files.length) {
                    String archive = files[i].getName();
                    int suffixIndex = archive.indexOf(".tar.gz");
                    if (suffixIndex >= 1) {
                        String targetDirName = archive.substring(0, suffixIndex);
                        ExtendedFile targetDir = new ExtendedFile(this.fExtensionsDir + File.separator + targetDirName);
                        DeploymentManager.ExtensionDeploymentDescriptor desc = new DeploymentManager.ExtensionDeploymentDescriptor();
                        desc.fTarGzFile = new ExtendedFile(files[i]);
                        desc.fTargetDirectory = targetDir;
                        desc.fName = targetDirName;
                        desc.fChecksum = CompressionUtils.getMD5Checksum(desc.fTarGzFile);
                        Date now = new Date();
                        desc.fInstallTime = now.toString();
                        this.fFeedback.debug(this.kModule, "DeploymentWatcher checking " + archive);
                        if (desc.fChecksum != null && !targetDir.exists()) {
                            newExtensions.add(desc);
                            this.fFeedback.info(this.kModule, "DeploymentWatcher found new extension " + archive);
                            this.fFeedback.info(this.kModule, "DeploymentWatcher target directory is " + targetDir.getAbsolutePath());
                        }
                    }
                    ++i;
                }
                File[] dirs = this.fExtensionsDir.listFiles();
                int i2 = 0;
                while (i2 < dirs.length) {
                    ExtendedFile deploymentFile;
                    if (dirs[i2].isDirectory() && (deploymentFile = this.fManager.getDeploymentDescriptorFile(dirs[i2].getName())).exists()) {
                        DeploymentManager.ExtensionDeploymentDescriptor desc = this.fManager.readDeploymentFile(deploymentFile);
                        if (!desc.fTarGzFile.exists()) {
                            this.fFeedback.info(this.kModule, "DeploymentWatcher found deleted extension " + desc.fTarGzFile.getAbsolutePath());
                            deletedExtensions.add(desc);
                        } else {
                            String newChecksum = CompressionUtils.getMD5Checksum(desc.fTarGzFile);
                            if (newChecksum != null && !newChecksum.equals(desc.fChecksum)) {
                                this.fFeedback.info(this.kModule, "DeploymentWatcher found upgraded extension " + desc.fTarGzFile.getAbsolutePath());
                                desc.fChecksum = newChecksum;
                                upgradedExtensions.add(desc);
                            }
                            if (bootLoad && desc.fStatus == 1) {
                                newExtensions.add(desc);
                            }
                        }
                    }
                    ++i2;
                }
                this.fManager.deployExtensions(newExtensions, upgradedExtensions, deletedExtensions, bootLoad);
            }
            this.fDeploymentFinishTime = System.currentTimeMillis();
            sustainabilityService = SustainabilityService.getSustainabilityServiceInstance();
            if (sustainabilityService != null) {
                sustainabilityService.setOptionalExtensionsLastDeploymentCycleTime(this.fDeploymentFinishTime - this.fDeploymentStartTime);
                sustainabilityService.setOptionalExtensionsDeploymentStatus(0);
                sustainabilityService.setOptionalExtensionsDeploymentCount(fDeploymentCounter);
                sustainabilityService.setOptionalExtensionsSuccessfulDeploymentCount(fDeploymentCounter - fDeploymentFailureCounter);
                sustainabilityService.setOptionalExtensionsFailedDeploymentCount(fDeploymentFailureCounter);
                sustainabilityService.setOptionalExtensionsTotalMetricCount(this.calculateTotalExtensions());
            }
        }
        finally {
            this.releaseDeploymentDir();
        }
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void run() {
        try {
            Thread.sleep(15000L);
        }
        catch (InterruptedException v0) {}
        try {
            while (true) {
                block17: {
                    try {
                        while (true) {
                            key = this.fWatcher.poll(30L, TimeUnit.SECONDS);
                            fileChanged = false;
                            if (key == null) break block17;
                            for (WatchEvent<?> event : key.pollEvents()) {
                                kind = event.kind();
                                ev = event;
                                fileName = (Path)ev.context();
                                if (fileName.toString().endsWith(".tar.gz")) {
                                    fileChanged = true;
                                    this.fFeedback.info(this.kModule, "Noticed " + kind.name() + ": " + fileName.getFileName());
                                    continue;
                                }
                                this.fFeedback.debug(this.kModule, "Noticed " + kind.name() + ": " + fileName.getFileName());
                            }
                            key.reset();
                            if (fileChanged) ** GOTO lbl35
                        }
lbl-1000:
                        // 1 sources

                        {
                            key = this.fWatcher.poll(1L, TimeUnit.SECONDS);
                            if (key == null) continue;
                            var3_6 = key.pollEvents().iterator();
                            while (var3_6.hasNext()) {
                                var3_6.next();
                            }
                            key.reset();
lbl35:
                            // 3 sources

                            ** while (key != null)
                        }
lbl36:
                        // 1 sources

                    }
                    catch (InterruptedException v1) {}
                }
                this.checkFilesAndDeploy(false);
            }
        }
        catch (ThreadDeath td) {
            throw td;
        }
        catch (Throwable t) {
            try {
                this.fFeedback.error(this.kModule, "Error occured in Extension Deployer, the feature is disabled: " + t.getMessage());
                if (this.fFeedback.isDebugEnabled(this.kModule)) {
                    this.fFeedback.debug(this.kModule, "Extension Deployer Thread uncaught exception: ", t);
                }
            }
            catch (ThreadDeath td2) {
                throw td2;
            }
            catch (Throwable v2) {}
            return;
        }
    }

    public long calculateTotalExtensions() {
        FilenameFilter filterOnlyExtensions = new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return !name.equalsIgnoreCase("Extensions.profile") && !name.equalsIgnoreCase("deploy") && !name.equalsIgnoreCase("backup");
            }
        };
        return this.fExtensionsDir.listFiles(filterOnlyExtensions).length;
    }
}

