/*
 * Decompiled with CFR 0.152.
 */
package com.wily.ui.widget;

import com.wily.ui.KWilyUserInterfaceConstants;
import com.wily.ui.RadialMeasurements;
import com.wily.ui.widget.ATrafficLightWidget;
import com.wily.wilyassert.Assertion;
import com.wily.wilyassert.SwingAssertion;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.RenderingHints;

public class SingleLightWidget
extends ATrafficLightWidget
implements KWilyUserInterfaceConstants {
    private boolean fDrawCentered = false;

    public SingleLightWidget() {
    }

    public SingleLightWidget(int state) {
        super(state);
    }

    public void setDrawCentered(boolean drawCentered) {
        this.fDrawCentered = drawCentered;
    }

    public Dimension getPreferredSize() {
        return new Dimension(90, 90);
    }

    public synchronized void draw(Graphics g, Dimension d) {
        SwingAssertion.assertSwingSafe("must draw on the swing thread");
        Graphics2D g2D = (Graphics2D)g;
        g2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        RadialMeasurements lampMeasurements = this.getLampMeasurements(d);
        switch (this.fState) {
            case 460: {
                this.drawHoleLamp(g2D, lampMeasurements);
                break;
            }
            case 459: {
                this.drawGreenLamp(g2D, lampMeasurements, true);
                break;
            }
            case 458: {
                this.drawYellowLamp(g2D, lampMeasurements, true);
                break;
            }
            case 457: {
                this.drawRedLamp(g2D, lampMeasurements, true);
                break;
            }
            case 461: {
                this.drawGrayLamp(g2D, lampMeasurements, true);
                break;
            }
            default: {
                Assertion.wilyAssert("unexpected lamp type!");
                this.drawRedLamp(g2D, lampMeasurements, true);
            }
        }
    }

    private RadialMeasurements getLampMeasurements(Dimension d) {
        int maxRadius = d.height > d.width ? d.width / 2 : d.height / 2;
        Point center = new Point(maxRadius, maxRadius);
        if (this.fDrawCentered) {
            if (d.width > d.height) {
                center.translate((d.width - d.height) / 2, 0);
            } else {
                center.translate(0, (d.height - d.width) / 2);
            }
        }
        return new RadialMeasurements(center, maxRadius - 3);
    }
}

