/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.appmap.agent;

import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.blame.ComponentTracer;
import com.wily.introscope.agent.blame.CompoundComponentParameterCallback;
import com.wily.introscope.agent.blame.IAppMapStack;
import com.wily.introscope.agent.blame.IBlameStack;
import com.wily.introscope.agent.blame.IComponentParameterCallback;
import com.wily.introscope.agent.blame.IStackType;
import com.wily.introscope.agent.blame.ParameterGatheringCallback;
import com.wily.introscope.agent.blame.PreformedCallback;
import com.wily.introscope.agent.transactiontrace.SharedCrossProcessData;
import com.wily.introscope.appmap.agent.AppDef;
import com.wily.introscope.appmap.agent.AppMapService;
import com.wily.introscope.appmap.agent.trace.AUniqueCandidate;
import com.wily.introscope.appmap.agent.trace.AppMapCrossProcessHelper;
import com.wily.introscope.appmap.agent.trace.AppMapNameHelperFactory;
import com.wily.introscope.appmap.agent.trace.MetricNamesThreadLocalHelper;
import com.wily.introscope.spec.agent.beans.appmap.IAppMapDecisionSupportBean;
import com.wily.introscope.spec.agent.beans.appmap.IOwnerRepository;
import com.wily.introscope.spec.server.appmap.IAppMapOwner;
import com.wily.introscope.spec.server.appmap.impl.AAppMapEdge;
import com.wily.introscope.spec.server.appmap.impl.AbstractAppMapElement;
import com.wily.introscope.spec.server.transactiontrace.IAppMapStackCollectDataStructure;
import com.wily.introscope.spec.server.transactiontrace.SequenceId;
import com.wily.introscope.stat.blame.BlameStackSnapshot;
import com.wily.util.feedback.IModuleFeedbackChannel;
import com.wily.util.feedback.Module;
import com.wily.util.text.IStringLocalizer;
import com.wily.wilyassert.Assertion;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;

public class AppMapStack
implements IBlameStack,
IAppMapStack {
    private static final Module kModule = new Module("AppMapStack");
    private StackLinkedList fComponentStack;
    private HashSet fDelayedEdgeSet;
    private final IStackType fType;
    private final String fTypeString;
    private final String fOwnerString;
    private IAgent fAgent;
    private final boolean fShouldRun;
    private String fLastPoppedComponent;
    private final IAppMapDecisionSupportBean fOracle;
    private static ThreadLocal fChildInChildParentRelation = new ThreadLocal();

    public AppMapStack(IAgent agent, IStackType type, String typeString, String ownerString, IAppMapDecisionSupportBean oracle) {
        this.fAgent = agent;
        this.fType = type;
        this.fTypeString = typeString;
        this.fOwnerString = ownerString;
        this.fComponentStack = new StackLinkedList();
        this.fDelayedEdgeSet = new HashSet();
        this.fOracle = oracle;
        this.fShouldRun = this.fOracle != null;
        this.fLastPoppedComponent = null;
    }

    public void setEndBoundary(String component) {
    }

    public void setFrontBoundary(String component) {
    }

    public void endBoundaryPopped(String component) {
    }

    public void frontBoundaryPopped(String component) {
    }

    public void IBlameStack_addComponent(String component) {
    }

    public void IBlameStack_addComponent(String component, String paramName, String paramValue) {
    }

    public void IBlameStack_addComponent(String component, IComponentParameterCallback callback) {
    }

    public void IBlameStack_addExtraParameter(String paramName, String paramValue) {
        TransactionStackElement top = this.peek();
        if (top != null) {
            top.addCallbackParams(paramName, paramValue);
        }
    }

    public void addRootParameter(String key, String value) {
        TransactionStackElement root;
        if (this.fComponentStack != null && (root = this.fComponentStack.getHead()) != null) {
            root.addCallbackParams(key, value);
        }
    }

    private void addCallbackParameters(IComponentParameterCallback callback, Map map) {
        try {
            if (callback != null) {
                callback.IComponentParameterCallback_addParameters(map);
            }
        }
        catch (ThreadDeath td) {
            throw td;
        }
        catch (Throwable t) {
            try {
                this.getFeedback().verbose(kModule, this.getLocalizer().IStringLocalizer_getLocalizedString("Agent_Transaction_Trace_Error_Accessing_Parameters"));
                this.getFeedback().verbose(t);
            }
            catch (ThreadDeath td2) {
                throw td2;
            }
            catch (Throwable throwable) {}
        }
    }

    private boolean evaluateCrossProcessUniqueness(IAppMapDecisionSupportBean.IUniqueCandidate component) {
        return this.getOracleInstance().evaluateCrossProcessUniqueness(component);
    }

    private boolean evaluateDependencyUniqueness(IAppMapDecisionSupportBean.IUniqueCandidate component) {
        return this.getOracleInstance().evaluateDependencyUniqueness(component);
    }

    private void handleAdd(String component, IComponentParameterCallback callback, IAppMapOwner currentOwner) {
        TransactionStackElement element = new TransactionStackElement(this, component, callback, currentOwner);
        this.push(element);
    }

    private void handleAdd(String component, Map parameters, IComponentParameterCallback callback, IAppMapOwner currentOwner) {
        TransactionStackElement element = new TransactionStackElement(this, component, parameters, callback, currentOwner);
        this.push(element);
    }

    public void IBlameStack_removeComponent(String component) {
    }

    private void handleRemove(String component, IComponentParameterCallback endCallback, IAppMapDecisionSupportBean.ICallBackOnSent callbackOnError, boolean handleCrossCorrelation) {
        if (this.getFeedback().isTraceEnabled(kModule)) {
            this.getFeedback().trace(kModule, "(" + this.fOwnerString + ") handleRemove " + component + " cacheFlag " + AppMapStack.getSharedProcessDataCache().getDependencyPropagationFlag());
        }
        Assertion.wilyAssert((boolean)false);
        if (!this.fComponentStack.isEmpty()) {
            IAppMapOwner owner;
            IOwnerRepository owners;
            boolean areMetricsEnabled = AppMapService.areMetricsEnabled();
            TransactionStackElement element = this.pop();
            if (!this.fComponentStack.isEmpty()) {
                this.fLastPoppedComponent = component;
            } else {
                if (this.getFeedback().isTraceEnabled(kModule)) {
                    this.getFeedback().trace(kModule, "(" + this.fOwnerString + ") is now empty.");
                }
                this.fLastPoppedComponent = null;
            }
            Assertion.wilyAssert((boolean)false);
            element.markDependency();
            TransactionStackElement parent = this.peek();
            SharedCrossProcessData cache = AppMapStack.getSharedProcessDataCache();
            if (parent != null) {
                parent.markDependency();
                if (handleCrossCorrelation) {
                    AppMapCrossProcessHelper.setCallingComponentName(cache, this.getStackType(), parent.getComponent());
                    AppMapCrossProcessHelper.setCallingComponentType(cache, (String)parent.getParameters().get("nodeType"));
                }
            } else if (handleCrossCorrelation) {
                AppMapCrossProcessHelper.setCallingComponentName(cache, this.getStackType(), null);
                AppMapCrossProcessHelper.setCallingComponentType(cache, null);
            }
            if ((owners = this.getOracleInstance().getCurrentOwnerList(this.fOwnerString)) == null || owners.isEmpty()) {
                return;
            }
            Map uniqueMetrics = null;
            if (areMetricsEnabled && this.getStackType() == AppMapService.kStackTypeClassMethodApp) {
                uniqueMetrics = this.getUniqueMetrics(element);
            }
            String level = this.fTypeString;
            boolean isParentLevel = this.getOracleInstance().isParentLevel(level);
            if (owners.hasLocalOwners()) {
                Iterator locals = owners.getCurrentLocalOwners().iterator();
                while (locals.hasNext()) {
                    owner = (IAppMapOwner)locals.next();
                    if (owner.isDelayedInstance()) {
                        this.fDelayedEdgeSet.add(new DelayedEdge(element, parent));
                        continue;
                    }
                    if (!this.fDelayedEdgeSet.isEmpty()) {
                        Iterator i = this.fDelayedEdgeSet.iterator();
                        while (i.hasNext()) {
                            DelayedEdge e = (DelayedEdge)i.next();
                            this.handleOwnersEdges(cache, e.getElement(), e.getParent(), null, isParentLevel, owner, owners, false, endCallback, callbackOnError);
                        }
                        this.fDelayedEdgeSet.clear();
                    }
                    this.handleOwnersEdges(cache, element, parent, uniqueMetrics, isParentLevel, owner, owners, false, endCallback, callbackOnError);
                }
            }
            if (owners.hasRemoteOwners()) {
                Iterator remotes = owners.getCurrentRemoteOwners().iterator();
                while (remotes.hasNext()) {
                    owner = (IAppMapOwner)remotes.next();
                    this.handleOwnersEdges(cache, element, parent, uniqueMetrics, isParentLevel, owner, owners, true, endCallback, callbackOnError);
                }
            }
        }
    }

    private IAppMapOwner getCurrentOwner() {
        return AppMapNameHelperFactory.getCurrentApplicationOwner();
    }

    private void handleOwnersEdges(SharedCrossProcessData cache, TransactionStackElement element, TransactionStackElement parent, Map uniqueMetrics, boolean isParentLevel, IAppMapOwner owner, IOwnerRepository repository, boolean isRemote, IComponentParameterCallback endCallback, final IAppMapDecisionSupportBean.ICallBackOnSent callbackOnError) {
        IAppMapStackCollectDataStructure childCandidate;
        boolean childWasSet;
        IAppMapStackCollectDataStructure head = null;
        TailCallbackWrapper callback = this.evaluateEdgeUniqueness(cache, parent, element, owner, isRemote, repository, endCallback, callbackOnError);
        boolean isEdgeUnique = callback != null;
        boolean isMetricsUnique = uniqueMetrics != null;
        boolean bl = childWasSet = fChildInChildParentRelation.get() != null;
        if (isMetricsUnique || isEdgeUnique || isParentLevel && childWasSet) {
            head = this.createVertexFromElement(element, endCallback);
        }
        if (head == null) {
            return;
        }
        if (isMetricsUnique) {
            AppMapStack.reportMetricsForVertex(this.getOracleInstance(), head, uniqueMetrics, callbackOnError);
            fChildInChildParentRelation.set(head);
        }
        if (isParentLevel && (childCandidate = (IAppMapStackCollectDataStructure)fChildInChildParentRelation.get()) != null) {
            final AUniqueCandidate uniqueCandidate = AUniqueCandidate.getInstance(childCandidate.getUniqueKeyObject(), head.getUniqueKeyObject());
            if (this.getOracleInstance().evaluateParentChildUniqueness((IAppMapDecisionSupportBean.IUniqueCandidate)uniqueCandidate)) {
                this.getOracleInstance().reportParentChildRelation(new IAppMapDecisionSupportBean.ICallBackOnSent(){

                    public void onSent(boolean sucess) {
                        if (!sucess) {
                            AppMapStack.this.getOracleInstance().revertParentChildUniqueness(uniqueCandidate);
                        }
                        if (callbackOnError != null) {
                            callbackOnError.onSent(sucess);
                        }
                    }
                }, head, childCandidate);
            }
        }
        if (!isMetricsUnique) {
            fChildInChildParentRelation.set(null);
        }
        if (isEdgeUnique) {
            this.reportEdge(callback.callback, head, callback.fTail, owner, head.getOwner(), callback.fTail.getOwner());
        }
    }

    private TailCallbackWrapper evaluateEdgeUniqueness(SharedCrossProcessData cache, TransactionStackElement parent, TransactionStackElement element, IAppMapOwner owner, boolean isRemote, IOwnerRepository repository, IComponentParameterCallback endCallback, final IAppMapDecisionSupportBean.ICallBackOnSent callbackOnError) {
        if (parent == null) {
            String headName = null;
            String headType = null;
            String headHost = null;
            String headProcess = null;
            String headAgent = null;
            IAppMapOwner headOwner = null;
            if (isRemote) {
                headName = AppMapCrossProcessHelper.getCallingComponentName(cache, this.getStackType());
                headType = AppMapCrossProcessHelper.getCallingComponentType(cache);
                headHost = AppMapCrossProcessHelper.getCallingHost(cache);
                headProcess = AppMapCrossProcessHelper.getCallingProcess(cache);
                headAgent = AppMapCrossProcessHelper.getCallingAgent(cache);
                headOwner = repository.getLastRemoteOwner();
            } else {
                headName = "OutsideWorld";
                headType = "External";
                headHost = "Unknown";
                headProcess = "Unknown";
                headAgent = "None";
                headOwner = AppDef.getNullInstance();
            }
            String headLevel = this.fTypeString;
            AUniqueCandidate externalUniqueCandidate = AUniqueCandidate.getInstance(headName, headType, headLevel, headHost, headProcess, headAgent);
            final AUniqueCandidate keyInMap = AUniqueCandidate.getInstance(element.getComponent(), externalUniqueCandidate, owner);
            if (this.evaluateCrossProcessUniqueness(keyInMap)) {
                if (this.getFeedback().isTraceEnabled(kModule)) {
                    this.getFeedback().trace(kModule, "parent is null and crossprocess is unique");
                }
                Map userproperties = this.getUserDefinedProperties(endCallback);
                IAppMapStackCollectDataStructure head = this.getOracleInstance().getNode(headHost, headProcess, headAgent, headName, headType, headLevel, false, userproperties, headOwner);
                IAppMapDecisionSupportBean.ICallBackOnSent callback = new IAppMapDecisionSupportBean.ICallBackOnSent(){

                    public void onSent(boolean success) {
                        if (!success) {
                            AppMapStack.this.getOracleInstance().revertCrossProcessUniqueness((IAppMapDecisionSupportBean.IUniqueCandidate)keyInMap);
                        }
                        if (callbackOnError != null) {
                            callbackOnError.onSent(success);
                        }
                    }
                };
                return new TailCallbackWrapper(head, callback);
            }
            if (this.getFeedback().isTraceEnabled(kModule)) {
                this.getFeedback().trace(kModule, "Edge is not unique. Skipping it.");
            }
            return null;
        }
        final IAppMapDecisionSupportBean.IUniqueCandidate dependencyUniqueCandidate = this.getUniqueCandidateDependency(parent, element, owner);
        if (this.evaluateDependencyUniqueness(dependencyUniqueCandidate)) {
            Object headTypeObj = null;
            Map params = null;
            if (parent != null && (params = parent.getParameters()) != null) {
                headTypeObj = params.get("nodeType");
            }
            if (headTypeObj == null) {
                return null;
            }
            String headType = headTypeObj.toString();
            String headLevel = this.fTypeString;
            Map userproperties = this.getUserDefinedProperties(endCallback);
            IAppMapStackCollectDataStructure head = this.getOracleInstance().getNode(null, null, null, parent.getComponent(), headType, headLevel, false, userproperties, parent.fOwner);
            IAppMapDecisionSupportBean.ICallBackOnSent callback = new IAppMapDecisionSupportBean.ICallBackOnSent(){

                public void onSent(boolean success) {
                    if (!success) {
                        AppMapStack.this.getOracleInstance().revertDependencyUniqueness(dependencyUniqueCandidate);
                    }
                    if (callbackOnError != null) {
                        callbackOnError.onSent(success);
                    }
                }
            };
            return new TailCallbackWrapper(head, callback);
        }
        if (this.getFeedback().isTraceEnabled(kModule)) {
            this.getFeedback().trace(kModule, "Edge is not unique. Skipping it.");
        }
        return null;
    }

    private Map getUniqueMetrics(TransactionStackElement element) {
        Map result = MetricNamesThreadLocalHelper.evaluateMetrixUniquenes(this.getOracleInstance());
        if (this.getFeedback().isTraceEnabled(kModule)) {
            this.getFeedback().trace(kModule, "Evaluating metrix uniquenes: " + element.getComponent() + ";" + result);
        }
        return result;
    }

    private IAppMapStackCollectDataStructure createVertexFromElement(TransactionStackElement element, IComponentParameterCallback endCallback) {
        Object typeObj = null;
        Map params = null;
        if (element != null && (params = element.getParameters()) != null) {
            typeObj = params.get("nodeType");
        }
        if (typeObj == null) {
            return null;
        }
        String type = typeObj.toString();
        Map userproperties = this.getUserDefinedProperties(endCallback);
        IAppMapStackCollectDataStructure tail = this.getOracleInstance().getNode(null, null, null, element.getComponent(), type, this.fTypeString, true, userproperties, element.fOwner);
        return tail;
    }

    private Map getUserDefinedProperties(IComponentParameterCallback endCallback) {
        HashMap userproperties = new HashMap();
        endCallback.IComponentParameterCallback_addParameters(userproperties);
        return userproperties;
    }

    private void reportEdge(IAppMapDecisionSupportBean.ICallBackOnSent callback, IAppMapStackCollectDataStructure head, IAppMapStackCollectDataStructure tail, IAppMapOwner owner, IAppMapOwner headOwner, IAppMapOwner tailOwner) {
        head = (IAppMapStackCollectDataStructure)head.cloneObject();
        AAppMapEdge edge = (AAppMapEdge)this.getOracleInstance().getEdge(owner, head, tail, headOwner, tailOwner);
        if (edge != null) {
            this.includeCorParams(edge.getParameters());
            this.includeExternalBizParams(head, tail, edge.getUserDefinedProperties());
            ArrayList<AAppMapEdge> myList = new ArrayList<AAppMapEdge>();
            myList.add(edge);
            this.getOracleInstance().reportEdge(callback, myList);
        }
    }

    private void includeExternalBizParams(IAppMapStackCollectDataStructure head, IAppMapStackCollectDataStructure tail, Map userDefinedProperties) {
        Map<String, String> headProp;
        if (head != null && (headProp = ((AbstractAppMapElement)head).getUserDefinedProperties()) != null) {
            Map<String, String> tailProp;
            if (headProp.get("x-apm-bt") != null) {
                userDefinedProperties.putAll((Map)((Object)headProp.get("x-apm-bt")));
                headProp.remove("x-apm-bt");
                if (tail != null && (tailProp = ((AbstractAppMapElement)tail).getUserDefinedProperties()) != null) {
                    tailProp.remove("x-apm-bt");
                }
            }
            if (headProp.get("x-apm-bt") != null) {
                userDefinedProperties.putAll((Map)((Object)headProp.get("x-apm-bt")));
                headProp.remove("x-apm-bt");
                if (tail != null && (tailProp = ((AbstractAppMapElement)tail).getUserDefinedProperties()) != null) {
                    tailProp.remove("x-apm-bt");
                }
            }
        }
    }

    private IAppMapDecisionSupportBean.IUniqueCandidate getUniqueCandidateDependency(TransactionStackElement parent, TransactionStackElement child, IAppMapOwner owner) {
        return AUniqueCandidate.getInstance(parent.getComponent(), child.getComponent(), this.fTypeString, owner);
    }

    public BlameStackSnapshot IBlameStack_getSnapshot(String component) {
        return BlameStackSnapshot.kEmptyBlameStackSnapshot;
    }

    public boolean IBlameStack_isEmpty() {
        return this.fComponentStack.isEmpty();
    }

    public void IBlameStack_tearDown() {
        this.fComponentStack.clear();
        this.fDelayedEdgeSet.clear();
        fChildInChildParentRelation.set(null);
    }

    public boolean noteBoundaryError() {
        return false;
    }

    private TransactionStackElement peek() {
        return this.fComponentStack.getTail();
    }

    private void push(TransactionStackElement component) {
        this.fComponentStack.add(component);
    }

    private TransactionStackElement pop() {
        Assertion.wilyAssert((boolean)false);
        return this.fComponentStack.removeLast();
    }

    public String[] getDefaultBackendData() {
        return null;
    }

    public void setDefaultBackendComponent(String componentToReplace, String backendComponent) {
    }

    public BlameStackSnapshot getDefaultBackendSnapshot() {
        return BlameStackSnapshot.kEmptyBlameStackSnapshot;
    }

    public int getSize() {
        return this.fComponentStack.getSize();
    }

    public void removeMapComponent(IStackType type, String component) {
        if (this.fShouldRun && type == this.getStackType()) {
            this.handleRemove(component, IComponentParameterCallback.kNullCallback, null, true);
        }
    }

    public void addMapComponent(IStackType type, String component) {
        if (this.fShouldRun && type == this.getStackType()) {
            this.handleAdd(component, IComponentParameterCallback.kNullCallback, this.getCurrentOwner());
        }
    }

    public void addMapComponent(IStackType type, String component, String paramName, String paramVal) {
        if (this.fShouldRun && type == this.getStackType()) {
            this.handleAdd(component, (IComponentParameterCallback)new AppMapPreformedCallback(paramName, paramVal), this.getCurrentOwner());
        }
    }

    public boolean getHeadFilteringStatus() {
        return false;
    }

    public boolean shouldCurrentTraceBePropagated() {
        return false;
    }

    private void includeCorParams(Map parameters) {
        String corid;
        SharedCrossProcessData cache = AppMapStack.getSharedProcessDataCache();
        if (cache != null && (corid = cache.getCorrelationID()) != null) {
            String seqid;
            parameters.put("CorCrossProcessData", corid);
            SequenceId id = cache.getSeqID();
            if (id != null && (seqid = id.getSequenceId()) != null) {
                parameters.put("SeqNoCrossProcessData", seqid);
            }
            String calledByNodeId = cache.getIncomingCalledByNodeId();
            parameters.put("CallerName", calledByNodeId);
        }
    }

    public void directAddMapComponent(String component, HashMap parameters) {
        this.handleAdd(component, parameters, (IComponentParameterCallback)new AppMapPreformedCallback(parameters), this.getCurrentOwner());
    }

    public void addMapComponent(IStackType type, String component, HashMap params) {
        if (this.fShouldRun && type == this.getStackType()) {
            SharedCrossProcessData cache = AppMapStack.getSharedProcessDataCache();
            this.handleAdd(component, params, (IComponentParameterCallback)new AppMapPreformedCallback(params), this.getCurrentOwner());
            AppMapCrossProcessHelper.setCallingComponentName(cache, this.getStackType(), component);
            AppMapCrossProcessHelper.setCallingComponentType(cache, (String)params.get("nodeType"));
            this.fLastPoppedComponent = null;
        }
    }

    public void removeMapComponent(IStackType type, String component, IComponentParameterCallback endCallback) {
        if (this.fShouldRun && type == this.getStackType()) {
            this.handleRemove(component, endCallback, null, true);
        }
    }

    public void directRemoveMapComponent(String component, IComponentParameterCallback endCallback, IAppMapDecisionSupportBean.ICallBackOnSent callbackOnError) {
        if (this.fShouldRun) {
            if (endCallback == null) {
                this.handleRemove(component, IComponentParameterCallback.kNullCallback, callbackOnError, false);
            } else {
                this.handleRemove(component, endCallback, callbackOnError, false);
            }
        }
    }

    public void directRemoveMapComponent(String component, IComponentParameterCallback callback) {
        this.directRemoveMapComponent(component, callback, null);
    }

    public boolean hasFrontBoundary() {
        return false;
    }

    private IModuleFeedbackChannel getFeedback() {
        return this.fAgent.IAgent_getModuleFeedback();
    }

    private IStringLocalizer getLocalizer() {
        return this.fAgent.IAgent_getStringLocalizer();
    }

    private IAppMapDecisionSupportBean getOracleInstance() {
        return this.fOracle;
    }

    public String toString() {
        String head = null;
        String tail = null;
        TransactionStackElement headEle = this.fComponentStack.getHead();
        TransactionStackElement tailEle = this.fComponentStack.getTail();
        if (headEle != null) {
            head = headEle.getComponent();
        }
        if (tailEle != null) {
            tail = tailEle.getComponent();
        }
        return "[AppMapStackStack: head=" + head + ", tail=" + tail + "]";
    }

    protected static SharedCrossProcessData getSharedProcessDataCache() {
        return ComponentTracer.staticGetCrossProcessDataCache();
    }

    private static void reportMetricsForVertex(final IAppMapDecisionSupportBean oracle, IAppMapStackCollectDataStructure tail, Map metrics, final IAppMapDecisionSupportBean.ICallBackOnSent callbackOnError) {
        if (metrics != null && metrics.size() > 0) {
            HashMap metricData = new HashMap();
            HashMap sentMetrics = new HashMap();
            final ArrayList<IAppMapDecisionSupportBean.IUniqueCandidate> revertList = new ArrayList<IAppMapDecisionSupportBean.IUniqueCandidate>();
            Iterator i = metrics.entrySet().iterator();
            while (i.hasNext()) {
                Map.Entry entry = i.next();
                IAppMapDecisionSupportBean.IUniqueCandidate metricCandidate = (IAppMapDecisionSupportBean.IUniqueCandidate)entry.getValue();
                String metric = metricCandidate.getMetric();
                revertList.add(metricCandidate);
                sentMetrics.put(entry.getKey(), metric);
            }
            metricData.put(tail, sentMetrics);
            oracle.reportMetrics(new IAppMapDecisionSupportBean.ICallBackOnSent(){

                public void onSent(boolean success) {
                    if (!success) {
                        Iterator i = revertList.iterator();
                        while (i.hasNext()) {
                            IAppMapDecisionSupportBean.IUniqueCandidate candidate = (IAppMapDecisionSupportBean.IUniqueCandidate)i.next();
                            oracle.revertNodeMetricUniquenes(candidate);
                        }
                    }
                    if (callbackOnError != null) {
                        callbackOnError.onSent(success);
                    }
                }
            }, metricData);
        }
    }

    public boolean peekLastMapComponentWasMe(IStackType type, String component) {
        if (!this.fShouldRun) {
            return false;
        }
        if (type == this.getStackType()) {
            return component != null && component.equals(this.fLastPoppedComponent);
        }
        return false;
    }

    public void popMapComponent(IStackType stackType, String component) {
        if (stackType == this.getStackType() && !this.fComponentStack.isEmpty()) {
            this.fComponentStack.pop(component);
        }
    }

    public IStackType getStackType() {
        return this.fType;
    }

    public static class AppMapPreformedCallback
    extends PreformedCallback {
        public AppMapPreformedCallback(HashMap params) {
            super(params);
        }

        public AppMapPreformedCallback(String paramName, String paramValue) {
            super(paramName, paramValue);
        }

        public void IComponentParameterCallback_addParameters(Map parameters) {
            if (this.fName1 != null) {
                parameters.put(this.fName1, this.fValue1);
            }
            if (parameters != this.fParams && this.fParams != null && this.fParams.size() > 0) {
                parameters.putAll(this.fParams);
            }
        }
    }

    private static class DelayedEdge {
        private TransactionStackElement fElement;
        private TransactionStackElement fParent;

        public DelayedEdge(TransactionStackElement element, TransactionStackElement parent) {
            this.fElement = element;
            this.fParent = parent;
        }

        public TransactionStackElement getElement() {
            return this.fElement;
        }

        public TransactionStackElement getParent() {
            return this.fParent;
        }

        public String toString() {
            return String.valueOf(this.fParent.toString()) + " -> " + this.fElement.toString();
        }

        public int hashCode() {
            int result = 1;
            result = 31 * result + (this.fElement == null ? 0 : this.fElement.hashCode());
            result = 31 * result + (this.fParent == null ? 0 : this.fParent.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            DelayedEdge other = (DelayedEdge)obj;
            if (this.fElement == null ? other.fElement != null : !this.fElement.equals(other.fElement)) {
                return false;
            }
            return !(this.fParent == null ? other.fParent != null : !this.fParent.equals(other.fParent));
        }
    }

    private static class StackLinkedList {
        private TransactionStackElement head;
        private TransactionStackElement tail;
        private int size;

        StackLinkedList() {
            this.init();
        }

        private void init() {
            this.tail = null;
            this.head = null;
            this.size = 0;
        }

        void clear() {
            this.init();
        }

        void add(TransactionStackElement e) {
            if (this.tail == null) {
                this.head = this.tail = e;
            } else {
                e.addAfter(this.tail);
            }
            this.tail = e;
            ++this.size;
        }

        TransactionStackElement getHead() {
            return this.head;
        }

        TransactionStackElement getTail() {
            return this.tail;
        }

        public int getSize() {
            return this.size;
        }

        TransactionStackElement removeLast() {
            TransactionStackElement result = this.tail;
            if (result != null) {
                this.tail = result.fPrevious;
                if (this.tail != null) {
                    this.tail.fNext = null;
                } else {
                    this.head = null;
                }
                --this.size;
            }
            return result;
        }

        boolean isEmpty() {
            return this.size == 0;
        }

        int size() {
            return this.size;
        }

        public void pop(String component) {
            TransactionStackElement result = this.tail;
            if (result != null && result.fComponent.equals(component)) {
                this.tail = result.fPrevious;
                if (this.tail != null) {
                    this.tail.fNext = null;
                } else {
                    this.head = null;
                }
                --this.size;
            }
        }
    }

    private static class TailCallbackWrapper {
        IAppMapDecisionSupportBean.ICallBackOnSent callback;
        IAppMapStackCollectDataStructure fTail;

        public TailCallbackWrapper(IAppMapStackCollectDataStructure tail, IAppMapDecisionSupportBean.ICallBackOnSent callback2) {
            this.fTail = tail;
            this.callback = callback2;
        }
    }

    private static class TransactionStackElement {
        private final AppMapStack fParent;
        final String fComponent;
        public IComponentParameterCallback fCallback;
        public ParameterGatheringCallback fParamCallback;
        final Map fParams;
        TransactionStackElement fPrevious;
        TransactionStackElement fNext;
        final IAppMapOwner fOwner;

        public TransactionStackElement(AppMapStack parent, String component, IComponentParameterCallback callback, IAppMapOwner currentOwner) {
            this.fParent = parent;
            this.fComponent = component;
            this.fCallback = callback;
            this.fOwner = currentOwner;
            this.fParamCallback = null;
            this.fNext = null;
            this.fPrevious = null;
            this.fParams = new HashMap();
        }

        public TransactionStackElement(AppMapStack parent, String component, Map parameters, IComponentParameterCallback callback, IAppMapOwner currentOwner) {
            this.fParent = parent;
            this.fComponent = component;
            this.fCallback = callback;
            this.fOwner = currentOwner;
            this.fParamCallback = null;
            this.fNext = null;
            this.fPrevious = null;
            this.fParams = parameters == null ? new HashMap() : parameters;
        }

        public void markDependency() {
            this.fParent.addCallbackParameters(this.fCallback, this.fParams);
        }

        public Map getParameters() {
            return this.fParams;
        }

        public String getComponent() {
            return this.fComponent;
        }

        void addAfter(TransactionStackElement oldTail) {
            oldTail.fNext = this;
            this.fPrevious = oldTail;
            this.fNext = null;
        }

        TransactionStackElement getPrevious() {
            return this.fPrevious;
        }

        public void addCallbackParams(String paramName, String paramValue) {
            if (this.fParamCallback == null) {
                this.fParamCallback = new ParameterGatheringCallback();
                this.fCallback = new CompoundComponentParameterCallback(this.fCallback, (IComponentParameterCallback)this.fParamCallback);
            }
            this.fParamCallback.addParameter(paramName, paramValue);
        }

        public String toString() {
            return this.getComponent();
        }
    }
}

