/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.appmap.agent.trace;

import com.wily.introscope.agent.transactiontrace.SharedCrossProcessData;
import com.wily.introscope.appmap.agent.AppDef;
import com.wily.introscope.appmap.agent.trace.AppMapCrossProcessHelper;
import com.wily.introscope.appmap.agent.trace.ICallbackOnLazyPushOwnerName;
import com.wily.introscope.spec.server.appmap.IAppMapOwner;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class AppMapApplicationCrossProcessHelper
extends AppMapCrossProcessHelper {
    protected static final String kAppNameKey = "AppMapAppNames";
    protected static final String kAppNameLocalKey = "AppMapLocalAppNames";
    private static final AppMapApplicationCrossProcessHelper kInstance = new AppMapApplicationCrossProcessHelper();

    private AppMapApplicationCrossProcessHelper() {
        SharedCrossProcessData.ICrossProcessDataCallBack cbo = new SharedCrossProcessData.ICrossProcessDataCallBack(){

            public void prepareOptionalParameters(SharedCrossProcessData data) {
                AppMapApplicationCrossProcessHelper.this.mergeApplicationNameList(data);
            }
        };
        SharedCrossProcessData.addCrossProcessDataCallback((SharedCrossProcessData.ICrossProcessDataCallBack)cbo);
    }

    public static AppMapApplicationCrossProcessHelper getInstance() {
        return kInstance;
    }

    public List getCallingProcessOwners(SharedCrossProcessData cache) {
        if (cache != null) {
            String appName = cache.getStringParamIn(kAppNameKey);
            if (appName != null) {
                ArrayList<AppDef> apps = new ArrayList<AppDef>(1);
                AppDef app = AppDef.getInstance(appName);
                apps.add(app);
                return apps;
            }
            List appNames = cache.getListParamIn(kAppNameKey);
            if (appNames != null) {
                Iterator i = appNames.iterator();
                ArrayList<AppDef> apps = new ArrayList<AppDef>(appNames.size());
                while (i.hasNext()) {
                    apps.add(AppDef.getInstance((String)i.next()));
                }
                return apps;
            }
        }
        return null;
    }

    public void setCalledProcessOwner(SharedCrossProcessData cache, IAppMapOwner owner) {
        if (cache != null) {
            if (owner != null && owner.getName() != null && !owner.isNullInstance()) {
                cache.addParamOut(kAppNameLocalKey, owner.getName());
            } else {
                cache.removeParamOut(kAppNameLocalKey);
            }
            cache.removeParamOut(kAppNameKey);
        }
    }

    public void setCalledProcessOwners(SharedCrossProcessData cache, List owners) {
        if (cache != null) {
            if (owners != null && !owners.isEmpty()) {
                if (owners.size() == 1) {
                    Object o = owners.get(0);
                    if (o instanceof IAppMapOwner) {
                        o = ((IAppMapOwner)o).getName();
                    }
                    cache.addParamOut(kAppNameLocalKey, o.toString());
                } else {
                    ArrayList l = new ArrayList(owners.size());
                    Iterator i = owners.iterator();
                    while (i.hasNext()) {
                        Object o = i.next();
                        if (o instanceof IAppMapOwner) {
                            o = ((IAppMapOwner)o).getName();
                        }
                        l.add(o);
                    }
                    cache.addParamOut(kAppNameLocalKey, l);
                }
            } else {
                cache.removeParamOut(kAppNameLocalKey);
            }
            cache.removeParamOut(kAppNameKey);
        }
    }

    public void setCalledProcessOwnersStringOnly(SharedCrossProcessData cache, String addedOwner) {
        if (cache != null) {
            ArrayList<String> currentOwners;
            String currentOwner;
            Object o = cache.getObjectParamOut(kAppNameLocalKey);
            String string = o == null ? null : (currentOwner = o instanceof String ? o.toString() : null);
            ArrayList<String> arrayList = o == null ? null : (currentOwners = o instanceof ArrayList ? (ArrayList<String>)o : null);
            if (currentOwners != null) {
                currentOwners.add(addedOwner);
                cache.addParamOut(kAppNameLocalKey, currentOwners);
            } else if (currentOwner != null) {
                currentOwners = new ArrayList<String>();
                currentOwners.add(currentOwner);
                currentOwners.add(addedOwner);
                cache.addParamOut(kAppNameLocalKey, currentOwners);
            } else {
                cache.addParamOut(kAppNameLocalKey, addedOwner);
            }
            cache.removeParamOut(kAppNameKey);
        }
    }

    public void setCalledProcessOwnersStringOnlyIfEmpty(SharedCrossProcessData cache, ICallbackOnLazyPushOwnerName callback) {
        if (cache != null) {
            Object o = cache.getObjectParamOut(kAppNameLocalKey);
            if (o != null) {
                return;
            }
            this.setCalledProcessOwnersStringOnly(cache, callback.getOwnerName());
        }
    }

    public void removeCalledProcessOwnersStringOnly(SharedCrossProcessData cache, String removedOwner) {
        if (cache != null) {
            ArrayList currentOwners;
            String currentOwner;
            Object o = cache.getObjectParamOut(kAppNameLocalKey);
            String string = o == null ? null : (currentOwner = o instanceof String ? o.toString() : null);
            ArrayList arrayList = o == null ? null : (currentOwners = o instanceof ArrayList ? (ArrayList)o : null);
            if (currentOwners != null) {
                currentOwners.remove(removedOwner);
                if (currentOwners.size() == 0) {
                    cache.removeParamOut(kAppNameLocalKey);
                } else if (currentOwners.size() == 1) {
                    cache.addParamOut(kAppNameLocalKey, (String)currentOwners.get(0));
                } else {
                    cache.addParamOut(kAppNameLocalKey, currentOwners);
                }
            } else if (currentOwner != null && currentOwner.equals(removedOwner)) {
                cache.removeParamOut(kAppNameLocalKey);
            }
            cache.removeParamOut(kAppNameKey);
        }
    }

    private void mergeApplicationNameList(SharedCrossProcessData data) {
        String appIn = data.getStringParamIn(kAppNameKey);
        List appsIn = data.getListParamIn(kAppNameKey);
        String appLocal = data.getStringParamOut(kAppNameLocalKey);
        List appsLocal = data.getListParamOut(kAppNameLocalKey);
        String appOut = data.getStringParamOut(kAppNameKey);
        ArrayList<String> appsOut = data.getListParamOut(kAppNameKey);
        if (appOut != null || appsOut != null) {
            return;
        }
        int len = 0;
        if (appIn != null) {
            ++len;
            appOut = appIn;
        } else if (appsIn != null) {
            len += appsIn.size();
        }
        if (appLocal != null) {
            ++len;
            appOut = appLocal;
        } else if (appsLocal != null) {
            len += appsLocal.size();
        }
        if (len != 0) {
            if (len == 1) {
                if (appOut != null) {
                    data.addParamOut(kAppNameKey, appOut);
                } else if (appsIn != null && appsIn.size() == 1) {
                    data.addParamOut(kAppNameKey, (String)appsIn.get(0));
                } else if (appsLocal != null && appsLocal.size() == 1) {
                    data.addParamOut(kAppNameKey, (String)appsLocal.get(0));
                }
            } else {
                appsOut = new ArrayList<String>(len);
                if (appIn != null) {
                    appsOut.add(appIn);
                } else if (appsIn != null) {
                    appsOut.addAll(appsIn);
                }
                if (appLocal != null) {
                    appsOut.add(appLocal);
                } else if (appsLocal != null) {
                    appsOut.addAll(appsLocal);
                }
                data.addParamOut(kAppNameKey, appsOut);
            }
        }
        data.removeParamOut(kAppNameLocalKey);
    }
}

