/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.appmap.agent.trace;

import com.wily.introscope.agent.AgentShim;
import com.wily.introscope.agent.transactiontrace.SharedCrossProcessData;
import com.wily.introscope.appmap.agent.BizDef;
import com.wily.introscope.appmap.agent.trace.AppMapCrossProcessHelper;
import com.wily.introscope.spec.server.appmap.IAppMapOwner;
import java.util.ArrayList;
import java.util.List;

public class AppMapBtcCrossProcessHelper
extends AppMapCrossProcessHelper {
    protected static final String kBtcNameKey = "AppMapBtcName";
    protected static final String kBtcIdKey = "AppMapBtcId";
    private static final AppMapBtcCrossProcessHelper kInstance = new AppMapBtcCrossProcessHelper();

    private AppMapBtcCrossProcessHelper() {
        SharedCrossProcessData.ICrossProcessDataCallBack cbo = new SharedCrossProcessData.ICrossProcessDataCallBack(){

            public void prepareOptionalParameters(SharedCrossProcessData data) {
                AppMapBtcCrossProcessHelper.this.mergeBtcNameList(data);
            }
        };
        SharedCrossProcessData.addCrossProcessDataCallback((SharedCrossProcessData.ICrossProcessDataCallBack)cbo);
    }

    public static AppMapBtcCrossProcessHelper getInstance() {
        return kInstance;
    }

    public List getCallingProcessOwners(SharedCrossProcessData cache) {
        if (cache != null) {
            String bizName = cache.getStringParamIn(kBtcNameKey);
            if (bizName == null) {
                return null;
            }
            String bizId = cache.getStringParamIn(kBtcIdKey);
            if (bizId == null) {
                return null;
            }
            long longBizId = 0L;
            try {
                longBizId = Long.parseLong(bizId);
            }
            catch (NumberFormatException numberFormatException) {
                try {
                    AgentShim.getAgent().IAgent_getModuleFeedback().warn("Error when parsing incoming id for business process " + bizId);
                }
                catch (Exception exception) {}
            }
            ArrayList<BizDef> result = new ArrayList<BizDef>(1);
            result.add(BizDef.getInstance(bizName, longBizId));
            return result;
        }
        return null;
    }

    public void setCalledProcessOwner(SharedCrossProcessData cache, IAppMapOwner owner) {
        if (cache != null) {
            if (owner != null && owner.getName() != null && !owner.isNullInstance() && !owner.isDelayedInstance()) {
                cache.addParamOut(kBtcNameKey, owner.getName());
                cache.addParamOut(kBtcIdKey, "" + owner.getId());
            } else {
                cache.removeParamOut(kBtcNameKey);
                cache.removeParamOut(kBtcIdKey);
            }
        }
    }

    public void setCalledProcessOwners(SharedCrossProcessData cache, List owners) {
        if (cache != null) {
            if (owners != null && !owners.isEmpty()) {
                IAppMapOwner owner = (IAppMapOwner)owners.get(0);
                if (owner != null && !owner.isNullInstance() && !owner.isDelayedInstance()) {
                    cache.addParamOut(kBtcNameKey, owner.getName());
                    cache.addParamOut(kBtcIdKey, "" + owner.getId());
                } else {
                    cache.addParamOut(kBtcNameKey, owner.getName());
                    cache.addParamOut(kBtcIdKey, "" + owner.getId());
                }
            } else {
                cache.removeParamOut(kBtcNameKey);
                cache.removeParamOut(kBtcIdKey);
            }
        }
    }

    private void mergeBtcNameList(SharedCrossProcessData data) {
        String btcId;
        String btcName = data.getStringParamIn(kBtcNameKey);
        if (btcName != null && btcName.length() > 0) {
            data.addParamOut(kBtcNameKey, btcName);
        }
        if ((btcId = data.getStringParamIn(kBtcIdKey)) != null && btcId.length() > 0) {
            data.addParamOut(kBtcIdKey, btcId);
        }
    }
}

