/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.intelligent.detection.rules;

import com.wily.introscope.agent.intelligent.detection.rules.AbstractFailFastRule;
import com.wily.introscope.agent.intelligent.entrypoint.apis.ExecutionStatus;
import com.wily.introscope.agent.intelligent.entrypoint.apis.IndexAwareTraceElement;
import com.wily.introscope.agent.intelligent.entrypoint.common.Utils;
import java.util.regex.Pattern;

public class MatchesSourceFileExtRule
extends AbstractFailFastRule {
    private Pattern fileExtPattern;

    public MatchesSourceFileExtRule(String fileExt) {
        String regex = null;
        if (fileExt != null) {
            regex = fileExt.startsWith(".") ? fileExt.replace(".", "\\.") : "\\." + fileExt;
            regex = ".*" + regex;
            this.fileExtPattern = Pattern.compile(regex, 2);
        }
    }

    @Override
    public boolean doExecute(int currentElementIndex, IndexAwareTraceElement[] trace, ExecutionStatus status) {
        boolean passes = true;
        if (this.fileExtPattern != null) {
            IndexAwareTraceElement traceElement = trace[currentElementIndex];
            String fileName = traceElement.getFileName();
            passes = fileName != null ? this.fileExtPattern.matcher(traceElement.getFileName()).matches() : false;
        }
        return passes;
    }

    @Override
    public String toString() {
        return Utils.formatStringRep(String.valueOf(this.getClass().getSimpleName()) + ", fileExtPattern:" + this.fileExtPattern);
    }
}

