/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.intelligent.entrypoint;

import com.wily.introscope.agent.intelligent.detection.AutomaticBoundaryDetectionAdmin;
import com.wily.introscope.agent.intelligent.detection.BaseCandidateFinder;
import com.wily.introscope.agent.intelligent.detection.rules.SkipMethodIfAlreadyInstrumentedRule;
import com.wily.introscope.agent.intelligent.entrypoint.EntryPointDetectionConfiguration;
import com.wily.introscope.agent.intelligent.entrypoint.Logger;
import com.wily.introscope.agent.intelligent.entrypoint.apis.IndexAwareTraceElement;
import com.wily.introscope.agent.intelligent.entrypoint.apis.RuleEngine;
import com.wily.introscope.agent.intelligent.entrypoint.common.Utils;
import com.wily.introscope.agent.intelligent.entrypoint.stacktrace.StackTraceRecordingController;
import com.wily.introscope.agent.intelligent.entrypoint.stacktrace.StackTraceRepository;
import com.wily.introscope.agent.trace.intelligent.SustainabilityMetricsHelper;
import com.wily.introscope.agent.trace.intelligent.frontend.FrontEndCandidateAnalyzer;
import java.util.List;

public class EntryPointCandidateFinder
extends BaseCandidateFinder {
    private EntryPointCandidateFinder() {
    }

    @Override
    public void run() {
        try {
            this.numberOfRuns.incrementAndGet();
            this.doRun();
            if (StackTraceRepository.isEmpty()) {
                StackTraceRecordingController.resetRecordingsCounter();
            }
        }
        catch (Throwable e) {
            Logger.logDebugMessage((String)"Error while finding initial candidates", (Throwable)e);
        }
    }

    protected void doRun() {
        Logger.logTraceMessage((String)"Initial Candidate Finder got scheduled.");
        SustainabilityMetricsHelper.reportStackQueueLength((int)StackTraceRepository.size());
        IndexAwareTraceElement[] trace = StackTraceRepository.pollWrappedTrace();
        int counter = 0;
        while (trace != null && trace.length > 0) {
            this.process(trace);
            ++counter;
            trace = StackTraceRepository.pollWrappedTrace();
        }
        Logger.logTraceMessage((String)("Initial Candidate Finder completed. Traces processed: " + counter));
        SustainabilityMetricsHelper.reportAnalyzedStacks((int)counter);
    }

    private void process(IndexAwareTraceElement[] trace) {
        Logger.logDebugMessage((String)"Started processing stack trace.");
        if (Logger.isTraceEnabled()) {
            Logger.logTraceMessage((String)("Stack Trace size : " + trace.length));
            this.logStackTrace(trace);
        }
        RuleEngine ruleEngine = AutomaticBoundaryDetectionAdmin.getInstance().getEntryPointDetectionRuleEngine();
        SkipMethodIfAlreadyInstrumentedRule.getInstance().refreshClassRepo();
        List candidates = ruleEngine.execute(ruleEngine.preExecute(trace));
        int size = 0;
        if (candidates != null) {
            size = candidates.size();
            Logger.logDebugMessage((String)("Number of initial candidates found: " + size));
            if (Logger.isTraceEnabled()) {
                Logger.logTraceMessage((String)("Initial Candidates: " + candidates));
            }
            if (FrontEndCandidateAnalyzer.isInitialized()) {
                for (IndexAwareTraceElement candidate : candidates) {
                    FrontEndCandidateAnalyzer.addInitialFrontEndCandidate((String)candidate.getClassName(), (String)candidate.getMethodName(), (String)FrontEndCandidateAnalyzer.NULL_DESCRIPTOR);
                }
            }
        }
    }

    private void logStackTrace(IndexAwareTraceElement[] traceElements) {
        if (EntryPointDetectionConfiguration.shouldLogStackTraces()) {
            String traceAsString = Utils.getStringRepresentationOfTrace(traceElements);
            Logger.logTraceMessage((String)("Stack Trace: \n" + traceAsString));
        }
    }

    public static EntryPointCandidateFinder getInstance() {
        return SingletonHolder.INSTANCE;
    }

    /* synthetic */ EntryPointCandidateFinder(EntryPointCandidateFinder entryPointCandidateFinder) {
        this();
    }

    private static class SingletonHolder {
        private static final EntryPointCandidateFinder INSTANCE = new EntryPointCandidateFinder(null);

        private SingletonHolder() {
        }
    }
}

