/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.intelligent.entrypoint;

import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.intelligent.detection.rules.CustomRulesFactory;
import com.wily.introscope.agent.intelligent.detection.rules.IsAppClassRule;
import com.wily.introscope.agent.intelligent.detection.rules.IsInBottomNPercentRule;
import com.wily.introscope.agent.intelligent.detection.rules.IsInterestingMethodNameRule;
import com.wily.introscope.agent.intelligent.detection.rules.MatchesSourceFileExtRule;
import com.wily.introscope.agent.intelligent.detection.rules.SkipClassRule;
import com.wily.introscope.agent.intelligent.detection.rules.SkipMarkedForSkipInsRule;
import com.wily.introscope.agent.intelligent.detection.rules.SkipMethodIfAlreadyInstrumentedRule;
import com.wily.introscope.agent.intelligent.detection.rules.SkipMethodNameRule;
import com.wily.introscope.agent.intelligent.detection.rules.SkipPackageRule;
import com.wily.introscope.agent.intelligent.detection.rules.SkipTopNPercentRule;
import com.wily.introscope.agent.intelligent.entrypoint.EntryPointDetectionConfiguration;
import com.wily.introscope.agent.intelligent.entrypoint.apis.Rule;
import java.util.LinkedHashSet;
import java.util.Set;

public class RulesSettings {
    private static volatile Set<Rule> defaultRules = null;

    private static Set<Rule> createDefaultRulesSet(IAgent agent) {
        LinkedHashSet<Rule> rules = new LinkedHashSet<Rule>(EntryPointDetectionConfiguration.getMaxRules());
        Set<String> skipPkgs = EntryPointDetectionConfiguration.getEssentialPackagesToSkip();
        Set<String> additionalSkipPkgs = EntryPointDetectionConfiguration.getAdditionalPackagesToSkip();
        if (additionalSkipPkgs.size() > 0) {
            skipPkgs.addAll(additionalSkipPkgs);
        }
        rules.add(new SkipPackageRule(skipPkgs, false));
        Set<String> skipMethodRegexps = EntryPointDetectionConfiguration.getMethodsToSkip();
        rules.add(new SkipMethodNameRule(skipMethodRegexps));
        rules.add(new SkipClassRule(".*\\$\\d+.*"));
        rules.add(new MatchesSourceFileExtRule(".java"));
        rules.add(new SkipMarkedForSkipInsRule(agent));
        rules.add(new SkipTopNPercentRule(EntryPointDetectionConfiguration.getSkipTopPercentOfStackTrace()));
        rules.add(CustomRulesFactory.createRuleToSkipNativeMethod());
        rules.add(SkipMethodIfAlreadyInstrumentedRule.getInstance());
        Set<String> methodNameRegexps = EntryPointDetectionConfiguration.getInterestingMethodNames();
        rules.add(new IsInterestingMethodNameRule(methodNameRegexps));
        Set<String> appPackages = EntryPointDetectionConfiguration.getApplicationPackages();
        if (appPackages.size() > 0) {
            rules.add(new IsAppClassRule(appPackages));
        }
        rules.add(CustomRulesFactory.createRuleToSelectChildOfCall());
        rules.add(CustomRulesFactory.createRuleToSelectFirstNonJavaElement());
        rules.add(new IsInBottomNPercentRule(EntryPointDetectionConfiguration.getIncludeBottomPercentOfStackTrace()));
        return rules;
    }

    public static Set<Rule> getDefaultRulesSet(IAgent agent) {
        if (defaultRules == null) {
            defaultRules = RulesSettings.createDefaultRulesSet(agent);
        }
        return defaultRules;
    }

    public static Set<Rule> getCopyOfDefaultRulesSet(IAgent agent) {
        LinkedHashSet<Rule> rules = new LinkedHashSet<Rule>();
        rules.addAll(RulesSettings.getDefaultRulesSet(agent));
        return rules;
    }
}

