/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.intelligent.exitpoint;

import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.intelligent.detection.rules.CustomRulesFactory;
import com.wily.introscope.agent.intelligent.detection.rules.MatchesSourceFileExtRule;
import com.wily.introscope.agent.intelligent.detection.rules.SkipClassRule;
import com.wily.introscope.agent.intelligent.detection.rules.SkipMarkedForSkipInsRule;
import com.wily.introscope.agent.intelligent.detection.rules.SkipPackageRule;
import com.wily.introscope.agent.intelligent.detection.rules.UnconditionalSelectRule;
import com.wily.introscope.agent.intelligent.entrypoint.apis.Rule;
import com.wily.introscope.agent.intelligent.exitpoint.ExitPointDetectionConfiguration;
import java.util.LinkedHashSet;
import java.util.Set;

public class RulesHelper {
    public static Set<Rule> createDefaultRulesSet(IAgent agent) {
        LinkedHashSet<Rule> rules = new LinkedHashSet<Rule>();
        Set<String> skipPkgs = ExitPointDetectionConfiguration.getEssentialPackagesToSkip();
        Set<String> additionalSkipPkgs = ExitPointDetectionConfiguration.getAdditionalPackagesToSkip();
        if (additionalSkipPkgs.size() > 0) {
            skipPkgs.addAll(additionalSkipPkgs);
        }
        rules.add(new SkipPackageRule(skipPkgs, false));
        rules.add(new SkipClassRule(".*\\$\\d+.*"));
        rules.add(new MatchesSourceFileExtRule(".java"));
        rules.add(new SkipMarkedForSkipInsRule(agent));
        rules.add(CustomRulesFactory.createRuleToSkipNativeMethod());
        rules.add(new UnconditionalSelectRule());
        return rules;
    }
}

