/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.probebuilder.intelligent.instrumentation.util;

import com.wily.diagnos.cmp.classfile.DGClassLoadingException;
import com.wily.diagnos.cmp.directives.AnalysedClassesMapInitializer;
import com.wily.diagnos.personality.java.classfile.DGClass;
import com.wily.diagnos.personality.java.classfile.DGMethod;
import com.wily.diagnos.personality.java.tracer.DGIntelligentInstrumentationStreamMethodTracerInstance;
import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.trace.intelligent.Logger;
import com.wily.introscope.agent.transformer.TransformerAdministrator;
import com.wily.introscope.agent.transformer.dynamic.IClassRedefinitionDelegate;
import com.wily.introscope.agent.transformer.dynamic.IDynamicInstrumentationTransformer;
import com.wily.introscope.agent.util.ByteClassUtil;
import com.wily.introscope.autoprobe.AutoProbeTransformer;
import com.wily.introscope.probebuilder.intelligent.instrumentation.util.ClassMethodInfo;
import com.wily.introscope.probebuilder.intelligent.instrumentation.util.MethodInfo;
import com.wily.util.classfile.IModeledClass;
import com.wily.util.classfile.InvalidClassNameException;
import com.wily.util.classfile.InvalidMethodDescriptorException;
import com.wily.util.classfile.InvalidMethodNameException;
import com.wily.util.classfile.java.ClassName;
import com.wily.util.classfile.java.MethodName;
import com.wily.util.feedback.IModuleFeedbackChannel;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class ClassUtil {
    public static HashMap getJavaClassFromVM(HashMap classToFind, boolean bFindAssignableClasses, IAgent agent) {
        HashMap<String, ClassMethodInfo> classList = new HashMap<String, ClassMethodInfo>();
        TransformerAdministrator tAdm = agent.IAgent_getTransformerAdministrator();
        AutoProbeTransformer dit = (AutoProbeTransformer)tAdm.getDynamicInstrumentationTransformer();
        IClassRedefinitionDelegate.IRedefinedClassRepository rep = dit.getClasses();
        int i = 0;
        while (i < rep.getAllClassInVM().length && classToFind.size() > 0) {
            boolean bFound = false;
            Class clazz = rep.getAllClassInVM()[i];
            String name = clazz.getName();
            Set keys = classToFind.keySet();
            Iterator it = keys.iterator();
            while (it.hasNext()) {
                ClassMethodInfo toFind = (ClassMethodInfo)classToFind.get(it.next());
                if (!toFind.className.equals(name)) continue;
                bFound = true;
                break;
            }
            if (bFound) {
                ClassMethodInfo found = (ClassMethodInfo)classToFind.remove(name);
                found.clazz = clazz;
                classList.put(name, found);
                if (bFindAssignableClasses) {
                    ClassUtil.getAssignableJavaClassFromVM(classList, dit, rep, clazz, found, agent);
                }
            }
            ++i;
        }
        return classList;
    }

    private static void getAssignableJavaClassFromVM(HashMap<String, ClassMethodInfo> classList, AutoProbeTransformer dit, IClassRedefinitionDelegate.IRedefinedClassRepository rep, Class clazz, ClassMethodInfo found, IAgent agent) {
        int j = 0;
        while (j < rep.getAllClassInVM().length) {
            String assignableName;
            Class assignableClass = rep.getAllClassInVM()[j];
            if (clazz != assignableClass && clazz.isAssignableFrom(assignableClass) && !dit.isSkippedByNormalInstrumentation(assignableName = assignableClass.getName()) && ClassUtil.canRedefineClass(assignableClass, agent)) {
                ClassMethodInfo gapFiller = classList.get(assignableName);
                if (gapFiller == null) {
                    gapFiller = new ClassMethodInfo(assignableName);
                    classList.put(assignableName, gapFiller);
                    gapFiller.clazz = assignableClass;
                }
                Method[] allMethods = assignableClass.getDeclaredMethods();
                int k = 0;
                while (k < allMethods.length) {
                    MethodName mname;
                    block9: {
                        mname = null;
                        try {
                            mname = MethodName.getMethodName((Method)allMethods[k], (boolean)true);
                        }
                        catch (InvalidMethodDescriptorException e) {
                            if (Logger.isDebugEnabled()) {
                                Logger.logDebugMessage((String)e.getMessage(), (Throwable)e);
                            }
                        }
                        catch (InvalidMethodNameException e) {
                            if (!Logger.isDebugEnabled()) break block9;
                            Logger.logDebugMessage((String)e.getMessage(), (Throwable)e);
                        }
                    }
                    if (found.contains(mname.getNameAndSignatureString())) {
                        String methodStr = mname.getMethodName();
                        String desc = mname.getMethodDescriptor().toString();
                        gapFiller.addMethod(methodStr, desc);
                    }
                    ++k;
                }
            }
            ++j;
        }
    }

    public static boolean canRedefineClass(Class cls, IAgent agent) {
        agent.IAgent_getTransformerAdministrator().getDynamicInstrumentationTransformer().getDynamicInstrumentationFilter().canRedefine(cls);
        return true;
    }

    public static void createWrapperClassMethodHelper(ArrayList listOfClassMethods, HashMap classesToFind) {
        int i = 0;
        while (i < listOfClassMethods.size()) {
            String[] method = (String[])listOfClassMethods.get(i);
            ClassMethodInfo gapclass = (ClassMethodInfo)classesToFind.get(method[0]);
            if (gapclass == null) {
                gapclass = new ClassMethodInfo(method[0]);
                classesToFind.put(method[0], gapclass);
            }
            gapclass.addMethod(method[1], method[2]);
            ++i;
        }
    }

    public static HashMap<String, ClassMethodInfo> filterSkippedClasses(IAgent agent, HashMap calledClassMethodMap) {
        HashMap<String, ClassMethodInfo> notSkippedClassesMap = new HashMap<String, ClassMethodInfo>();
        AutoProbeTransformer autoprobeTxFrm = (AutoProbeTransformer)agent.IAgent_getTransformerAdministrator().getDynamicInstrumentationTransformer();
        Set keys1 = calledClassMethodMap.keySet();
        for (String className : keys1) {
            if (autoprobeTxFrm.isSkippedByNormalInstrumentation(className)) continue;
            notSkippedClassesMap.put(className, (ClassMethodInfo)calledClassMethodMap.get(className));
        }
        return notSkippedClassesMap;
    }

    public static HashMap filterUnRedefineableClasses(IAgent agent, HashMap classMethodMapWithClazz) {
        HashMap<String, ClassMethodInfo> classMethodMap = new HashMap<String, ClassMethodInfo>();
        Set keys1 = classMethodMapWithClazz.keySet();
        for (String className : keys1) {
            ClassMethodInfo vgClass = (ClassMethodInfo)classMethodMapWithClazz.get(className);
            if (!ClassUtil.canRedefineClass(vgClass.clazz, agent)) continue;
            classMethodMap.put(className, vgClass);
        }
        return classMethodMap;
    }

    public static HashMap filterInstrumentedMethods(IAgent agent, HashMap classMethodMap) {
        HashMap<String, ClassMethodInfo> redefineClassesMap = new HashMap<String, ClassMethodInfo>();
        int fClassFileSizeLimit = 0x100000;
        Set keys = classMethodMap.keySet();
        for (String className : keys) {
            ClassMethodInfo cmvg = (ClassMethodInfo)classMethodMap.get(className);
            byte[] classBytes = null;
            try {
                classBytes = ByteClassUtil.getBytesForClass((Class)cmvg.clazz, (int)fClassFileSizeLimit, (IModuleFeedbackChannel)agent.IAgent_getModuleFeedback());
                ByteArrayInputStream input = new ByteArrayInputStream(classBytes);
                DGClass modeledClass = new DGClass((InputStream)input);
                ArrayList<DGMethod> calledDGMethods = new ArrayList<DGMethod>();
                Iterator it2 = modeledClass.getAllDeclaredMethods();
                while (it2.hasNext()) {
                    DGMethod dgMethod = (DGMethod)it2.next();
                    if (!cmvg.containsMethodWithSameName(dgMethod)) continue;
                    calledDGMethods.add(dgMethod);
                }
                ArrayList<DGMethod> methodList = ClassUtil.filterInstrumentedMethods(agent, modeledClass, calledDGMethods);
                cmvg.setMethodsToInstrument(methodList);
                if (cmvg.getMethods().size() <= 0) continue;
                redefineClassesMap.put(className, cmvg);
            }
            catch (IOException e) {
                if (!Logger.isDebugEnabled()) continue;
                Logger.logDebugMessage((String)"Got exception while filtering instrumented methods", (Throwable)e);
            }
            catch (DGClassLoadingException e) {
                if (!Logger.isDebugEnabled()) continue;
                Logger.logDebugMessage((String)"Got exception while filtering instrumented methods", (Throwable)e);
            }
        }
        return redefineClassesMap;
    }

    public static ArrayList<DGMethod> filterInstrumentedMethods(IAgent agent, DGClass modeledClass, ArrayList<DGMethod> calledDGMethods) {
        TransformerAdministrator tAdm = agent.IAgent_getTransformerAdministrator();
        IDynamicInstrumentationTransformer dit = tAdm.getDynamicInstrumentationTransformer();
        return ((AutoProbeTransformer)dit).filterInstrumentedMethods((IModeledClass)modeledClass, calledDGMethods);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void publishAutoInstrumentedMethods(HashMap redefineClassesMap) {
        short id = 0;
        HashSet<String> classList = new HashSet<String>();
        HashMap<Integer, short[]> methodMap = new HashMap<Integer, short[]>();
        for (String className : redefineClassesMap.keySet()) {
            classList.add(className);
            ClassMethodInfo gapFiller = (ClassMethodInfo)redefineClassesMap.get(className);
            for (String method : gapFiller.methodsWithGap.keySet()) {
                String mkeyStr;
                String classkeyStr;
                block16: {
                    MethodInfo fillerMethod;
                    block15: {
                        fillerMethod = gapFiller.methodsWithGap.get(method);
                        classkeyStr = "";
                        try {
                            classkeyStr = ClassName.getClassName((String)className).getPackageAndNameString();
                        }
                        catch (InvalidClassNameException e) {
                            if (!Logger.isDebugEnabled()) break block15;
                            Logger.logDebugMessage((String)e.getMessage(), (Throwable)e);
                        }
                    }
                    mkeyStr = "";
                    try {
                        MethodName mkey = MethodName.getMethodNameWithDescriptor((String)(String.valueOf(fillerMethod.getMethodName()) + fillerMethod.getMethodDesciptor()));
                        mkeyStr = mkey.getNameAndSignatureString();
                    }
                    catch (InvalidMethodDescriptorException e) {
                        if (Logger.isDebugEnabled()) {
                            Logger.logDebugMessage((String)e.getMessage(), (Throwable)e);
                        }
                    }
                    catch (InvalidMethodNameException e) {
                        if (!Logger.isDebugEnabled()) break block16;
                        Logger.logDebugMessage((String)e.getMessage(), (Throwable)e);
                    }
                }
                String methodKey = String.valueOf(classkeyStr) + mkeyStr;
                short[] value = AnalysedClassesMapInitializer.getMethodMetadata((String)classkeyStr, (String)mkeyStr, (String)"");
                if (value == null) {
                    value = new short[3];
                    value[0] = Short.MAX_VALUE;
                    value[2] = 2;
                } else {
                    short state = value[2];
                    if (state != 1) {
                        value[2] = 2;
                    }
                    value[0] = Short.MAX_VALUE;
                    id = value[1];
                    if (id != 0 && state != 1 && state != 4 && DGIntelligentInstrumentationStreamMethodTracerInstance.kAllIntelligentProbeInfo.get(id) != DGIntelligentInstrumentationStreamMethodTracerInstance.kDummyElement) {
                        List<String[]> list = DGIntelligentInstrumentationStreamMethodTracerInstance.kAllIntelligentProbeInfo;
                        synchronized (list) {
                            DGIntelligentInstrumentationStreamMethodTracerInstance.kAllIntelligentProbeInfo.add(id, DGIntelligentInstrumentationStreamMethodTracerInstance.kDummyElement);
                            DGIntelligentInstrumentationStreamMethodTracerInstance.kAllIntelligentProbeInfo.remove(id + 1);
                        }
                    }
                }
                methodMap.put(methodKey.hashCode(), value);
            }
        }
        AnalysedClassesMapInitializer.addCandidateClasses(classList);
        AnalysedClassesMapInitializer.addCandidateMethods(methodMap);
    }
}

