/*
 * Decompiled with CFR 0.152.
 */
package com.wily.rave.spec.ds.classmonitor;

import com.wily.rave.spec.IContent;
import com.wily.rave.spec.IContentChange;
import com.wily.rave.spec.IContentMetadataItem;
import com.wily.rave.spec.IContentSummary;
import com.wily.rave.spec.IContentValue;
import com.wily.rave.spec.IDataSourceInstance;
import com.wily.rave.spec.InvalidContent;
import com.wily.rave.spec.ds.classmonitor.ClassContentChange;
import com.wily.rave.spec.ds.classmonitor.ClassContentSummary;
import com.wily.rave.spec.ds.classmonitor.ClassContentValue;
import com.wily.rave.spec.ds.classmonitor.DotnetClassContentSummary;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

public class ClassContent
implements IContent,
Externalizable {
    private static final long serialVersionUID = 1L;
    private ClassContentSummary summary;
    private ClassContentValue value;
    static /* synthetic */ Class class$0;

    public ClassContent() {
    }

    public ClassContent(String className, long size, byte[] digest, IDataSourceInstance dsInstance) {
        this.summary = new ClassContentSummary(className, size, digest, dsInstance);
    }

    public ClassContent(String className, ClassContentValue value, long size, byte[] digest, IDataSourceInstance dsInstance) {
        this(className, size, digest, dsInstance);
        this.value = value;
    }

    public ClassContent(String assemblyPath, String version, String className, long size, byte[] digest, IDataSourceInstance dsInstance) {
        this.summary = new DotnetClassContentSummary(assemblyPath, version, className, size, digest, dsInstance);
    }

    public ClassContent(String assemblyPath, String version, String className, ClassContentValue value, long size, byte[] digest, IDataSourceInstance dsInstance) {
        this(assemblyPath, version, className, size, digest, dsInstance);
        this.value = value;
    }

    public String getResourceName() {
        return this.summary.getResourceName();
    }

    public String getResourceOwner() {
        return this.summary.getResourceOwner();
    }

    public boolean hasMetadata() {
        return this.summary.hasMetadata();
    }

    public IContentMetadataItem[] getMetadata() {
        return this.summary.getMetadata();
    }

    public IDataSourceInstance getDataSourceInstance() {
        return this.summary.getDataSourceInstance();
    }

    public IContentValue getResourceValue() {
        return this.value;
    }

    public String getAssemblyPath() {
        return this.summary.getAssemblyPath();
    }

    public String getAssemblyVersion() {
        return this.summary.getAssemblyVersion();
    }

    public IContentSummary getContentSummary() {
        return this.summary;
    }

    public IContentChange getChange(long changeDetectionTime, IContent priorContent) throws InvalidContent {
        if (!(priorContent instanceof ClassContent)) {
            StringBuffer stringBuffer = new StringBuffer("Not same type content! This: ");
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("com.wily.rave.spec.ds.classmonitor.ClassContent");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            throw new InvalidContent(stringBuffer.append(clazz.getName()).append("; prior content: ").append(priorContent.getClass().getName()).toString());
        }
        ClassContent priorClass = (ClassContent)priorContent;
        return new ClassContentChange(this, priorClass, changeDetectionTime);
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.summary);
        out.writeObject(this.value);
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.summary = (ClassContentSummary)in.readObject();
        this.value = (ClassContentValue)in.readObject();
    }

    public int hashCode() {
        return this.summary.hashCode();
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other instanceof ClassContent) {
            ClassContent otherContent = (ClassContent)other;
            return this.summary.equals(otherContent.summary);
        }
        return false;
    }
}

