/*
 * Decompiled with CFR 0.152.
 */
package com.wily.util;

import com.wily.wilyassert.Assertion;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.StringTokenizer;
import java.util.Vector;

public class StringUtils {
    public static char kStartingBookend = (char)123;
    public static char kEndingBookend = (char)125;
    private static final char[] kDangerousExecArgumentCharacters = new char[]{'\"', '\''};

    public static boolean isEmpty(String string) {
        if (string == null) {
            return true;
        }
        int length = string.length();
        for (int i = 0; i < length; ++i) {
            if (Character.isWhitespace(string.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static String getNumericalText(Object number) {
        if (number instanceof Integer) {
            return Integer.toString((Integer)number);
        }
        if (number instanceof Long) {
            return Long.toString((Long)number);
        }
        if (number instanceof Float) {
            return Float.toString(((Float)number).floatValue());
        }
        if (number instanceof Double) {
            return Double.toString((Double)number);
        }
        throw new IllegalArgumentException("number must be an Integer, Long, Float or Double");
    }

    public static String addBookends(String s) {
        if (s == null) {
            return null;
        }
        return kStartingBookend + s + kEndingBookend;
    }

    public static String removeBookends(String s) {
        if (s == null || s.length() < 2 || s.charAt(0) != kStartingBookend || s.charAt(s.length() - 1) != kEndingBookend) {
            return null;
        }
        return s.substring(1, s.length() - 1);
    }

    public static String serializableObjectToString(Serializable serializableObject) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
        objectOutputStream.writeObject(serializableObject);
        byte[] byteArray = byteArrayOutputStream.toByteArray();
        return StringUtils.byteArrayToString(byteArray);
    }

    public static String byteArrayToString(byte[] byteArray) {
        StringBuffer stringBuffer = new StringBuffer(byteArray.length * 2);
        for (int i = 0; i < byteArray.length; ++i) {
            String curByteAsHex = Integer.toHexString(byteArray[i] & 0xFF);
            if (curByteAsHex.length() == 1) {
                curByteAsHex = "0" + curByteAsHex;
            }
            Assertion.wilyAssert(curByteAsHex.length() == 2);
            stringBuffer.append(curByteAsHex);
        }
        return stringBuffer.toString();
    }

    public static Object getSerializeableObjectFromString(String objectString) throws IOException, ClassNotFoundException {
        byte[] byteArray = StringUtils.stringToByteArray(objectString);
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byteArray);
        ObjectInputStream objectInputStream = new ObjectInputStream(byteArrayInputStream);
        return objectInputStream.readObject();
    }

    public static byte[] stringToByteArray(String original) {
        char[] charArray = original.trim().toCharArray();
        Assertion.wilyAssert(charArray.length % 2 == 0);
        byte[] byteArray = new byte[charArray.length / 2];
        for (int i = 0; i < byteArray.length; ++i) {
            byte curByte;
            String smallHexBuffer = "" + charArray[i * 2] + charArray[i * 2 + 1];
            int curInt = Integer.parseInt(smallHexBuffer, 16);
            byteArray[i] = curByte = (byte)curInt;
        }
        return byteArray;
    }

    public static String[] parseList(String list, String separators) {
        Vector<String> elements = new Vector<String>();
        StringTokenizer tokenizer = new StringTokenizer(list, separators);
        while (tokenizer.hasMoreTokens()) {
            elements.addElement(tokenizer.nextToken());
        }
        Object[] result = new String[elements.size()];
        elements.copyInto(result);
        return result;
    }

    public static String[] parseAndTrimList(String list, String separators) {
        return StringUtils.parseAndTrimList(list, separators, false);
    }

    public static String[] parseAndTrimList(String list, String separators, boolean includeEmptyStrings) {
        Vector<String> elements = new Vector<String>();
        boolean returnDelimiters = includeEmptyStrings;
        boolean lastWasDelimiter = true;
        boolean isFirstToken = true;
        StringTokenizer tokenizer = new StringTokenizer(list, separators, returnDelimiters);
        while (tokenizer.hasMoreTokens()) {
            String token = tokenizer.nextToken();
            if (includeEmptyStrings && separators.indexOf(token) != -1) {
                if (lastWasDelimiter) {
                    elements.addElement("");
                }
                lastWasDelimiter = true;
            } else {
                elements.addElement(token.trim());
                lastWasDelimiter = false;
            }
            isFirstToken = false;
        }
        if (includeEmptyStrings && lastWasDelimiter && !isFirstToken) {
            elements.addElement("");
        }
        Object[] result = new String[elements.size()];
        elements.copyInto(result);
        return result;
    }

    public static String[] wordWrap(String source, int length) {
        Vector<String> substrings = new Vector<String>();
        do {
            if (source.length() <= length) {
                substrings.addElement(source);
                break;
            }
            int lineBreak = StringUtils.findBreak(source, length);
            substrings.addElement(source.substring(0, lineBreak));
            source = source.substring(lineBreak);
            if (source.equals("") || source.charAt(0) != ' ') continue;
            source = source.substring(1);
        } while (!source.equals(""));
        Object[] results = new String[substrings.size()];
        substrings.copyInto(results);
        return results;
    }

    private static int findBreak(String source, int index) {
        for (int i = index; i >= 0; --i) {
            if (source.charAt(i) != ' ') continue;
            return i;
        }
        return index;
    }

    public static boolean containsTrailingSpaces(String orig) {
        if (orig == null || orig.length() == 0) {
            return false;
        }
        return orig.charAt(orig.length() - 1) == ' ';
    }

    public static String removeTrailingSpaces(String orig) {
        if (orig == null) {
            return orig;
        }
        int numSpaces = 0;
        int cursor = orig.length() - 1;
        while (cursor >= 0 && orig.charAt(cursor) == ' ') {
            --cursor;
            ++numSpaces;
        }
        if (numSpaces > 0) {
            return orig.substring(0, cursor + 1);
        }
        return orig;
    }

    public static String replace(String original, String source, String dest) {
        int end;
        StringBuffer buffer = new StringBuffer(original.length() + dest.length());
        if (source.length() == 0) {
            return original;
        }
        int start = 0;
        while ((end = original.indexOf(source, start)) >= 0) {
            buffer.append(original.substring(start, end));
            buffer.append(dest);
            start = end + source.length();
        }
        buffer.append(original.substring(start));
        return buffer.toString();
    }

    public static String trim(String original) {
        return original == null ? null : original.trim();
    }

    public static String ensureNonNullString(String string) {
        return string == null ? "" : string;
    }

    public static String multipleReplace(String original, String[] source, String[] dest) {
        int start = 0;
        int[] indexPair = new int[2];
        StringUtils.findFirstIndexOf(original, start, source, indexPair);
        if (indexPair[0] < 0) {
            return original;
        }
        StringBuffer buffer = new StringBuffer();
        while (indexPair[0] >= 0) {
            buffer.append(original.substring(start, indexPair[0]));
            buffer.append(dest[indexPair[1]]);
            start = indexPair[0] + source[indexPair[1]].length();
            StringUtils.findFirstIndexOf(original, start, source, indexPair);
        }
        buffer.append(original.substring(start));
        return buffer.toString();
    }

    private static void findFirstIndexOf(String original, int start, String[] source, int[] results) {
        results[0] = -1;
        results[1] = -1;
        for (int i = 0; i < source.length; ++i) {
            int cur = original.indexOf(source[i], start);
            if (source[i].length() == 0) {
                cur = -1;
            }
            if (results[0] >= 0 && cur >= results[0] || cur < 0) continue;
            results[0] = cur;
            results[1] = i;
        }
    }

    public static int stringToMnemonic(String source) {
        if (source == null || source.length() == 0) {
            return -1;
        }
        return Character.toUpperCase(source.charAt(0));
    }

    private static boolean isDangerousExecArgumentCharacter(char c) {
        boolean kDangerous = true;
        boolean kSafe = false;
        if (c == ' ') {
            return false;
        }
        if (Character.isWhitespace(c)) {
            return true;
        }
        if (Character.isISOControl(c)) {
            return true;
        }
        for (int i = 0; i < kDangerousExecArgumentCharacters.length; ++i) {
            if (c != kDangerousExecArgumentCharacters[i]) continue;
            return true;
        }
        return false;
    }

    public static String replaceDangerousExecArgumentCharactersWithSpaces(String source) {
        String result = source;
        int length = source.length();
        for (int i = 0; i < length; ++i) {
            char curChar = source.charAt(i);
            if (!StringUtils.isDangerousExecArgumentCharacter(curChar)) continue;
            result = result.replace(curChar, ' ');
        }
        return result;
    }

    public static int getIndexOfFirstDigit(String source) {
        return StringUtils.getIndexOfFirstDigit(source, 0);
    }

    public static int getIndexOfFirstDigit(String source, int fromIndex) {
        int firstDigitIndex = -1;
        for (int i = fromIndex; i < source.length() && firstDigitIndex == -1; ++i) {
            firstDigitIndex = Character.isDigit(source.charAt(i)) ? i : -1;
        }
        return firstDigitIndex;
    }

    public static boolean nullHandlingEquals(String str1, String str2) {
        if (str1 == null) {
            return str2 == null;
        }
        return str1.equals(str2);
    }

    public static String replaceCharAndTrim(String stringToClean, char origChar, char destChar) {
        return stringToClean.replace(origChar, destChar).trim();
    }

    public static String replaceIllegalChars(String source, char[] illegalChars, char replacementChar) {
        if (source != null && illegalChars != null) {
            for (int i = 0; i < illegalChars.length; ++i) {
                if (source.indexOf(illegalChars[i]) == -1) continue;
                source = source.replace(illegalChars[i], replacementChar);
            }
        }
        return source;
    }

    public static String replaceNonAlphaNumericCharacters(String originalStr, char replacementChar) {
        if (originalStr == null) {
            return null;
        }
        int originalChars = originalStr.length();
        StringBuffer buff = new StringBuffer(originalChars);
        for (int i = 0; i < originalChars; ++i) {
            char nextChar = originalStr.charAt(i);
            if (nextChar >= 'a' && nextChar <= 'z' || nextChar >= 'A' && nextChar <= 'Z' || nextChar >= '0' && nextChar <= '9') {
                buff.append(nextChar);
                continue;
            }
            buff.append(replacementChar);
        }
        return buff.toString();
    }

    public static boolean isWhitespace(String string) {
        for (int i = 0; i < string.length(); ++i) {
            if (Character.isWhitespace(string.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static String escapeHTMLSpecialCharacters(String text) {
        if (text.indexOf(60) == -1 && text.indexOf(62) == -1 && text.indexOf(38) == -1) {
            return text;
        }
        StringBuffer result = new StringBuffer(text.length() + 5);
        block5: for (int i = 0; i < text.length(); ++i) {
            switch (text.charAt(i)) {
                case '<': {
                    result.append("&lt;");
                    continue block5;
                }
                case '>': {
                    result.append("&gt;");
                    continue block5;
                }
                case '&': {
                    result.append("&amp;");
                    continue block5;
                }
                default: {
                    result.append(text.charAt(i));
                }
            }
        }
        return result.toString();
    }

    public static String concatAndEscapeStrings(String first, String second, char separator, char separatorReplacementChar) {
        String result = "";
        if (first == null) {
            first = "";
        }
        if (second == null) {
            second = "";
        }
        result = first.replace(separator, separatorReplacementChar);
        result = result + separator;
        result = result + second.replace(separator, separatorReplacementChar);
        return result;
    }

    public static String concatAndEscapeStrings(String first, String second, String third, char separator, char separatorReplacementChar) {
        String result = StringUtils.concatAndEscapeStrings(first, second, separator, separatorReplacementChar);
        if (third == null) {
            third = "";
        }
        result = result + separator;
        result = result + third.replace(separator, separatorReplacementChar);
        return result;
    }
}

