/*
 * Decompiled with CFR 0.152.
 */
package com.ca.apm.introscope.launch;

import com.ca.apm.introscope.launch.AgentClassLoader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;

public class AUpdateInfo {
    final String coreDirectory;
    final String updateDirectory;
    final String backupDirectory;
    final String osgiFileName;
    final String fileName;
    final String updateFileName;

    public AUpdateInfo(String coreDirectory, String updateDirectory, String backupDirectory, String updateFileName, String currentFileName, String osgiFileName) {
        this.coreDirectory = coreDirectory;
        this.updateDirectory = updateDirectory;
        this.backupDirectory = backupDirectory;
        this.updateFileName = updateFileName;
        this.fileName = currentFileName;
        this.osgiFileName = osgiFileName;
    }

    public boolean isRequestingUpdate() {
        File f = new File(String.valueOf(this.updateDirectory) + File.separator + this.updateFileName);
        return f.exists();
    }

    public boolean backupCurrent() {
        return AUpdateInfo.copyfile(String.valueOf(this.coreDirectory) + File.separator + this.fileName, String.valueOf(this.backupDirectory) + File.separator + this.fileName + ".backup");
    }

    public boolean copyUpdate() {
        return AUpdateInfo.copyfile(String.valueOf(this.updateDirectory) + File.separator + this.updateFileName, String.valueOf(this.coreDirectory) + File.separator + this.fileName);
    }

    public boolean restoreBackup() {
        return AUpdateInfo.copyfile(String.valueOf(this.backupDirectory) + File.separator + this.fileName + ".backup", String.valueOf(this.coreDirectory) + File.separator + this.fileName);
    }

    public URLClassLoader getClassLoader() throws MalformedURLException {
        String url = "file:" + this.coreDirectory + File.separator + this.fileName;
        if (this.osgiFileName != null) {
            String urlOsgi = "file:" + this.coreDirectory + File.separator + this.osgiFileName;
            return new URLClassLoader(new URL[]{new URL(url), new URL(urlOsgi)});
        }
        return new AgentClassLoader(new URL[]{new URL(url)}, ClassLoader.getSystemClassLoader().getParent());
    }

    private static boolean copyfile(String srFile, String dtFile) {
        try {
            int len;
            File f1 = new File(srFile);
            File f2 = new File(dtFile);
            FileInputStream in = new FileInputStream(f1);
            FileOutputStream out = new FileOutputStream(f2);
            byte[] buf = new byte[1024];
            while ((len = ((InputStream)in).read(buf)) > 0) {
                ((OutputStream)out).write(buf, 0, len);
            }
            ((InputStream)in).close();
            ((OutputStream)out).close();
            System.out.println("File copied.");
            return true;
        }
        catch (FileNotFoundException ex) {
            System.out.println(String.valueOf(ex.getMessage()) + " in the specified directory.");
        }
        catch (IOException e) {
            System.out.println(e.getMessage());
        }
        return false;
    }
}

