/*
 * Decompiled with CFR 0.152.
 */
package com.ca.apm.introscope.launch;

import com.ca.apm.introscope.launch.AUpdateInfo;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.lang.instrument.Instrumentation;
import java.lang.reflect.Method;
import java.net.URLClassLoader;
import java.util.Properties;

public class Launcher {
    public static Instrumentation kInstrumentation;
    public static final Properties launchArgs;
    public static volatile URLClassLoader agentClassLoader;
    public static boolean launchAgent;

    static {
        launchArgs = new Properties();
        launchAgent = true;
    }

    private static String[] parseArg(String agentArg, String regex) {
        return agentArg.split(regex);
    }

    public static void premain(String agentArgs, Instrumentation inst) throws ClassNotFoundException, IllegalArgumentException, SecurityException, IllegalAccessException, NoSuchMethodException, FileNotFoundException, IOException {
        System.out.println("Doing premain: " + agentArgs);
        if (agentArgs == null) {
            System.out.println("***** Cannot start agent without arguments. Agent will not start.");
            return;
        }
        System.out.println("Storing Instrumentation");
        kInstrumentation = inst;
        String[] args = Launcher.parseArg(agentArgs, ";");
        int i = 0;
        while (i < args.length) {
            System.out.println(args[i]);
            ++i;
        }
        File launchProperties = new File(args[0]);
        if (!launchProperties.exists()) {
            System.out.println("***** Cannot find file launch.properties at " + args[0] + ". Agent will not start.");
            return;
        }
        launchArgs.load(new FileInputStream(launchProperties));
        AUpdateInfo shimInfo = Launcher.getShimUpdateInfo(launchProperties);
        AUpdateInfo launcherInfo = Launcher.getAgentLauncherUpdateInfo(launchProperties);
        if (Launcher.executeUpdateBackup(shimInfo) && Launcher.executeUpdateBackup(shimInfo) && launchAgent && !Launcher.safeLaunchAgent(launcherInfo, args)) {
            shimInfo.restoreBackup();
            launcherInfo.restoreBackup();
            if (shimInfo.isRequestingUpdate()) {
                System.out.println("**** The update did not succeded. The agent will not load");
            } else {
                System.out.println("**** The update did not succeded. Launching with the old agent");
                if (!Launcher.safeLaunchAgent(launcherInfo, args)) {
                    System.out.println("**** Irreparable exception in configuration");
                }
            }
            launchAgent = false;
        }
        if (launchAgent) {
            Launcher.safeLaunchAgent(launcherInfo, args);
        }
    }

    private static boolean executeUpdateBackup(AUpdateInfo shimInfo) {
        if (shimInfo.isRequestingUpdate()) {
            System.out.println("***** " + shimInfo.fileName + " is requesting an update");
            if (shimInfo.backupCurrent()) {
                if (shimInfo.copyUpdate()) {
                    System.out.println("***** " + shimInfo.fileName + " backed up successfully");
                    return true;
                }
                if (shimInfo.restoreBackup()) {
                    System.out.println("***** " + shimInfo.fileName + " restored backed up successfully");
                } else {
                    System.out.println("***** " + shimInfo.fileName + " is in unrecoverable state");
                    launchAgent = false;
                }
            }
        }
        return false;
    }

    private static boolean safeLaunchAgent(AUpdateInfo launcherInfo, String[] args) {
        try {
            agentClassLoader = launcherInfo.getClassLoader();
            String launchClassName = launchArgs.getProperty("com.ca.apm.introscope.launch.agentLauncher.mainClassName");
            Class<?> agentLaunchClass = agentClassLoader.loadClass(launchClassName);
            Method m = agentLaunchClass.getMethod("main", String[].class);
            m.invoke(null, new Object[]{args});
            return true;
        }
        catch (ThreadDeath td) {
            throw td;
        }
        catch (Throwable t) {
            t.printStackTrace();
            return false;
        }
    }

    private static AUpdateInfo getShimUpdateInfo(File basePropertyFile) throws IOException {
        String updatePath = String.valueOf(basePropertyFile.getParentFile().getCanonicalPath()) + File.separator + launchArgs.getProperty("com.ca.apm.introscope.launch.shim.update");
        String backupPath = String.valueOf(basePropertyFile.getParentFile().getCanonicalPath()) + File.separator + launchArgs.getProperty("com.ca.apm.introscope.launch.shim.backup");
        String currentPath = String.valueOf(basePropertyFile.getParentFile().getCanonicalPath()) + File.separator + launchArgs.getProperty("com.ca.apm.introscope.launch.shim.current");
        String updateFileName = launchArgs.getProperty("com.ca.apm.introscope.launch.shim.updateFileName");
        String fileName = launchArgs.getProperty("com.ca.apm.introscope.launch.shim.fileName");
        AUpdateInfo result = new AUpdateInfo(currentPath, updatePath, backupPath, updateFileName, fileName, null);
        return result;
    }

    private static AUpdateInfo getAgentLauncherUpdateInfo(File basePropertyFile) throws IOException {
        String updatePath = String.valueOf(basePropertyFile.getParentFile().getCanonicalPath()) + File.separator + launchArgs.getProperty("com.ca.apm.introscope.launch.agentLauncher.update");
        String backupPath = String.valueOf(basePropertyFile.getParentFile().getCanonicalPath()) + File.separator + launchArgs.getProperty("com.ca.apm.introscope.launch.agentLauncher.backup");
        String currentPath = String.valueOf(basePropertyFile.getParentFile().getCanonicalPath()) + File.separator + launchArgs.getProperty("com.ca.apm.introscope.launch.agentLauncher.current");
        String updateFileName = launchArgs.getProperty("com.ca.apm.introscope.launch.agentLauncher.updateFileName");
        String fileName = launchArgs.getProperty("com.ca.apm.introscope.launch.agentLauncher.fileName");
        String osgiFileName = launchArgs.getProperty("com.ca.apm.introscope.launch.agentLauncher.osgiFileName");
        AUpdateInfo result = new AUpdateInfo(currentPath, updatePath, backupPath, updateFileName, fileName, osgiFileName);
        return result;
    }
}

