/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.appmap.agent.trace;

import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.activation.IOSGiClassPlugin;
import com.wily.introscope.agent.blame.ComponentTracer;
import com.wily.introscope.agent.blame.IBlameStack;
import com.wily.introscope.agent.blame.IComponentParameterCallback;
import com.wily.introscope.agent.blame.IStackType;
import com.wily.introscope.agent.trace.ABundledTracerFactory;
import com.wily.introscope.agent.trace.IMetricNameFormatListener;
import com.wily.introscope.agent.trace.INameFormatter;
import com.wily.introscope.agent.trace.ITracer;
import com.wily.introscope.agent.trace.InvocationData;
import com.wily.introscope.agent.trace.ProbeIdentification;
import com.wily.introscope.agent.trace.ReentrancyLevel;
import com.wily.introscope.agent.transactiontrace.SharedCrossProcessData;
import com.wily.introscope.appmap.agent.AppMapService;
import com.wily.introscope.appmap.agent.trace.AUniqueCandidate;
import com.wily.introscope.appmap.agent.trace.AppMapCrossProcessHelper;
import com.wily.introscope.appmap.agent.trace.MetricNamesThreadLocalHelper;
import com.wily.introscope.spec.agent.beans.appmap.IAppMapDecisionSupportBean;
import com.wily.introscope.spec.server.transactiontrace.SequenceId;
import com.wily.util.feedback.IModuleFeedbackChannel;
import com.wily.util.feedback.Module;
import com.wily.util.properties.AttributeListing;
import java.util.HashMap;
import java.util.Map;

public class AppMapEnablingTracer
extends ABundledTracerFactory
implements ITracer,
IMetricNameFormatListener,
IOSGiClassPlugin {
    private static final String kName = "AppMapEnablingTracer";
    private static final String kNoUrlFormatterResult = "None";
    private static final String kUrlFormatPlaceholder = "{url}";
    private static final Module kModule = new Module("AppMapEnablingTracer");
    private static final int kNoOperationsPerformed = 0;
    private static final int kAddedMetrics = 1;
    private static final int kRemovedComponent = 2;
    private boolean fTracingEnabled;
    private String fStackTypeHierarchyLevelString;
    private String fStackTypeOwnerTypeString;
    private boolean fShutoff = true;
    private String fNodeType;
    private IAppMapDecisionSupportBean fOracle;
    private boolean fIsTraceEnabled = false;
    private IModuleFeedbackChannel fFeedback;
    private static final String kBoundaryType = "boundaryType";
    private static final String kBoundaryTypeBackend = "Backend";
    private final boolean fIsBackend;
    static /* synthetic */ Class class$0;

    public AppMapEnablingTracer() {
        this.fIsBackend = false;
    }

    public AppMapEnablingTracer(IAgent agent, AttributeListing parameters, ProbeIdentification probe, Object sampleTracedObject) {
        super(agent, parameters, probe, sampleTracedObject);
        try {
            this.fFeedback = agent.IAgent_getModuleFeedback();
            this.fOracle = AppMapService.getOracleInstance();
            this.fShutoff = false;
        }
        catch (Throwable t) {
            try {
                this.getAgent().IAgent_getModuleFeedback().warn(kModule, "Tracer failed initialization");
                this.getAgent().IAgent_getModuleFeedback().verbose(kModule, "Tracer failed initialization", t);
            }
            catch (Throwable throwable) {}
            this.fShutoff = true;
        }
        if (!this.fShutoff) {
            this.fNodeType = this.getParameter("nodeType");
            String boundaryType = this.getParameter(kBoundaryType);
            this.fIsBackend = boundaryType != null && boundaryType.equals(kBoundaryTypeBackend);
            this.fShutoff |= this.getStackType() == null;
        } else {
            this.fIsBackend = false;
        }
    }

    public ITracer ITracerFactory_allocateTracer(int tracerIndex, InvocationData data) {
        return this;
    }

    public final void ITracerFactory_releaseTracer(int tracerIndex, ITracer tracer) {
    }

    public ReentrancyLevel ITracerFactory_getReentrancyLevel() {
        return ReentrancyLevel.kNone;
    }

    public boolean ITracerFactory_isShutoff() {
        return this.fShutoff || !AppMapService.hasStarted() || !AppMapService.isAppMapEnabled();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void ITracer_finishTrace(int tracerIndex, InvocationData data) {
        block19: {
            component = data.getComponentNameAt(tracerIndex);
            if (component == null) return;
            try {
                stackType = this.getStackType();
                stack = data.getStack(this.getComponentTracer(), true);
                this.getComponentTracer().removeMapComponent(stack, stackType, component, (IComponentParameterCallback)new DatabaseCallback(data));
                data.setAppMapTransactionalStateAt(data.getAppMapTransactionalStateAt(tracerIndex) | 2, tracerIndex);
                if (AppMapService.areMetricsEnabled()) {
                    if (this.fIsTraceEnabled) {
                        this.fFeedback.trace(AppMapEnablingTracer.kModule, "popping metrics for " + component);
                    }
                    this.popMetricNamesMap(stackType);
                    data.setAppMapTransactionalStateAt(data.getAppMapTransactionalStateAt(tracerIndex) & -2, tracerIndex);
                }
            }
            catch (Throwable var7_7) {
                var6_8 = null;
                transactionState = data.getAppMapTransactionalStateAt(tracerIndex);
                if (component == null) {
                    if (transactionState == 0) throw var7_7;
                }
                needToCleanMetrics = (transactionState & 1) == 1;
                v0 = needToCleanComponent = component != null && (transactionState & 2) != 2;
                if (!needToCleanMetrics) {
                    if (needToCleanComponent == false) throw var7_7;
                }
                stackType = this.getStackType();
                if (needToCleanMetrics) {
                    try {
                        this.popMetricNamesMap(stackType);
                    }
                    catch (ThreadDeath td) {
                        throw td;
                    }
                    catch (Throwable v1) {}
                }
                if (needToCleanComponent == false) throw var7_7;
                stack = data.getStack(this.getComponentTracer(), true);
                this.getComponentTracer().popMapComponent(stack, stackType, component);
                throw var7_7;
            }
            {
                var6_9 = null;
            }
            transactionState = data.getAppMapTransactionalStateAt(tracerIndex);
            if (component == null) {
                if (transactionState == 0) return;
            }
            needToCleanMetrics = (transactionState & 1) == 1;
            v2 = needToCleanComponent = component != null && (transactionState & 2) != 2;
            if (!needToCleanMetrics) {
                if (needToCleanComponent == false) return;
            }
            stackType = this.getStackType();
            if (needToCleanMetrics) {
                ** try [egrp 2[TRYBLOCK] [3, 4 : 209->218)] { 
lbl51:
                // 1 sources

                this.popMetricNamesMap(stackType);
                break block19;
lbl53:
                // 1 sources

                catch (ThreadDeath td) {
                    throw td;
                }
lbl55:
                // 1 sources

                catch (Throwable v3) {}
            }
        }
        if (needToCleanComponent == false) return;
        stack = data.getStack(this.getComponentTracer(), true);
        this.getComponentTracer().popMapComponent(stack, stackType, component);
    }

    public void ITracer_startTrace(int tracerIndex, InvocationData data) {
        data.setAppMapTransactionalStateAt(0, tracerIndex);
        boolean bl = this.fTracingEnabled = !this.ITracerFactory_isShutoff();
        if (!this.fTracingEnabled) {
            return;
        }
        IBlameStack stack = data.getStack(this.getComponentTracer(), true);
        if (this.getComponentTracer().getSamplingSkipFlag(stack)) {
            return;
        }
        if (!this.fIsBackend && !AppMapService.isIntermediateNodesEnabled() && data.get("AppMap.NewName") == null) {
            return;
        }
        this.fIsTraceEnabled = this.getAgent().IAgent_getModuleFeedback().isTraceEnabled(kModule);
        IStackType stackType = this.getStackType();
        String component = this.getMapComponent(data);
        if (!this.fIsBackend || !this.getComponentTracer().peekLastMapComponentWasMe(stack, stackType, component)) {
            String[] triplet = this.getAgent().IAgent_getHostProcessAgentTriplet();
            if (triplet.length != 3) {
                if (this.fIsTraceEnabled) {
                    this.fFeedback.trace(kModule, "MapEnablingTracer: error while accessing agent name. MapTracer may not run correctly for " + component);
                }
            } else {
                SharedCrossProcessData cache = AppMapEnablingTracer.getSharedProcessDataCache();
                AppMapCrossProcessHelper.setCallingHost(cache, triplet[0]);
                AppMapCrossProcessHelper.setCallingProcess(cache, triplet[1]);
                AppMapCrossProcessHelper.setCallingAgent(cache, triplet[2]);
            }
            HashMap<String, String> params = new HashMap<String, String>(3);
            String paramVal1 = this.fetchCurentOutgoingSeqId();
            String paramName1 = "OutgoingSeqNo";
            if (paramVal1 != null) {
                params.put(paramName1, paramVal1);
            }
            params.put("nodeType", this.fNodeType);
            this.getComponentTracer().addMapComponent(stack, stackType, component, params);
            data.setComponentNameAt(component, tracerIndex);
            if (AppMapService.areMetricsEnabled()) {
                AUniqueCandidate candidate = this.getUniqueCandidateMetricSet(data, component);
                this.pushMetricNamesMapNoCheckUniqueness(stackType, candidate);
                data.setAppMapTransactionalStateAt(data.getAppMapTransactionalStateAt(tracerIndex) | 1, tracerIndex);
            }
        } else if (this.fIsTraceEnabled) {
            this.fFeedback.trace(kModule, "MapEnablingTracer(" + this.getStackTypeOwnerTypeString() + "): skipping component " + component);
        }
    }

    private Object getUrl(InvocationData data) {
        INameFormatter f = this.getCustomNameFormatter();
        if (f != null) {
            String statement = kUrlFormatPlaceholder;
            return f.INameFormatter_format(statement, data);
        }
        return kNoUrlFormatterResult;
    }

    private AUniqueCandidate getUniqueCandidateMetricSet(InvocationData data, String component) {
        AUniqueCandidate candidate = AUniqueCandidate.getInstance(component, this.getStackTypeOwnerTypeString(), this.getStackTypeHierarchyLevelString(), data.getProbeInformation().getProbeIdentification().getRuntimePackageAndClassName(), data.getProbeInformation().getProbeIdentification().getProbeMethodName(), data.getProbeInformation().getProbeIdentification().getProbeMethodDescriptor());
        return candidate;
    }

    private String getStackTypeHierarchyLevelString() {
        if (this.fStackTypeHierarchyLevelString == null) {
            this.fStackTypeHierarchyLevelString = this.getParameter("nodeLevel");
        }
        return this.fStackTypeHierarchyLevelString;
    }

    private String getStackTypeOwnerTypeString() {
        if (this.fStackTypeOwnerTypeString == null) {
            this.fStackTypeOwnerTypeString = this.getParameter("ownerType");
        }
        return this.fStackTypeOwnerTypeString;
    }

    private IStackType getStackType() {
        IStackType result = AppMapService.getStackType(this.getStackTypeHierarchyLevelString(), this.getStackTypeOwnerTypeString());
        if (result == null) {
            ProbeIdentification probe = this.getProbeIdentification();
            this.getAgent().IAgent_getModuleFeedback().warn(kModule, "Tracer " + probe.getRuntimePackageAndClassName() + "." + probe.getProbeMethodName() + probe.getProbeMethodDescriptor() + " does not have correct parameters [nodeLevel, ownerType] " + this.getStackTypeHierarchyLevelString() + ";" + this.getStackTypeOwnerTypeString());
        }
        return result;
    }

    private String fetchCurentOutgoingSeqId() {
        SequenceId seq;
        SharedCrossProcessData cache = AppMapEnablingTracer.getSharedProcessDataCache();
        String outSeqId = null;
        if (cache != null && (seq = cache.getSeqID()) != null) {
            outSeqId = seq.getSequenceIdOutgoingFormat();
        }
        return outSeqId;
    }

    private String getMapComponent(InvocationData data) {
        String component = this.formatParameterizedName(data);
        if (this.fIsTraceEnabled) {
            this.fFeedback.trace(kModule, "running for component " + component + ";" + this.getStackTypeOwnerTypeString() + ";" + this.getStackTypeHierarchyLevelString());
        }
        return component;
    }

    public void notifyFormatting(String nameParameter, String result) {
        if (!this.ITracerFactory_isShutoff() && AppMapService.areMetricsEnabled()) {
            MetricNamesThreadLocalHelper.addMetricName(nameParameter, result, this.getAgent().IAgent_getModuleFeedback());
        }
    }

    private void popMetricNamesMap(IStackType myType) {
        if (myType == AppMapService.kStackTypeClassMethodApp) {
            MetricNamesThreadLocalHelper.popMetricNamesMap();
        }
    }

    private void pushMetricNamesMapNoCheckUniqueness(IStackType myType, IAppMapDecisionSupportBean.IUniqueCandidate candidate) {
        if (myType == AppMapService.kStackTypeClassMethodApp) {
            MetricNamesThreadLocalHelper.pushActiveMetricNameMap(candidate);
        }
    }

    public void ITracerFactory_addMetricNameFormatListener(IMetricNameFormatListener metricNameFormatListener) {
    }

    protected static SharedCrossProcessData getSharedProcessDataCache() {
        return ComponentTracer.staticGetCrossProcessDataCache();
    }

    public Class getPluginClass() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("com.wily.introscope.appmap.agent.trace.AppMapEnablingTracer");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return clazz;
    }

    public String getName() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("com.wily.introscope.appmap.agent.trace.AppMapEnablingTracer");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return clazz.getName();
    }

    private class DatabaseCallback
    implements IComponentParameterCallback {
        private final InvocationData fData;

        DatabaseCallback(InvocationData data) {
            this.fData = data;
        }

        public void IComponentParameterCallback_addParameters(Map parameters) {
            block3: {
                if (parameters != null && AppMapService.isCatalystIntegrationEnabled() && AppMapEnablingTracer.this.fNodeType.equals("Database")) {
                    try {
                        parameters.put("DatabaseConnection", AppMapEnablingTracer.this.getUrl(this.fData));
                    }
                    catch (Throwable t) {
                        if (!AppMapEnablingTracer.this.fFeedback.isTraceEnabled(kModule)) break block3;
                        AppMapEnablingTracer.this.fFeedback.trace(kModule, "Cannot get Database information:" + t.getMessage());
                    }
                }
            }
        }
    }
}

