/*
 * Decompiled with CFR 0.152.
 */
package com.wily.powerpack.websphereMQ.agent.JCAConnectionPool.jmx;

import com.wily.introscope.agent.IAgent;
import com.wily.powerpack.websphereMQ.agent.JCAConnectionPool.websphere.AWebAppSupportReflectionDelegatingService;
import com.wily.util.properties.IndexedProperties;

public final class JMXDelegatingService
extends AWebAppSupportReflectionDelegatingService {
    public JMXDelegatingService() {
        super("JMX", "com.wily.introscope.agent.jmx.JMXService", JMXDelegatingService.class.getClassLoader());
    }

    protected boolean doShouldAttemptDelegateLoad(IAgent agent) {
        boolean result = false;
        String[] kJMXClassNames = new String[]{"javax.management.ObjectName", "javax.management.MBeanServer", "javax.management.MBeanServerFactory"};
        IndexedProperties props = agent.IAgent_getIndexedProperties();
        boolean jmxOn = props.getBooleanProperty("introscope.agent.jmx.enable");
        if (jmxOn) {
            try {
                agent.IAgent_getModuleFeedback().info(agent.IAgent_getStringLocalizer().IStringLocalizer_getLocalizedString("Agent_JMX_Activating_JMX_Message"));
                int i = 0;
                while (i < kJMXClassNames.length) {
                    Class.forName(kJMXClassNames[i]);
                    ++i;
                }
                result = true;
            }
            catch (Throwable t) {
                this.reportFailure(agent, t);
            }
        }
        return result;
    }

    protected void doHandleDelegateLoadException(IAgent agent, Throwable t) {
        this.reportFailure(agent, t);
    }

    private void reportFailure(IAgent agent, Throwable t) {
        try {
            agent.IAgent_getModuleFeedback().error(agent.IAgent_getStringLocalizer().IStringLocalizer_getLocalizedString("Agent_JMX_Failed_To_Activate_JMX_Message"));
            agent.IAgent_getModuleFeedback().verbose(t);
        }
        catch (Throwable throwable) {}
    }
}

