/*
 * Decompiled with CFR 0.152.
 */
package com.wily.ui;

import com.wily.wilyassert.Assertion;

public class ThresholdValue {
    private boolean fIsGreater = true;
    private double fDangerValue;
    private boolean fDanger = false;
    private double fCautionValue;
    private boolean fCaution = false;

    public ThresholdValue(double dangerValue, boolean isGreater) {
        this.fIsGreater = isGreater;
        this.fDangerValue = dangerValue;
        this.fDanger = true;
        this.fCaution = false;
        this.fCautionValue = 0.0;
    }

    public ThresholdValue(double cautionValue, double dangerValue, boolean isGreater) {
        if (isGreater) {
            Assertion.wilyAssert(cautionValue <= dangerValue);
        } else {
            Assertion.wilyAssert(cautionValue >= dangerValue);
        }
        this.fIsGreater = isGreater;
        this.fCautionValue = cautionValue;
        this.fDangerValue = dangerValue;
        this.fCaution = true;
        this.fDanger = true;
    }

    public double getDangerValue() {
        return this.fDangerValue;
    }

    public boolean hasDanger() {
        return this.fDanger;
    }

    public double getCautionValue() {
        return this.fCautionValue;
    }

    public boolean hasCaution() {
        return this.fCaution;
    }

    public boolean isGreaterThanComparison() {
        return this.fIsGreater;
    }

    public boolean isLessThanComnparison() {
        return !this.fIsGreater;
    }

    public boolean isDanger(double value) {
        if (this.fIsGreater) {
            return value > this.fDangerValue;
        }
        return value < this.fDangerValue;
    }

    public boolean isCaution(double value) {
        if (this.fIsGreater) {
            return value > this.fCautionValue;
        }
        return value < this.fCautionValue;
    }

    public Object clone() {
        return new ThresholdValue(this);
    }

    private ThresholdValue(ThresholdValue thresholdValue) {
        this.fDangerValue = thresholdValue.fDangerValue;
        this.fCautionValue = thresholdValue.fCautionValue;
        this.fCaution = thresholdValue.fCaution;
        this.fIsGreater = thresholdValue.fIsGreater;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null || !(o instanceof ThresholdValue)) {
            return false;
        }
        ThresholdValue value = (ThresholdValue)o;
        return this.fIsGreater == value.fIsGreater && this.fDangerValue == value.fDangerValue && this.fCautionValue == value.fCautionValue && this.fDanger == value.fDanger && this.fCaution == value.fCaution;
    }

    public int hashCode() {
        int hash = 17;
        hash = hash * 37 + (this.fIsGreater ? 3457 : 3460);
        hash = hash * 37 + new Double(this.fDangerValue).hashCode();
        hash = hash * 37 + new Double(this.fCautionValue).hashCode();
        hash = hash * 37 + (this.fDanger ? 487 : 3459);
        hash = hash * 37 + (this.fCaution ? 48762 : 1265);
        return hash;
    }
}

