/*
 * Decompiled with CFR 0.152.
 */
package com.wily.ui.action;

import com.wily.properties.KUICommonStringsKeys;
import com.wily.ui.action.IExtendedAction;
import com.wily.util.text.ALocalizableException;
import com.wily.util.text.ILocalizableException;
import com.wily.util.text.ILocalizableMessage;
import com.wily.util.text.IStringLocalizer;

public class ExtendedActionException
extends ALocalizableException
implements ILocalizableException,
KUICommonStringsKeys {
    private static final long serialVersionUID = 1609381839997101795L;
    public static final int kTrigger = 10;
    public static final int kReverse = 11;
    public static final int kRedo = 12;
    private IExtendedAction fActionThatThrew;
    private int fVerb;

    public ExtendedActionException(IExtendedAction action, String exceptionMessage, ILocalizableMessage userMessage) {
        this(action, null, exceptionMessage, userMessage);
    }

    public ExtendedActionException(IExtendedAction action, Exception nestedException, String exceptionMessage, ILocalizableMessage userMessage) {
        super(exceptionMessage, nestedException, userMessage);
        this.fActionThatThrew = action;
        this.fVerb = 10;
    }

    public ExtendedActionException(IExtendedAction action, Exception nestedException, String exceptionMessage, ILocalizableMessage userMessage, int verbThatFailed) {
        super(exceptionMessage, nestedException, userMessage);
        this.fActionThatThrew = action;
        this.fVerb = verbThatFailed;
    }

    protected ExtendedActionException(ExtendedActionException actionExceptionToClone, IExtendedAction actionThatThrew) {
        super(actionExceptionToClone.getMessage(), actionExceptionToClone.getCause(), actionExceptionToClone.ILocalizableException_getLocalizableMessage());
        this.fActionThatThrew = actionThatThrew;
        this.fVerb = actionExceptionToClone.getVerbThatFailed();
    }

    public IExtendedAction getActionThatThrew() {
        return this.fActionThatThrew;
    }

    private int getVerbThatFailed() {
        return this.fVerb;
    }

    public Throwable getRootException() {
        if (this.getCause() instanceof ExtendedActionException) {
            return ((ExtendedActionException)this.getCause()).getRootException();
        }
        return this.getCause();
    }

    public String getUserMessageTitle(IStringLocalizer localizer) {
        String verbMessageKey;
        switch (this.getVerbThatFailed()) {
            case 11: {
                verbMessageKey = "compound_action_reverse_failed_postfix";
                break;
            }
            case 12: {
                verbMessageKey = "compound_action_redo_failed_postfix";
                break;
            }
            default: {
                verbMessageKey = "compound_action_trigger_failed_postfix";
            }
        }
        String verbMessage = localizer.IStringLocalizer_getLocalizedString(verbMessageKey);
        return this.getActionThatThrew().IExtendedAction_getName() + " " + verbMessage;
    }

    public String getUserMessageExplanation(IStringLocalizer localizer) {
        return this.ILocalizableException_getLocalizableMessage().ILocalizableMessage_getLocalizedMessage(localizer);
    }

    public String getEntireUserMessage(IStringLocalizer localizer) {
        return localizer.IStringLocalizer_getFormattedLocalizedString("Formatted_Extended_Action_Exception_Full_User_Message", this.getUserMessageTitle(localizer), this.getUserMessageExplanation(localizer));
    }

    public String getMessage() {
        if (this.getRootException() == null) {
            return super.getMessage();
        }
        String msg = this.getRootException().getMessage();
        if (msg == null || msg.length() == 0) {
            msg = this.getRootException().getClass().getName();
        }
        return super.getMessage() + "[root exception message: " + msg + "]";
    }

    public ExtendedActionException clone(IExtendedAction actionThatThrew) {
        return new ExtendedActionException(this, actionThatThrew);
    }
}

