/*
 * Decompiled with CFR 0.152.
 */
package com.wily.ui.wizard;

import com.wily.ui.WilyUIUtilities;
import com.wily.ui.wizard.AWizard;
import java.awt.FlowLayout;
import javax.swing.JButton;
import javax.swing.JPanel;

public class WizardControlPanel
extends JPanel {
    private static final long serialVersionUID = 7634818039714701250L;
    private AWizard fWizard;
    private JButton fPreviousButton = null;
    private JButton fNextButton = null;
    private JButton fCancelButton = null;
    private JButton fHelpButton = null;

    WizardControlPanel(AWizard wizard, boolean canCancel, boolean hasHelp) {
        this.fWizard = wizard;
        this.fPreviousButton = new JButton(this.fWizard.getPreviousText());
        WilyUIUtilities.setActionForButton(this.fWizard.getPreviousAction(), this.fPreviousButton);
        this.fNextButton = new JButton(this.fWizard.getNextText());
        WilyUIUtilities.setActionForButton(this.fWizard.getNextAction(), this.fNextButton);
        if (canCancel) {
            this.fCancelButton = new JButton(this.fWizard.getCancelText());
            WilyUIUtilities.setActionForButton(this.fWizard.getCancelAction(), this.fCancelButton);
        }
        if (hasHelp) {
            this.fHelpButton = new JButton(this.fWizard.getHelpText());
            WilyUIUtilities.setActionForButton(this.fWizard.getHelpAction(), this.fHelpButton);
        }
        this.buildUI();
    }

    private void buildUI() {
        this.setLayout(new FlowLayout(1));
        if (this.fCancelButton != null) {
            this.add(this.fCancelButton);
        }
        if (this.fHelpButton != null) {
            this.add(this.fHelpButton);
        }
        this.add(this.fPreviousButton);
        this.add(this.fNextButton);
    }

    public void updateControls() {
        this.fPreviousButton.setText(this.fWizard.getPreviousText());
        this.fPreviousButton.setMnemonic(this.fWizard.getPreviousMnemonic());
        this.fWizard.getPreviousAction().setEnabled(this.fWizard.isPreviousEnabled());
        this.fNextButton.setText(this.fWizard.getNextText());
        this.fNextButton.setMnemonic(this.fWizard.getNextMnemonic());
        this.fWizard.getNextAction().setEnabled(this.fWizard.isNextEnabled());
        if (this.fCancelButton != null) {
            this.fCancelButton.setText(this.fWizard.getCancelText());
            this.fCancelButton.setMnemonic(this.fWizard.getCancelMnemonic());
            this.fWizard.getCancelAction().setEnabled(this.fWizard.isCancelEnabled());
        }
        if (this.fHelpButton != null) {
            this.fHelpButton.setText(this.fWizard.getHelpText());
            this.fHelpButton.setMnemonic(this.fWizard.getHelpMnemonic());
            this.fWizard.getHelpAction().setEnabled(this.fWizard.isHelpEnabled());
        }
        JButton button = null;
        switch (this.fWizard.getDefaultButtonIndex()) {
            case 1: {
                button = this.fCancelButton;
                break;
            }
            case 2: {
                button = this.fHelpButton;
                break;
            }
            case 3: {
                button = this.fPreviousButton;
                break;
            }
            case 4: {
                button = this.fNextButton;
            }
        }
        if (button != null) {
            this.fWizard.setDefaultButton(button);
        }
    }

    public void next() {
        this.fNextButton.doClick();
    }

    public void cancel() {
        if (this.fCancelButton != null) {
            this.fCancelButton.doClick();
        }
    }

    public void disableControls() {
        this.setEnabled(false);
    }

    public void enableControls() {
        this.setEnabled(true);
    }

    public void setEnabled(boolean enabledState) {
        this.fWizard.getPreviousAction().setEnabled(enabledState);
        this.fWizard.getNextAction().setEnabled(enabledState);
        if (this.fCancelButton != null) {
            this.fWizard.getCancelAction().setEnabled(enabledState);
        }
        if (this.fHelpButton != null) {
            this.fWizard.getHelpAction().setEnabled(enabledState);
        }
    }
}

