/*
 * Decompiled with CFR 0.152.
 */
package com.ca.apm.parent.instrumentation;

import com.ca.apm.parent.instrumentation.filter.AndFilter;
import com.ca.apm.parent.instrumentation.filter.ClassFilter;
import com.ca.apm.parent.instrumentation.filter.FilterExecutor;
import com.ca.apm.parent.instrumentation.filter.IndexBasedFilter;
import com.ca.apm.parent.instrumentation.filter.MethodFilter;
import com.ca.apm.parent.instrumentation.filter.OrFilter;
import com.ca.apm.parent.instrumentation.filter.TraceElementFilter;
import com.ca.apm.parent.instrumentation.helper.JMSReceiveStackTraceRepository;
import com.ca.apm.parent.instrumentation.helper.JMSStackTraceWrappper;
import com.ca.apm.parent.instrumentation.helper.ParentCandidateFilePersistenceHelper;
import com.ca.apm.parent.instrumentation.helper.ParentInstrumentationConfig;
import com.ca.apm.parent.instrumentation.helper.ParentInstrumentationHelper;
import com.ca.apm.parent.instrumentation.helper.WrappedStackTraceElement;
import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.trace.backend.jms.helper.JMSReceiveStackTTraceController;
import com.wily.introscope.agent.transformer.TransformerAdministrator;
import com.wily.introscope.agent.transformer.dynamic.IClassRedefinitionDelegate;
import com.wily.introscope.api.instrument.AClassRedefinitionDelegate;
import com.wily.introscope.autoprobe.AutoProbeTransformer;
import com.wily.util.classfile.InvalidMethodDescriptorException;
import com.wily.util.classfile.InvalidMethodNameException;
import com.wily.util.classfile.java.MethodName;
import com.wily.util.feedback.IModuleFeedbackChannel;
import com.wily.util.feedback.Module;
import com.wily.util.heartbeat.IRegisteredBehavior;
import com.wily.util.heartbeat.ITimestampedRunnable;
import java.lang.instrument.Instrumentation;
import java.lang.ref.WeakReference;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.Callable;

public class ParentCandidateAnalyzer
implements ITimestampedRunnable {
    public static boolean isInitialized = false;
    static IRegisteredBehavior parentCandidateProcessor = null;
    private static IAgent fAgent;
    private static volatile IModuleFeedbackChannel feedback;
    static final Module module;
    private static volatile ParentInstrumentationHelper helper;
    private static int parentCandidateProcessorInterval;
    private static int filePersistenceHelperInterval;
    private static HashMap<String, List<WrappedStackTraceElement>> initialParentCandidates;
    private static HashMap<String, WeakReference<Class>> parentCandidatesClassObjectMap;
    private FilterEngine engine = null;

    static {
        module = new Module("ParentCandidateAnalyzer");
        parentCandidateProcessorInterval = 60000;
        filePersistenceHelperInterval = 60000;
        initialParentCandidates = new HashMap();
        parentCandidatesClassObjectMap = new HashMap();
    }

    public ParentCandidateAnalyzer() {
        this.initializeHelper();
    }

    public static void InitializeService(IAgent agent) {
        fAgent = agent;
        feedback = agent.IAgent_getModuleFeedback();
        ParentCandidateAnalyzer.initialize(agent);
    }

    private void initializeHelper() {
        if (helper == null && fAgent != null) {
            try {
                helper = new ParentInstrumentationHelper(fAgent);
            }
            catch (Exception e) {
                feedback.error(module, e.getMessage());
            }
        }
    }

    private static void initialize(IAgent agent) {
        try {
            if (!isInitialized && agent != null && ParentCandidateAnalyzer.shouldStartServices(agent)) {
                parentCandidateProcessorInterval = agent.IAgent_getIndexedProperties().safeGetPositiveIntProperty("jms.receive.parent.candidate.processor.intervalSeconds", parentCandidateProcessorInterval, agent.IAgent_getModuleFeedback(), agent.IAgent_getStringLocalizer());
                parentCandidateProcessor = agent.IAgent_getCommonHeartbeat().addBehavior((ITimestampedRunnable)new ParentCandidateAnalyzer(), "ParentCandidateProcessor", true, (long)parentCandidateProcessorInterval, false);
                new ParentInstrumentationConfig().init(agent);
                ParentCandidateAnalyzer.initializeFilePersistenceService(agent);
                ParentCandidateAnalyzer.setInitializationStatus(true);
            }
        }
        catch (Exception e) {
            feedback.error(module, e.getMessage());
        }
    }

    private static void initializeFilePersistenceService(IAgent agent) throws Exception {
        filePersistenceHelperInterval = agent.IAgent_getIndexedProperties().safeGetPositiveIntProperty("jms.receive.parent.file.persistence.service.interval", filePersistenceHelperInterval, agent.IAgent_getModuleFeedback(), agent.IAgent_getStringLocalizer());
        ParentCandidateFilePersistenceHelper filePersistWorker = new ParentCandidateFilePersistenceHelper(agent);
        agent.IAgent_getConfigHeartbeat().addBehavior((ITimestampedRunnable)filePersistWorker, "ParentCandidateFilePersistenceHelper", true, (long)filePersistenceHelperInterval, false);
    }

    private static boolean shouldStartServices(IAgent agent) {
        String messagePrefix = "JMS Parent Instrumentation Service is turned off";
        boolean featureEnabled = agent.IAgent_getIndexedProperties().safeGetBooleanProperty("jms.receive.parent.candidate.processor.enabled", true, agent.IAgent_getModuleFeedback(), agent.IAgent_getStringLocalizer());
        if (!featureEnabled) {
            feedback.warn(messagePrefix);
            return false;
        }
        Instrumentation inst = null;
        IClassRedefinitionDelegate classRedefinitionDelegate = null;
        TransformerAdministrator tAdm = agent.IAgent_getTransformerAdministrator();
        AutoProbeTransformer dit = (AutoProbeTransformer)tAdm.getDynamicInstrumentationTransformer();
        if (dit != null && (classRedefinitionDelegate = dit.getClassRedefinitionDelegate()) != null) {
            inst = ((AClassRedefinitionDelegate)classRedefinitionDelegate).getInstrumentation();
        }
        if (agent.IAgent_getComponentTracer().isAgentOldMode()) {
            feedback.warn(String.valueOf(messagePrefix) + " due to use of old agent configuration.");
            return false;
        }
        if (!agent.IAgent_getIndexedProperties().getBooleanProperty("introscope.autoprobe.enable", false)) {
            feedback.warn(String.valueOf(messagePrefix) + " because Introscope AutoProbe has been disabled.");
            return false;
        }
        if (inst == null) {
            feedback.warn(messagePrefix);
            return false;
        }
        if (!inst.isRedefineClassesSupported()) {
            feedback.warn(String.valueOf(messagePrefix) + " because DI is not supported.");
            return false;
        }
        if (!agent.IAgent_getIndexedProperties().getBooleanProperty("introscope.autoprobe.dynamicinstrument.enabled", false)) {
            feedback.warn(String.valueOf(messagePrefix) + " because DI has been disabled.");
            return false;
        }
        return true;
    }

    public static void setInitializationStatus(boolean status) {
        isInitialized = status;
    }

    public static boolean isInitialized() {
        return isInitialized;
    }

    public void ITimestampedRunnable_execute(long nowInMillis) {
        if (JMSReceiveStackTraceRepository.isEmpty()) {
            return;
        }
        try {
            try {
                int i = 0;
                while (i < 20) {
                    try {
                        JMSStackTraceWrappper stackTraceWrappper = JMSReceiveStackTraceRepository.poll();
                        if (stackTraceWrappper == null) break;
                        StackTraceElement[] stackTrace = stackTraceWrappper.getStackTrace();
                        if (this.engine == null) {
                            this.initFilters();
                        }
                        if (this.engine == null || !this.engine.executeFilters(stackTrace)) {
                            feedback.debug(module, "Unable to identify parent for JMS receive of class and method :" + stackTraceWrappper.getClassName() + ":" + stackTraceWrappper.getMethodName());
                        }
                    }
                    catch (Exception ex) {
                        feedback.error(module, "Exception seen when processing the stack trace element for parent candidate " + ex.getMessage());
                    }
                    ++i;
                }
                this.processAllInitialParentCandidates();
            }
            catch (Exception ex) {
                feedback.error(module, "Exception seen when processing the parent candidates" + ex.getMessage());
                initialParentCandidates.clear();
                parentCandidatesClassObjectMap.clear();
                JMSReceiveStackTTraceController.resetLimitCounter();
            }
        }
        finally {
            initialParentCandidates.clear();
            parentCandidatesClassObjectMap.clear();
            JMSReceiveStackTTraceController.resetLimitCounter();
        }
    }

    private void initFilters() {
        ClassFilter classNameFilter = new ClassFilter("java,javax,sun,com.sun,com.wily", "(.*\\$Lambda\\$.*)|(.*\\$Proxy\\$.*)");
        MethodFilter methodNameFilter = new MethodFilter("lambda$", false);
        AndFilter classAndMethodNamefilter = new AndFilter(classNameFilter, methodNameFilter);
        MethodFilter methodMatchingFilter = new MethodFilter("run,call", true);
        IndexBasedFilter indexMatchingFilter = new IndexBasedFilter(false);
        OrFilter methodOrIndexMatchingfilter = new OrFilter(methodMatchingFilter, indexMatchingFilter);
        AndFilter finalFilter = new AndFilter(classAndMethodNamefilter, methodOrIndexMatchingfilter);
        this.engine = new FilterEngine();
        this.engine.addFilter(finalFilter);
    }

    private void processAllInitialParentCandidates() {
        boolean success = false;
        if (initialParentCandidates.size() > 0) {
            this.loadJVMClasses();
            block0: for (String key : initialParentCandidates.keySet()) {
                List<WrappedStackTraceElement> parentCandidates = initialParentCandidates.get(key);
                if (parentCandidates == null || parentCandidates.size() <= 0) continue;
                for (WrappedStackTraceElement trace : parentCandidates) {
                    Class classObj;
                    String className = trace.getClassName();
                    WeakReference<Class> ref = parentCandidatesClassObjectMap.get(className);
                    if (ref == null || (classObj = (Class)ref.get()) == null) continue;
                    if (trace.isThreadStartElement()) {
                        if (Callable.class.isAssignableFrom(classObj) || Runnable.class.isAssignableFrom(classObj)) {
                            success = this.findMethodAndPersist(className, trace.getMethodName(), classObj);
                        }
                    } else {
                        success = this.findMethodAndPersist(className, trace.getMethodName(), classObj);
                    }
                    if (success) continue block0;
                }
            }
        }
    }

    private boolean findMethodAndPersist(String className, String methodName, Class clazz) {
        boolean success = false;
        Method[] methods = clazz.getDeclaredMethods();
        int j = 0;
        while (j < methods.length) {
            String method = methods[j].getName();
            if (method.length() == methodName.length() && method.equals(methodName)) {
                try {
                    MethodName mname = MethodName.getMethodName((Method)methods[j], (boolean)true);
                    this.persistData(className, methodName, mname.getMethodDescriptor().toString());
                    success = true;
                }
                catch (InvalidMethodDescriptorException e) {
                    feedback.error(module, e.getMessage());
                }
                catch (InvalidMethodNameException e) {
                    feedback.error(module, e.getMessage());
                }
            }
            ++j;
        }
        return success;
    }

    private void loadJVMClasses() {
        Class[] classesInVM;
        Class[] classArray = classesInVM = helper.getAllClassesInVm();
        int n = classesInVM.length;
        int n2 = 0;
        while (n2 < n) {
            Class clazz = classArray[n2];
            String className = clazz.getName();
            if (parentCandidatesClassObjectMap.containsKey(className)) {
                parentCandidatesClassObjectMap.put(className, new WeakReference<Class>(clazz));
            }
            ++n2;
        }
    }

    private void persistData(String className, String methodName, String desc) {
        String[] methodInfo = new String[]{className, methodName, desc, "instrument"};
        StringBuilder builder = new StringBuilder();
        builder.append(className).append(methodName).append(desc);
        String str = builder.toString();
        feedback.info(module, "Identified Parent Candidate class and method : " + className + "-" + methodName);
        if (!helper.persistParentCandidate(str, methodInfo)) {
            feedback.debug(module, "Unable to persist the parent candidate because either clamp is hit or entry already exists - " + str);
        }
    }

    private final class FilterEngine
    implements FilterExecutor {
        private List<WrappedStackTraceElement> threadStartElements = new ArrayList<WrappedStackTraceElement>(2);
        private List<WrappedStackTraceElement> possibleParentElements = new ArrayList<WrappedStackTraceElement>(5);
        private List<TraceElementFilter> filterList = new ArrayList<TraceElementFilter>(1);

        private FilterEngine() {
        }

        @Override
        public boolean executeFilters(StackTraceElement[] stackTrace) {
            int sizeOfStackTrace = stackTrace.length;
            int relativeIndex = 1;
            boolean probableParentIdentified = false;
            try {
                try {
                    int i = 0;
                    while (i < stackTrace.length) {
                        StackTraceElement traceElement = stackTrace[i];
                        if (traceElement != null && traceElement.getClassName() != null && traceElement.getMethodName() != null) {
                            WrappedStackTraceElement element = new WrappedStackTraceElement(traceElement, relativeIndex++, sizeOfStackTrace);
                            boolean result = false;
                            for (TraceElementFilter filter : this.filterList) {
                                result = filter.doFilter(element);
                            }
                            if (result && element.isThreadStartElement()) {
                                this.threadStartElements.add(element);
                                probableParentIdentified = true;
                            } else if (result) {
                                this.possibleParentElements.add(element);
                                probableParentIdentified = true;
                            }
                        }
                        ++i;
                    }
                    ArrayList<WrappedStackTraceElement> list = new ArrayList<WrappedStackTraceElement>();
                    StringBuilder builder = new StringBuilder();
                    if (ParentInstrumentationConfig.isThreadStartDetectionEnabled() && this.threadStartElements.size() > 0) {
                        for (WrappedStackTraceElement trace : this.threadStartElements) {
                            parentCandidatesClassObjectMap.put(trace.getClassName(), null);
                            list.add(trace);
                        }
                        builder.append(this.threadStartElements.get(0).getClassName());
                        builder.append(this.threadStartElements.get(0).getMethodName());
                    }
                    if (this.possibleParentElements.size() > 0) {
                        WrappedStackTraceElement trace;
                        trace = this.possibleParentElements.get(this.possibleParentElements.size() - 1);
                        builder.append(trace.getClassName());
                        builder.append(trace.getMethodName());
                        parentCandidatesClassObjectMap.put(trace.getClassName(), null);
                        list.add(trace);
                    }
                    if (probableParentIdentified && !initialParentCandidates.containsKey(builder.toString())) {
                        initialParentCandidates.put(builder.toString(), list);
                    }
                }
                catch (Exception ex) {
                    feedback.error(module, "Exception seen when executing the filters for parent candidate " + ex.getMessage());
                    if (probableParentIdentified) {
                        this.threadStartElements.clear();
                        this.possibleParentElements.clear();
                    }
                }
            }
            finally {
                if (probableParentIdentified) {
                    this.threadStartElements.clear();
                    this.possibleParentElements.clear();
                }
            }
            return probableParentIdentified;
        }

        public void addFilter(TraceElementFilter filter) {
            if (filter != null) {
                this.filterList.add(filter);
            }
        }
    }
}

