/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.trace.frontend.jms;

import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.trace.IInvocationDataParameterCallback;
import com.wily.introscope.agent.trace.InvocationData;
import com.wily.introscope.agent.trace.ProbeIdentification;
import com.wily.introscope.agent.trace.backendprotocols.BackendProtocolsConstants;
import com.wily.introscope.agent.trace.hc2.FrontendTracer;
import com.wily.introscope.agent.util.ReflectionUtils;
import com.wily.util.feedback.IModuleFeedbackChannel;
import com.wily.util.feedback.Module;
import com.wily.util.properties.AttributeListing;
import java.util.Map;

public class JMSFrontendTracer
extends FrontendTracer
implements IInvocationDataParameterCallback,
BackendProtocolsConstants {
    final IModuleFeedbackChannel logger;
    final Module module = new Module("JmsFrontendTracer");

    public JMSFrontendTracer(IAgent agent, AttributeListing parameters, ProbeIdentification probe, Object sampleTracedObject) {
        super(agent, parameters, probe, sampleTracedObject);
        this.logger = agent.IAgent_getModuleFeedback();
    }

    public void ITracer_startTrace(int tracerIndex, InvocationData data) {
        Object message = data.getInvocationParameterAsObject(0);
        if (message == null) {
            return;
        }
        data.setParameterCallback((IInvocationDataParameterCallback)this);
        Object dest = this.getDestination(data);
        if (dest != null) {
            boolean isQueue = this.isQueue(data, dest);
            if (isQueue) {
                this.getQueueName(data, dest);
            } else if (this.isTopic(data, dest)) {
                this.getTopicName(data, dest);
            }
        }
        super.ITracer_startTrace(tracerIndex, data);
    }

    private Object getDestination(InvocationData data) {
        Object dest = null;
        try {
            dest = ReflectionUtils.invokeMethodOnObject((Object)data.getInvocationParameterAsObject(0), (String)"getJMSDestination", (Class[])new Class[0], (Object[])new Object[0]);
        }
        catch (Exception e) {
            this.logger.error(this.module, "Could not get Destination Object" + e);
            return null;
        }
        return dest;
    }

    private boolean isQueue(InvocationData data, Object dest) {
        Class<?> queueClass = null;
        Boolean isQueue = (Boolean)data.get("Jms.is.Queue.Key");
        if (isQueue != null) {
            return isQueue;
        }
        boolean result = false;
        if (dest != null) {
            try {
                queueClass = Class.forName("javax.jms.Queue", true, dest.getClass().getClassLoader());
            }
            catch (ClassNotFoundException e) {
                this.logger.error(this.module, "Could not get Class information for Queue " + e.getMessage());
                data.put("Jms.is.Queue.Key", (Object)false);
                return false;
            }
            result = queueClass.isAssignableFrom(dest.getClass());
            data.put("Jms.is.Queue.Key", (Object)result);
        }
        return result;
    }

    private boolean isTopic(InvocationData data, Object dest) {
        Class<?> topicClass = null;
        Boolean isTopic = (Boolean)data.get("Jms.is.Topic.Key");
        if (isTopic != null) {
            return isTopic;
        }
        boolean result = false;
        if (dest != null) {
            try {
                topicClass = Class.forName("javax.jms.Topic", true, dest.getClass().getClassLoader());
            }
            catch (ClassNotFoundException e) {
                this.logger.error(this.module, "Could not get Class information for Queue " + e.getMessage());
                data.put("Jms.is.Topic.Key", (Object)false);
                return false;
            }
            result = topicClass.isAssignableFrom(dest.getClass());
            data.put("Jms.is.Topic.Key", (Object)result);
        }
        return result;
    }

    private String getQueueName(InvocationData data, Object queue) {
        String queueName = "Unknown Queue";
        String cachedQueueName = (String)data.get("Jms.Queue.Key");
        if (cachedQueueName != null) {
            return cachedQueueName;
        }
        if (queue != null) {
            try {
                queueName = (String)ReflectionUtils.invokeMethodOnObject((Object)queue, (String)"getQueueName", (Class[])new Class[0], (Object[])new Object[0]);
            }
            catch (Exception e) {
                this.logger.error(this.module, "Unable to get Queue Name" + e.getCause().getMessage());
            }
        }
        data.put("Jms.Queue.Key", (Object)queueName);
        return queueName;
    }

    private String getTopicName(InvocationData data, Object topic) {
        String topicName = "Unknown Topic";
        String cachedtopicName = (String)data.get("Jms.Topic.Key");
        if (cachedtopicName != null) {
            return cachedtopicName;
        }
        if (topic != null) {
            try {
                topicName = (String)ReflectionUtils.invokeMethodOnObject((Object)topic, (String)"getTopicName", (Class[])new Class[0], (Object[])new Object[0]);
            }
            catch (Exception e) {
                this.logger.error(this.module, "Unable to get Topic Name" + e.getCause().getMessage());
            }
        }
        data.put("Jms.Topic.Key", (Object)topicName);
        return topicName;
    }

    public void ITracer_finishTrace(int tracerIndex, InvocationData data) {
        Object message = data.getInvocationParameterAsObject(0);
        if (message == null) {
            return;
        }
        super.ITracer_finishTrace(tracerIndex, data);
    }

    public void IInvocationDataParameterCallback_addParameters(InvocationData data, Map parameters) {
        if (this.isQueue(data, null)) {
            parameters.put("Queue Name", this.getQueueName(data, null));
        } else if (this.isTopic(data, null)) {
            parameters.put("Topic Name", this.getTopicName(data, null));
        }
    }
}

