/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.intelligent.detection.rules;

import com.wily.introscope.agent.intelligent.detection.rules.AbstractRule;
import com.wily.introscope.agent.intelligent.entrypoint.apis.ExecutionStatus;
import com.wily.introscope.agent.intelligent.entrypoint.apis.IndexAwareTraceElement;
import com.wily.introscope.agent.intelligent.entrypoint.common.Utils;

public class IsInBottomNPercentRule
extends AbstractRule {
    private float percentageValue;
    private float excludePercentFactor;

    public IsInBottomNPercentRule(float percentageValue) {
        this.percentageValue = percentageValue;
        this.excludePercentFactor = (100.0f - percentageValue) / 100.0f;
    }

    @Override
    public boolean doExecute(int currentElementIndex, IndexAwareTraceElement[] trace, ExecutionStatus status) {
        int size;
        int cutoff;
        IndexAwareTraceElement traceElement = trace[currentElementIndex];
        int index = traceElement.getIndex();
        return index >= (cutoff = Math.round(this.excludePercentFactor * (float)(size = traceElement.getSizeOfMyStackTrace()))) && index < size;
    }

    @Override
    public String toString() {
        return Utils.formatStringRep(String.valueOf(this.getClass().getSimpleName()) + ", percentage:" + this.percentageValue);
    }

    public float getPercentageValue() {
        return this.percentageValue;
    }
}

