/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.intelligent.entrypoint;

import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.intelligent.entrypoint.Logger;
import com.wily.introscope.agent.intelligent.entrypoint.stacktrace.StackTraceRecordingController;
import com.wily.introscope.agent.intelligent.entrypoint.stacktrace.ThreadSelector;
import com.wily.introscope.agent.trace.intelligent.DeepTraceConfigurations;
import com.wily.util.StringUtils;
import com.wily.util.feedback.IModuleFeedbackChannel;
import com.wily.util.feedback.Module;
import com.wily.util.properties.hot.BooleanConfigurationProperty;
import com.wily.util.properties.hot.ConfigurationManager;
import com.wily.util.properties.hot.ConfigurationProperty;
import com.wily.util.properties.hot.IntegerConfigurationProperty;
import com.wily.util.properties.hot.StringSetConfigurationProperty;
import com.wily.util.text.IStringLocalizer;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;

public class EntryPointDetectionConfiguration {
    private static final Module iiModule = Logger.getModule();
    private static volatile boolean initCompleted = false;
    private static volatile boolean isEntryPointDetectionEnabled = true;
    private static volatile Set<String> methodNamesToSkip = EntryPointDetectionConfiguration.getDefaultMethodNamesToSkip();
    private static volatile Set<String> essentialPackagesToSkip = EntryPointDetectionConfiguration.getDefaultEssentialPackagesToSkip();
    private static volatile Set<String> additionalPackagesToSkip = EntryPointDetectionConfiguration.getDefaultAdditionalPackagesToSkip();
    private static volatile Set<String> appPackages = EntryPointDetectionConfiguration.getDefaultApplicationPackages();
    private static volatile Set<String> interestingMethodNames = EntryPointDetectionConfiguration.getDefaultInterestingMethodNames();
    private static volatile float includeBottomPercent = 50.0f;
    private static volatile float skipTopPercent = 50.0f;
    private static volatile boolean shouldLogStackTraces = true;
    private static volatile int maxRules = 50;
    private static volatile int stackTraceRecordingsLimitPerInterval = 5;
    private static volatile int numberOfIntervalsToElapse = 4;
    private static volatile int candidateFinderInterval = 15;
    private static volatile boolean deepTracingEnabled = true;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void init(IAgent agent) {
        boolean result = initCompleted;
        if (result) return;
        Class<EntryPointDetectionConfiguration> clazz = EntryPointDetectionConfiguration.class;
        synchronized (EntryPointDetectionConfiguration.class) {
            result = initCompleted;
            if (result) return;
            EntryPointDetectionConfiguration.initializeEntryPointDetectionEnabled(agent);
            EntryPointDetectionConfiguration.initializeDeepTracingStatus();
            EntryPointDetectionConfiguration.initializeMethodNamesToSkip(agent);
            EntryPointDetectionConfiguration.initializeEssentialPackagesToSkip(agent);
            EntryPointDetectionConfiguration.initializeAdditionalPackagesToSkip(agent);
            EntryPointDetectionConfiguration.initializeApplicationPackages(agent);
            EntryPointDetectionConfiguration.initializeInterestingMethodNames(agent);
            EntryPointDetectionConfiguration.initializeIncludeBottomPercentOfStackTrace(agent);
            EntryPointDetectionConfiguration.initializeSkipTopPercentOfStackTrace(agent);
            EntryPointDetectionConfiguration.initializeMaxRules(agent);
            EntryPointDetectionConfiguration.initializeLogStackTraceEnabled(agent);
            EntryPointDetectionConfiguration.initializeStackTraceRecordingsLimitPerInterval(agent);
            EntryPointDetectionConfiguration.initializeNumberOfIntervalsToElapse(agent);
            EntryPointDetectionConfiguration.initializeCandidateFinderInterval(agent);
            initCompleted = true;
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    private static void initializeEntryPointDetectionEnabled(IAgent agent) {
        ConfigurationManager configManager = agent.IAgent_getConfigurationManager();
        BooleanConfigurationProperty entryPointDetectionEnabledProperty = new BooleanConfigurationProperty("introscope.agent.deep.entrypoint.enabled", true, "Enables/Disables automatic entry point detection feature", true, false, agent.IAgent_getModuleFeedback(), iiModule, agent.IAgent_getStringLocalizer()){

            public void set(Object newValue) {
                boolean status = (Boolean)newValue;
                EntryPointDetectionConfiguration.setEntryPointDetectionEnabledStatus(status);
            }
        };
        configManager.add((ConfigurationProperty)entryPointDetectionEnabledProperty, true);
    }

    private static void initializeMethodNamesToSkip(IAgent agent) {
        ConfigurationManager configManager = agent.IAgent_getConfigurationManager();
        StringSetConfigurationProperty skipMethodsProperty = new StringSetConfigurationProperty("introscope.agent.deep.entrypoint.rules.skip.methodNames", EntryPointDetectionConfiguration.getDefaultMethodNamesToSkip(), "List of method names which should be skipped as entrypoint candidates during automatic entry point detection", "", false, false, agent.IAgent_getModuleFeedback(), iiModule, agent.IAgent_getStringLocalizer()){

            public void set(Object newValue) {
                EntryPointDetectionConfiguration.setMethodNamesToSkip((Set)newValue);
            }
        };
        configManager.add((ConfigurationProperty)skipMethodsProperty, true);
    }

    private static void initializeEssentialPackagesToSkip(IAgent agent) {
        ConfigurationManager configManager = agent.IAgent_getConfigurationManager();
        StringSetConfigurationProperty skipPackagesProperty = new StringSetConfigurationProperty("introscope.agent.deep.entrypoint.rules.skip.pkgs.essential", EntryPointDetectionConfiguration.getDefaultEssentialPackagesToSkip(), "List of packages. A stack trace element belonging to any of these packages is skipped for automatic entry point detection", "", false, false, agent.IAgent_getModuleFeedback(), iiModule, agent.IAgent_getStringLocalizer()){

            public void set(Object newValue) {
                EntryPointDetectionConfiguration.setEssentialPackgesToSkip((Set)newValue);
            }
        };
        configManager.add((ConfigurationProperty)skipPackagesProperty, true);
    }

    private static void initializeAdditionalPackagesToSkip(IAgent agent) {
        ConfigurationManager configManager = agent.IAgent_getConfigurationManager();
        StringSetConfigurationProperty skipPackagesProperty = new StringSetConfigurationProperty("introscope.agent.deep.entrypoint.skip.pkgs", EntryPointDetectionConfiguration.getDefaultAdditionalPackagesToSkip(), "List of packages. A stack trace element belonging to any of these packages is skipped for automatic entry point detection", "", true, false, agent.IAgent_getModuleFeedback(), iiModule, agent.IAgent_getStringLocalizer()){

            public void set(Object newValue) {
                EntryPointDetectionConfiguration.setAdditionalPackagesToSkip((Set)newValue);
            }
        };
        configManager.add((ConfigurationProperty)skipPackagesProperty, true);
    }

    private static void initializeApplicationPackages(IAgent agent) {
        ConfigurationManager configManager = agent.IAgent_getConfigurationManager();
        StringSetConfigurationProperty skipPackagesProperty = new StringSetConfigurationProperty("introscope.agent.deep.entrypoint.rules.app.pkgs", EntryPointDetectionConfiguration.getDefaultApplicationPackages(), "List of application packages. A stack trace element belonging to any of these packages is considered for automatic entry point detection", "", true, false, agent.IAgent_getModuleFeedback(), iiModule, agent.IAgent_getStringLocalizer()){

            public void set(Object newValue) {
                EntryPointDetectionConfiguration.setApplicationPackages((Set)newValue);
            }
        };
        configManager.add((ConfigurationProperty)skipPackagesProperty, true);
    }

    private static void initializeInterestingMethodNames(IAgent agent) {
        ConfigurationManager configManager = agent.IAgent_getConfigurationManager();
        StringSetConfigurationProperty intMethodNamesProperty = new StringSetConfigurationProperty("introscope.agent.deep.entrypoint.rules.interesting.methodNames", EntryPointDetectionConfiguration.getDefaultInterestingMethodNames(), "List of interesting method names. A stack trace element with matching name is considered for automatic entry point detection", "", false, false, agent.IAgent_getModuleFeedback(), iiModule, agent.IAgent_getStringLocalizer()){

            public void set(Object newValue) {
                EntryPointDetectionConfiguration.setInterestingMethodNames((Set)newValue);
            }
        };
        configManager.add((ConfigurationProperty)intMethodNamesProperty, true);
    }

    private static void initializeIncludeBottomPercentOfStackTrace(IAgent agent) {
        ConfigurationManager configManager = agent.IAgent_getConfigurationManager();
        FloatConfigurationProperty property = new FloatConfigurationProperty("introscope.agent.deep.entrypoint.rules.include.bottomPercent", Float.valueOf(50.0f), "Entry Point Detection Feature - for selecting elements which are in bottom n% of stack trace", "", false, false, agent.IAgent_getModuleFeedback(), iiModule, agent.IAgent_getStringLocalizer()){

            public void set(Object newValue) {
                EntryPointDetectionConfiguration.setIncludeBottomPercentOfStackTrace(((Float)newValue).floatValue());
            }
        };
        configManager.add((ConfigurationProperty)property, true);
    }

    private static void initializeSkipTopPercentOfStackTrace(IAgent agent) {
        ConfigurationManager configManager = agent.IAgent_getConfigurationManager();
        FloatConfigurationProperty property = new FloatConfigurationProperty("introscope.agent.deep.entrypoint.rules.skip.topPercent", Float.valueOf(50.0f), "Entry Point Detection Feature - for skipping elements which are in top n% of trace", "", false, false, agent.IAgent_getModuleFeedback(), iiModule, agent.IAgent_getStringLocalizer()){

            public void set(Object newValue) {
                EntryPointDetectionConfiguration.setSkipTopPercentOfStackTrace(((Float)newValue).floatValue());
            }
        };
        configManager.add((ConfigurationProperty)property, true);
    }

    private static void initializeMaxRules(IAgent agent) {
        ConfigurationManager configManager = agent.IAgent_getConfigurationManager();
        IntegerConfigurationProperty maxRulesProperty = new IntegerConfigurationProperty("introscope.agent.deep.entrypoint.max.rules", 50, "Maximum number of rules which can be registered with entry point rule engine", "", false, false, agent.IAgent_getModuleFeedback(), iiModule, agent.IAgent_getStringLocalizer()){

            public void set(Object newValue) {
                EntryPointDetectionConfiguration.setMaxRules((Integer)newValue);
            }
        };
        configManager.add((ConfigurationProperty)maxRulesProperty, true);
    }

    private static void initializeLogStackTraceEnabled(IAgent agent) {
        ConfigurationManager configManager = agent.IAgent_getConfigurationManager();
        BooleanConfigurationProperty logStackTraceEnabledProperty = new BooleanConfigurationProperty("introscope.agent.deep.entrypoint.log.stackTrace.enabled", true, "Enables/Disables logging of stack trace for entry point detection feature", true, false, agent.IAgent_getModuleFeedback(), iiModule, agent.IAgent_getStringLocalizer()){

            public void set(Object newValue) {
                EntryPointDetectionConfiguration.setShouldLogStackTraces((Boolean)newValue);
            }
        };
        configManager.add((ConfigurationProperty)logStackTraceEnabledProperty, true);
    }

    private static void initializeStackTraceRecordingsLimitPerInterval(IAgent agent) {
        ConfigurationManager configManager = agent.IAgent_getConfigurationManager();
        IntegerConfigurationProperty property = new IntegerConfigurationProperty("introscope.agent.deep.entrypoint.stackTraces.record.limitPerInterval", 5, "Entry Point Detection Feature - Limits the number of stack traces to record in an interval", "", false, false, agent.IAgent_getModuleFeedback(), iiModule, agent.IAgent_getStringLocalizer()){

            public void set(Object newValue) {
                int value = (Integer)newValue;
                super.set((Object)value);
                EntryPointDetectionConfiguration.setStackTracesLimitPerInterval(value);
            }
        };
        configManager.add((ConfigurationProperty)property, true);
    }

    private static void initializeNumberOfIntervalsToElapse(IAgent agent) {
        ConfigurationManager configManager = agent.IAgent_getConfigurationManager();
        IntegerConfigurationProperty property = new IntegerConfigurationProperty("introscope.agent.deep.entrypoint.stackTraces.record.waitInterval", 4, "Entry Point Detection Feature - Number of time intervals to elapse, before approving next recording request from same thread", "", false, false, agent.IAgent_getModuleFeedback(), iiModule, agent.IAgent_getStringLocalizer()){

            public void set(Object newValue) {
                EntryPointDetectionConfiguration.setNumberIntervalsToElapse((Integer)newValue);
            }
        };
        configManager.add((ConfigurationProperty)property, true);
    }

    private static void initializeCandidateFinderInterval(IAgent agent) {
        ConfigurationManager configManager = agent.IAgent_getConfigurationManager();
        IntegerConfigurationProperty property = new IntegerConfigurationProperty("introscope.agent.deep.entrypoint.candidate.finder.intervalSeconds", 15, "Entry Point Detection Feature - frequency at which candidate finder will be executed", "", false, false, agent.IAgent_getModuleFeedback(), iiModule, agent.IAgent_getStringLocalizer()){

            public void set(Object newValue) {
                EntryPointDetectionConfiguration.setCandidateFinderInterval((Integer)newValue);
            }
        };
        configManager.add((ConfigurationProperty)property, true);
    }

    private static void initializeDeepTracingStatus() {
        EntryPointDetectionConfiguration.setDeepTracingStatus(DeepTraceConfigurations.getDeepTracingStatus());
        DeepTraceConfigurations.registerDeepTracingPropertyListener((DeepTraceConfigurations.IDeepConfigurationListener)new DeepTraceConfigurations.IDeepConfigurationListener(){

            public void onChange(Object newValue) {
                EntryPointDetectionConfiguration.setDeepTracingStatus((Boolean)newValue);
            }
        });
    }

    public static boolean isEntryPointDetectionEnabled() {
        return isEntryPointDetectionEnabled;
    }

    public static void setEntryPointDetectionEnabledStatus(boolean status) {
        isEntryPointDetectionEnabled = status;
        StackTraceRecordingController.setEntryPointDetectionStatus(status);
    }

    public static Set<String> getMethodsToSkip() {
        return methodNamesToSkip;
    }

    public static Set<String> getDefaultMethodNamesToSkip() {
        return StringUtils.parseAndTrimListToSet((String)"<init>,run", (String)",");
    }

    public static void setMethodNamesToSkip(Set<String> methods) {
        methodNamesToSkip = methods;
    }

    public static Set<String> getEssentialPackagesToSkip() {
        return essentialPackagesToSkip;
    }

    public static Set<String> getDefaultEssentialPackagesToSkip() {
        return StringUtils.parseAndTrimListToSet((String)"com.ca,com.wily,java,javax,sun,com.sun,oracle.jdbc", (String)",");
    }

    public static void setEssentialPackgesToSkip(Set<String> packages) {
        essentialPackagesToSkip = packages;
    }

    public static void setEssentialPackgesToSkip(String commaSeparatedPackages) {
        essentialPackagesToSkip = new HashSet<String>(Arrays.asList(commaSeparatedPackages.split(",")));
    }

    public static Set<String> getAdditionalPackagesToSkip() {
        return additionalPackagesToSkip;
    }

    public static Set<String> getDefaultAdditionalPackagesToSkip() {
        return StringUtils.parseAndTrimListToSet((String)"", (String)",");
    }

    public static void setAdditionalPackagesToSkip(Set<String> packages) {
        additionalPackagesToSkip = packages;
    }

    public static Set<String> getApplicationPackages() {
        return appPackages;
    }

    public static Set<String> getDefaultApplicationPackages() {
        return StringUtils.parseAndTrimListToSet((String)"", (String)",");
    }

    public static void setApplicationPackages(Set<String> appPackages) {
        EntryPointDetectionConfiguration.appPackages = appPackages;
    }

    public static Set<String> getInterestingMethodNames() {
        return interestingMethodNames;
    }

    public static Set<String> getDefaultInterestingMethodNames() {
        Set methodNames = StringUtils.parseAndTrimListToSet((String)"onReceive,onMessage", (String)",");
        methodNames.addAll(StringUtils.parseAndTrimListToSet((String)"", (String)","));
        return methodNames;
    }

    public static void setInterestingMethodNames(Set<String> methods) {
        Set methodNames = StringUtils.parseAndTrimListToSet((String)"onReceive,onMessage", (String)",");
        methodNames.addAll(methods);
        interestingMethodNames = methodNames;
    }

    public static float getIncludeBottomPercentOfStackTrace() {
        return includeBottomPercent;
    }

    public static void setIncludeBottomPercentOfStackTrace(float percent) {
        includeBottomPercent = percent;
    }

    public static float getSkipTopPercentOfStackTrace() {
        return skipTopPercent;
    }

    public static void setSkipTopPercentOfStackTrace(float percent) {
        skipTopPercent = percent;
    }

    public static int getMaxRules() {
        return maxRules;
    }

    public static void setMaxRules(int maxRules) {
        EntryPointDetectionConfiguration.maxRules = maxRules;
    }

    public static boolean shouldLogStackTraces() {
        return shouldLogStackTraces;
    }

    public static void setShouldLogStackTraces(boolean shouldLogStackTraces) {
        EntryPointDetectionConfiguration.shouldLogStackTraces = shouldLogStackTraces;
    }

    public static int getStackTracesLimitPerInterval() {
        return stackTraceRecordingsLimitPerInterval;
    }

    public static void setStackTracesLimitPerInterval(int stackTraceRecordingsLimitPerInterval) {
        EntryPointDetectionConfiguration.stackTraceRecordingsLimitPerInterval = stackTraceRecordingsLimitPerInterval;
        StackTraceRecordingController.setStackTracesLimitPerInterval(stackTraceRecordingsLimitPerInterval);
    }

    public static int getNumberIntervalsToElapse() {
        return numberOfIntervalsToElapse;
    }

    public static void setNumberIntervalsToElapse(int numberIntervalsToElapse) {
        numberOfIntervalsToElapse = numberIntervalsToElapse;
        ThreadSelector.getInstance().setNumberIntervalsToElapse(numberIntervalsToElapse);
    }

    public static int getCandidateFinderInterval() {
        return candidateFinderInterval;
    }

    public static void setCandidateFinderInterval(int interval) {
        candidateFinderInterval = interval;
    }

    public static boolean getDeepTracingStatus() {
        return deepTracingEnabled;
    }

    public static void setDeepTracingStatus(boolean status) {
        deepTracingEnabled = status;
        StackTraceRecordingController.setDeepTracingStatus(status);
    }

    public static class FloatConfigurationProperty
    extends ConfigurationProperty {
        public FloatConfigurationProperty(String name, Float defaultValue, IModuleFeedbackChannel feedback, Module module, IStringLocalizer localizer) {
            super(name, (Object)defaultValue, feedback, module, localizer);
        }

        public FloatConfigurationProperty(String name, Float defaultValue, String descriptionKey, IModuleFeedbackChannel feedback, Module module, IStringLocalizer localizer) {
            super(name, (Object)defaultValue, descriptionKey, feedback, module, localizer);
        }

        public FloatConfigurationProperty(String name, Float defaultValue, String descriptionKey, String unitsKey, boolean isHot, boolean isNullValid, IModuleFeedbackChannel feedback, Module module, IStringLocalizer localizer) {
            super(name, (Object)defaultValue, descriptionKey, unitsKey, isHot, isNullValid, feedback, module, localizer);
        }

        public Object convert(String s) {
            return new Float(s.trim());
        }
    }
}

