/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.intelligent.entrypoint.stacktrace;

import com.wily.introscope.agent.blame.VirtualStack;
import com.wily.introscope.agent.intelligent.detection.RecordingData;
import com.wily.introscope.agent.intelligent.entrypoint.stacktrace.ThreadSelector;
import com.wily.introscope.agent.trace.intelligent.HighPerformanceIntelligenceStackElement;
import java.util.concurrent.atomic.AtomicInteger;

public class StackTraceRecordingController {
    private static volatile int maxRecordingsPerInterval = 5;
    private static final int ENTRYPOINT_BIT_MASK = 1;
    private static final int DEEPTRACING_BIT_MASK = 2;
    private static final int CONFIG_OK = 3;
    private static int flags = 3;
    private static final AtomicInteger numberRecordings = new AtomicInteger(0);
    private static final ThreadSelector threadSelector = ThreadSelector.getInstance();

    public static boolean shouldRecordStackTrace(RecordingData threadLocalRecData) {
        if (3 != flags) {
            return false;
        }
        HighPerformanceIntelligenceStackElement.HighPerformanceIntelligenceStackElementVirtualStack threadLocalDeepStack = HighPerformanceIntelligenceStackElement.HighPerformanceIntelligenceStackElementVirtualStack.getThreadLocal();
        if (threadLocalDeepStack.isFrontendCandidateMarked() || StackTraceRecordingController.hasFrontEndMarker(threadLocalDeepStack) || StackTraceRecordingController.hasEntryPointInStack()) {
            return false;
        }
        if (numberRecordings.get() >= maxRecordingsPerInterval) {
            return false;
        }
        if (!threadSelector.shouldRecordTrace(threadLocalRecData)) {
            return false;
        }
        return numberRecordings.incrementAndGet() <= maxRecordingsPerInterval;
    }

    private static boolean hasFrontEndMarker(HighPerformanceIntelligenceStackElement.HighPerformanceIntelligenceStackElementVirtualStack threadLocalDeepStack) {
        return threadLocalDeepStack.hasFrontend();
    }

    private static boolean hasEntryPointInStack() {
        VirtualStack.TransactionCache cache = VirtualStack.getTransactionCache();
        return cache.getEntryPoint() != null;
    }

    private static boolean isThreadTraced(HighPerformanceIntelligenceStackElement.HighPerformanceIntelligenceStackElementVirtualStack threadLocalDeepStack) {
        return threadLocalDeepStack.isMyTracingOn();
    }

    public static void notifyRecordingListeners(RecordingData threadLocalRecData) {
        threadSelector.notifyOnRecording(threadLocalRecData);
    }

    public static int getRecordingsCount() {
        return numberRecordings.get();
    }

    public static void resetRecordingsCounter() {
        numberRecordings.set(0);
    }

    public static void setStackTracesLimitPerInterval(int limit) {
        maxRecordingsPerInterval = limit;
    }

    public static void setEntryPointDetectionStatus(boolean status) {
        if (status) {
            StackTraceRecordingController.setConfigFlag(1);
        } else {
            StackTraceRecordingController.clearConfigFlag(1);
        }
    }

    public static void setDeepTracingStatus(boolean status) {
        if (status) {
            StackTraceRecordingController.setConfigFlag(2);
        } else {
            StackTraceRecordingController.clearConfigFlag(2);
        }
    }

    private static void setConfigFlag(int mask) {
        flags |= mask;
    }

    private static void clearConfigFlag(int mask) {
        flags &= ~mask;
    }
}

