/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.intelligent.exitpoint;

import com.wily.introscope.agent.blame.VirtualStack;
import com.wily.introscope.agent.intelligent.detection.RecordingData;
import com.wily.introscope.agent.intelligent.exitpoint.stacktrace.WrappedStackTrace;
import com.wily.introscope.agent.trace.IStackElement;
import com.wily.introscope.agent.trace.InvocationData;
import java.util.Deque;
import java.util.concurrent.ConcurrentLinkedDeque;

public class ExitPointRecordingData
extends RecordingData {
    private final Deque<WrappedStackTrace> deque = new ConcurrentLinkedDeque<WrappedStackTrace>();

    public WrappedStackTrace[] harvest() {
        if (!this.deque.isEmpty()) {
            WrappedStackTrace[] array = this.deque.toArray(new WrappedStackTrace[this.deque.size()]);
            this.deque.clear();
            return array;
        }
        return null;
    }

    public int getStorageSize() {
        return this.deque.size();
    }

    @Override
    public boolean acceptTrace(StackTraceElement[] trace) {
        IStackElement element = VirtualStack.peek();
        if (element instanceof InvocationData) {
            return this.deque.offer(new WrappedStackTrace(((InvocationData)element).getInvocationId(), trace));
        }
        return false;
    }

    @Override
    public StackTraceElement[] getTrace() {
        WrappedStackTrace wrappedTrace = this.deque.peekLast();
        if (wrappedTrace != null) {
            return wrappedTrace.getTrace();
        }
        return null;
    }
}

