/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.autoprobe.dynamic;

import com.wily.diagnos.cmp.directives.DGCompilerSettings;
import com.wily.diagnos.cmp.methodmatcher.IMethodMatcher;
import com.wily.introscope.autoprobe.dynamic.FlagMatcher;
import com.wily.introscope.autoprobe.dynamic.RuntimeMethod;
import com.wily.introscope.autoprobe.dynamic.RuntimeModeledClass;
import com.wily.introscope.autoprobe.dynamic.Util;
import com.wily.util.classfile.IModeledClass;
import com.wily.util.classfile.IModeledMethod;
import com.wily.util.classfile.InvalidClassNameException;
import com.wily.util.feedback.IModuleFeedbackChannel;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class SettingsDiff {
    private Map previousFlagMatcherMap;
    private Map currentFlagMatcherMap;
    private Set fChangedClassLevelFlags = new HashSet();
    private Set fToggledFlags = new HashSet();
    private Map fChangedMethodLevelSettings = new HashMap();
    private IModuleFeedbackChannel fFeedback;

    public SettingsDiff(DGCompilerSettings previousSettings, DGCompilerSettings currentSettings, IModuleFeedbackChannel feedback) {
        this.fFeedback = feedback;
        this.previousFlagMatcherMap = Util.getFlagMatcherMap(previousSettings);
        this.currentFlagMatcherMap = Util.getFlagMatcherMap(currentSettings);
        this.markChangedClassLevelSettings();
        this.markChangedMethodLevelSettings();
    }

    private void markChangedClassLevelSettings() {
        Set oldFlags = Util.getClonedKeySet(this.previousFlagMatcherMap);
        Set newFlags = Util.getClonedKeySet(this.currentFlagMatcherMap);
        newFlags.removeAll(this.previousFlagMatcherMap.keySet());
        oldFlags.removeAll(this.currentFlagMatcherMap.keySet());
        this.fChangedClassLevelFlags.addAll(newFlags);
        this.fChangedClassLevelFlags.addAll(oldFlags);
        Set commonFlags = Util.getClonedKeySet(this.previousFlagMatcherMap);
        commonFlags.retainAll(this.currentFlagMatcherMap.keySet());
        for (String flag : commonFlags) {
            FlagMatcher currentMatcher;
            FlagMatcher prevMatcher = (FlagMatcher)this.previousFlagMatcherMap.get(flag);
            if (prevMatcher.equals(currentMatcher = (FlagMatcher)this.currentFlagMatcherMap.get(flag))) continue;
            if (prevMatcher.isEnabled() != currentMatcher.isEnabled()) {
                this.fToggledFlags.add(flag);
            }
            this.fChangedClassLevelFlags.add(flag);
        }
        this.fFeedback.debug("Changed Class level flags " + this.fChangedClassLevelFlags);
    }

    private void markChangedMethodLevelSettings() {
        for (String flag : this.previousFlagMatcherMap.keySet()) {
            Set changedMethodMatcherSet;
            FlagMatcher prevMatcher = (FlagMatcher)this.previousFlagMatcherMap.get(flag);
            FlagMatcher currentMatcher = (FlagMatcher)this.currentFlagMatcherMap.get(flag);
            if (currentMatcher == null || (changedMethodMatcherSet = Util.generateChangedMethodMatcherSet(prevMatcher, currentMatcher, flag.equals("NULLTracerGroup"))).isEmpty()) continue;
            this.fChangedMethodLevelSettings.put(flag, changedMethodMatcherSet);
        }
        this.fFeedback.debug("Changed Method level flags " + this.fChangedMethodLevelSettings);
    }

    public boolean haveMethodLevelSettingsChangedForFlag(String flag) {
        return this.fChangedMethodLevelSettings.containsKey(flag);
    }

    private Set getChangedMethodTracers(String flag) {
        return (Set)this.fChangedMethodLevelSettings.get(flag);
    }

    public boolean doesClassNeedRedefine(Class cls) {
        try {
            if (this.haveInstrumentableSettingsChanged(cls)) {
                return true;
            }
        }
        catch (Exception e) {
            this.fFeedback.debug("Invalid Class Name/Method Name for class[" + cls.getName() + "],cannot process", (Throwable)e);
        }
        catch (Throwable t) {
            this.fFeedback.debug("Invalid Class Name/Method Name for class[" + cls.getName() + "],cannot process", t);
        }
        return false;
    }

    private boolean haveInstrumentableSettingsChanged(Class cls) {
        RuntimeModeledClass modeledClass = null;
        try {
            modeledClass = new RuntimeModeledClass(cls, true, this.fFeedback);
        }
        catch (InvalidClassNameException e) {
            this.fFeedback.debug("Invalid Class Name found, cannot process[" + cls.getName() + "]", (Throwable)e);
            return false;
        }
        for (String changedFlag : this.fChangedClassLevelFlags) {
            FlagMatcher prevFlagMatcher = (FlagMatcher)this.previousFlagMatcherMap.get(changedFlag);
            FlagMatcher currentFlagMatcher = (FlagMatcher)this.currentFlagMatcherMap.get(changedFlag);
            int matchState = Util.getMatchForFlag(changedFlag, prevFlagMatcher, currentFlagMatcher, modeledClass);
            if (this.fFeedback.isDebugEnabled()) {
                this.fFeedback.debug("match state for class ->" + cls.getName() + "-" + matchState);
            }
            if (matchState == 2 || matchState == 1) {
                this.fFeedback.debug("Class[" + cls.getName() + "] will be re-defined because it was added/removed to flag [" + changedFlag + "].");
                return true;
            }
            if (matchState != 3 || !this.fToggledFlags.contains(changedFlag)) continue;
            this.fFeedback.debug("Class[" + cls.getName() + "] will be re-defined because the flag [" + changedFlag + "]  was toggled.");
            return true;
        }
        for (String changedMethodFlag : this.fChangedMethodLevelSettings.keySet()) {
            FlagMatcher currentFlagMatcher;
            FlagMatcher prevFlagMatcher;
            int matchState;
            if (this.fChangedClassLevelFlags.contains(changedMethodFlag) || (matchState = Util.getMatchForFlag(changedMethodFlag, prevFlagMatcher = (FlagMatcher)this.previousFlagMatcherMap.get(changedMethodFlag), currentFlagMatcher = (FlagMatcher)this.currentFlagMatcherMap.get(changedMethodFlag), modeledClass)) != 3 || !this.haveMethodLevelSettingsChangedForClass(cls, modeledClass, changedMethodFlag)) continue;
            return true;
        }
        return false;
    }

    private boolean haveMethodLevelSettingsChangedForClass(Class cls, IModeledClass modeledClass, String flag) {
        Set changedMethodMatchers = this.getChangedMethodTracers(flag);
        for (IMethodMatcher methodMatcher : changedMethodMatchers) {
            Method[] methods = cls.getDeclaredMethods();
            int i = 0;
            while (i < methods.length) {
                RuntimeMethod modeledMethod = null;
                try {
                    modeledMethod = new RuntimeMethod(methods[i], modeledClass, true, this.fFeedback);
                }
                catch (Exception e) {
                    this.fFeedback.debug("Invalid Method name found [" + methods[i].getName() + "],  cannot process for class -" + cls.getName(), (Throwable)e);
                    return false;
                }
                if (methodMatcher.IMethodMatcher_matches((IModeledMethod)modeledMethod)) {
                    this.fFeedback.debug("Class[" + cls + "] will be re-defined because method level tracer changes for method[" + methods[i].getName() + "] for flag[" + flag + "] were noticed.");
                    return true;
                }
                ++i;
            }
        }
        return false;
    }
}

