/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.platform.linux;

import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.InformationNotAvailableException;
import com.wily.introscope.agent.platform.ADefaultPlatformStatistics;
import com.wily.introscope.agent.platform.PlatformLibraryException;
import com.wily.introscope.agent.platform.PlatformLibraryNotSupportedException;
import com.wily.introscope.agent.platform.PlatformStatUnavailableException;
import com.wily.introscope.agent.platform.linux.LinuxPlatformStatisticsBackEnd;
import com.wily.introscope.agent.platform.util.AggregateCPUUsageCalculator;
import com.wily.introscope.agent.platform.util.ProcessCPUUsageCalculator;
import com.wily.util.feedback.IModuleFeedbackChannel;
import com.wily.util.text.FormattedLocalizableMessage;
import com.wily.wilyassert.Assertion;

public final class LinuxPlatformStatistics
extends ADefaultPlatformStatistics {
    private static final String kLinuxThreadsModelString = "RedHat2.1";
    private static final String kRedHat30ModelString = "RedHat3.0";
    private static final String[] kSupportedPlatforms = new String[]{"Linux", "RedHat3.0", "LinuxIntelAmd32"};
    private AggregateCPUUsageCalculator[] fAggregateCPUUsageCalculator;
    private ProcessCPUUsageCalculator fProcessCPUUsageCalculator;
    private LinuxPlatformStatisticsBackEnd fBackEnd;
    private final boolean fThreadCPUStatsEnabled;
    private IModuleFeedbackChannel fFeedback;
    static final int kLinuxThreadsModelCode = 0;
    static final int kRedHat30ModelCode = 1;
    static final int kDefaultProcessModelCode = 0;

    public LinuxPlatformStatistics(String name, IAgent agent) throws PlatformLibraryException {
        super(name, agent, "libIntroscopeLinuxIntelAmd32Stats.so");
        this.fBackEnd = new LinuxPlatformStatisticsBackEnd(this.IPlatformStatistics_getName(), agent.IAgent_getModuleFeedback(), agent.IAgent_getStringLocalizer());
        this.fThreadCPUStatsEnabled = this.fBackEnd.isThreadCpuTimeEnabled();
        this.fFeedback = agent.IAgent_getModuleFeedback();
        this.initialize();
    }

    private void safeLogDebug(String message) {
        try {
            this.fFeedback.debug(message);
        }
        catch (ThreadDeath td) {
            throw td;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    protected void checkSupportedPlatform(String platformName, String platformVersion) throws PlatformLibraryException {
        if (platformVersion != null && platformName.startsWith("Linux")) {
            String jvmarch = System.getProperty("sun.arch.data.model");
            String osArch = System.getProperty("os.arch");
            if (jvmarch == null) {
                jvmarch = System.getProperty("com.ibm.vm.bitmode");
            }
            if (jvmarch == null || jvmarch != null && "".equals(jvmarch.trim())) {
                throw new PlatformLibraryNotSupportedException(new FormattedLocalizableMessage("Agent_Platform_Monitor_Creation_Failed_Message", this.IPlatformStatistics_getName(), "System Property sun.arch.data.model / com.ibm.vm.bitmode is not set or empty"));
            }
            if (jvmarch.startsWith("32")) {
                platformName = "LinuxIntelAmd32";
            } else if (jvmarch.startsWith("31")) {
                platformName = "LinuxZSeries31";
            } else if (jvmarch.startsWith("64") && (osArch.startsWith("amd") || osArch.startsWith("x86"))) {
                platformName = "LinuxIntelAmd64";
            }
        }
        super.checkSupportedPlatform(platformName, platformVersion);
        Assertion.wilyAssert(platformName != null, "No platform name property found, Linux platform monitor will not run");
    }

    protected String[] getSupportedPlatforms() {
        return kSupportedPlatforms;
    }

    private void initialize() throws PlatformLibraryException {
        this.fBackEnd.initialize();
        this.registerDefaultStats();
    }

    protected void terminate() throws PlatformLibraryException {
        this.getBackEnd().terminate();
    }

    private LinuxPlatformStatisticsBackEnd getBackEnd() {
        return this.fBackEnd;
    }

    private void registerDefaultStats() throws PlatformLibraryException {
        int cpuCount = 0;
        cpuCount = this.getBackEnd().getInstalledCPUCount();
        Assertion.wilyAssert(cpuCount >= 0);
        this.fAggregateCPUUsageCalculator = new AggregateCPUUsageCalculator[cpuCount];
        for (int iter = 0; iter < cpuCount; ++iter) {
            this.fAggregateCPUUsageCalculator[iter] = new AggregateCPUUsageCalculator();
            long[] cpuStates = AggregateCPUUsageCalculator.kInitializedStatsArray;
            try {
                cpuStates = this.getBackEnd().getAggregateCPUUsage(iter);
            }
            catch (PlatformStatUnavailableException bomb) {
                // empty catch block
            }
            this.fAggregateCPUUsageCalculator[iter].setSnapshot(cpuStates);
        }
        this.fProcessCPUUsageCalculator = new ProcessCPUUsageCalculator();
        try {
            this.fProcessCPUUsageCalculator.setSnapshot(this.getBackEnd().getTotalClockTicks(), this.getBackEnd().getProcessCPUUsage());
        }
        catch (PlatformStatUnavailableException bomb) {
            this.fProcessCPUUsageCalculator.setSnapshot(0L, 0L);
        }
    }

    public void IPlatformStatistics_initializePlatformSpecificStatistics() throws PlatformLibraryException {
    }

    public long IPlatformStatistics_getProcessID() throws PlatformLibraryException, PlatformStatUnavailableException {
        long pid = this.getBackEnd().getProcessID();
        Assertion.wilyAssert(pid >= 0L);
        return pid;
    }

    public int IPlatformStatistics_getCPUCount() throws PlatformLibraryException, PlatformStatUnavailableException {
        int count = this.getBackEnd().getInstalledCPUCount();
        Assertion.wilyAssert(count > 0);
        return count;
    }

    public double IPlatformStatistics_getCPUUtilizationForCurrentProcess() throws PlatformLibraryException, PlatformStatUnavailableException {
        long proc = this.getBackEnd().getProcessCPUUsage();
        long sys = this.getBackEnd().getTotalClockTicks();
        double usage = this.fProcessCPUUsageCalculator.getTotalCPUUsageByThisProcessAllowSkew(sys, proc);
        Assertion.wilyAssert(usage >= 0.0 && usage <= 100.0);
        return usage;
    }

    public int IPlatformStatistics_mapLinearZeroBasedCPUIndexToOSName(int linearZeroBasedIndex) {
        try {
            return this.getBackEnd().mapLinearZeroBasedCPUIndexToOSName(linearZeroBasedIndex);
        }
        catch (PlatformLibraryException bomb) {
            this.getModuleFeedback().error(this.getStringLocalizer().IStringLocalizer_getFormattedLocalizedString("Agent_Platform_Monitor_CPU_Name_Mapping_Failed_Message", this.IPlatformStatistics_getName(), Integer.toString(linearZeroBasedIndex)));
            return linearZeroBasedIndex;
        }
    }

    public void IPlatformStatistics_resetAggregateCPUUtilizationForProcessor(int linearZeroBasedIndex) throws PlatformLibraryException, PlatformStatUnavailableException {
        Assertion.wilyAssert(linearZeroBasedIndex >= 0 && linearZeroBasedIndex < this.fAggregateCPUUsageCalculator.length);
        if (linearZeroBasedIndex < 0 || linearZeroBasedIndex >= this.fAggregateCPUUsageCalculator.length) {
            throw new PlatformStatUnavailableException();
        }
        long[] cpuStates = this.getBackEnd().getAggregateCPUUsage(linearZeroBasedIndex);
        this.fAggregateCPUUsageCalculator[linearZeroBasedIndex].setSnapshot(cpuStates);
    }

    public double IPlatformStatistics_getAggregateCPUUtilizationForProcessor(int linearZeroBasedIndex) throws PlatformLibraryException, PlatformStatUnavailableException {
        Assertion.wilyAssert(linearZeroBasedIndex >= 0 && linearZeroBasedIndex < this.fAggregateCPUUsageCalculator.length);
        if (linearZeroBasedIndex < 0 || linearZeroBasedIndex >= this.fAggregateCPUUsageCalculator.length) {
            throw new PlatformStatUnavailableException();
        }
        long[] cpuStatesLong = this.getBackEnd().getAggregateCPUUsage(linearZeroBasedIndex);
        return this.fAggregateCPUUsageCalculator[linearZeroBasedIndex].getAggregateCPUUsageAllowSkew(cpuStatesLong);
    }

    public void IPlatformStatistics_resetCPUUtilizationForCurrentProcess() throws PlatformLibraryException, PlatformStatUnavailableException {
    }

    public boolean ICpuUsageReporter_isCpuUsageSupported() {
        return this.fThreadCPUStatsEnabled;
    }

    public long ICpuUsageReporter_getCpuUsage() throws InformationNotAvailableException {
        if (this.fThreadCPUStatsEnabled) {
            return this.fBackEnd.getThreadCpuTime();
        }
        throw new InformationNotAvailableException();
    }
}

