/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.extension.deployer;

import com.wily.introscope.agent.extension.deployer.DeploymentWatcher;
import com.wily.util.feedback.IModuleFeedbackChannel;
import com.wily.util.feedback.Module;
import com.wily.util.io.ExtendedFile;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.MessageDigest;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveInputStream;
import org.apache.commons.compress.archivers.tar.TarArchiveOutputStream;
import org.apache.commons.compress.compressors.gzip.GzipCompressorInputStream;
import org.apache.commons.compress.compressors.gzip.GzipCompressorOutputStream;
import org.apache.commons.compress.utils.IOUtils;

public class CompressionUtils {
    private static Module kModule = null;
    private static IModuleFeedbackChannel fFeedback = null;
    private static Map<String, ChecksumCacheEntry> fChecksumCache = new CheckSumCache<String, ChecksumCacheEntry>();

    public static void setFeedback(Module module, IModuleFeedbackChannel feedback) {
        kModule = module;
        fFeedback = feedback;
    }

    private static void tarDirectory(File root, File directory, TarArchiveOutputStream out) throws IOException {
        File[] files = directory.listFiles();
        int i = 0;
        while (i < files.length) {
            File file = files[i];
            if (file.isDirectory()) {
                CompressionUtils.tarDirectory(root, file, out);
            } else {
                String name = file.getAbsolutePath().replace(String.valueOf(root.getAbsolutePath()) + File.separator, "");
                if (!name.equals(".deployment")) {
                    TarArchiveEntry entry = new TarArchiveEntry(file, name);
                    out.putArchiveEntry(entry);
                    FileInputStream in = new FileInputStream(file);
                    IOUtils.copy(in, out);
                    ((InputStream)in).close();
                    out.closeArchiveEntry();
                }
            }
            ++i;
        }
    }

    public static void tar(ExtendedFile tarFile, ExtendedFile directory) {
        block2: {
            try {
                FileOutputStream inputStream = new FileOutputStream(tarFile.getFile());
                TarArchiveOutputStream out = new TarArchiveOutputStream(inputStream);
                CompressionUtils.tarDirectory(directory.getFile(), directory.getFile(), out);
                out.close();
            }
            catch (IOException e) {
                fFeedback.error(kModule, "Cannot create the tar file " + tarFile.getAbsolutePath() + " : " + e.getMessage());
                if (!fFeedback.isDebugEnabled(kModule)) break block2;
                fFeedback.debug(kModule, "Cannot create the tar file: ", (Throwable)e);
            }
        }
    }

    public static boolean unTar(ExtendedFile tarFile, ExtendedFile directory, boolean deleteSource) {
        boolean result = true;
        TarArchiveInputStream in = null;
        try {
            try {
                FileInputStream inputStream = new FileInputStream(tarFile.getFile());
                in = new TarArchiveInputStream(inputStream);
                TarArchiveEntry entry = in.getNextTarEntry();
                while (entry != null) {
                    if (entry.isDirectory()) {
                        entry = in.getNextTarEntry();
                        continue;
                    }
                    File curfile = new File(directory.getFile(), entry.getName());
                    File parent = curfile.getParentFile();
                    if (!parent.exists()) {
                        parent.mkdirs();
                    }
                    FileOutputStream out = new FileOutputStream(curfile);
                    IOUtils.copy(in, out);
                    ((OutputStream)out).close();
                    entry = in.getNextTarEntry();
                }
                in.close();
            }
            catch (FileNotFoundException e) {
                result = false;
                DeploymentWatcher.fDeploymentFailed = true;
                fFeedback.error(kModule, "Cannot untar the file " + tarFile.getAbsolutePath() + " : " + e.getMessage());
                if (fFeedback.isDebugEnabled(kModule)) {
                    fFeedback.debug(kModule, "Cannot untar: ", (Throwable)e);
                }
                try {
                    if (in != null) {
                        in.close();
                    }
                    if (deleteSource) {
                        tarFile.deleteFile();
                    }
                }
                catch (IOException e2) {
                    fFeedback.debug(kModule, "Cannot delete temporary tar file: ", (Throwable)e2);
                }
            }
            catch (IOException e) {
                block26: {
                    result = false;
                    DeploymentWatcher.fDeploymentFailed = true;
                    fFeedback.error(kModule, "Cannot untar the file " + tarFile.getAbsolutePath() + " : " + e.getMessage());
                    if (!fFeedback.isDebugEnabled(kModule)) break block26;
                    fFeedback.debug(kModule, "Cannot untar: ", (Throwable)e);
                }
                try {
                    if (in != null) {
                        in.close();
                    }
                    if (deleteSource) {
                        tarFile.deleteFile();
                    }
                }
                catch (IOException e3) {
                    fFeedback.debug(kModule, "Cannot delete temporary tar file: ", (Throwable)e3);
                }
            }
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
                if (deleteSource) {
                    tarFile.deleteFile();
                }
            }
            catch (IOException e) {
                fFeedback.debug(kModule, "Cannot delete temporary tar file: ", (Throwable)e);
            }
        }
        return result;
    }

    public static void compress(ExtendedFile src, ExtendedFile dest, boolean deleteSource) {
        block7: {
            try {
                FileInputStream fin = new FileInputStream(src.getFile());
                BufferedInputStream in = new BufferedInputStream(fin);
                FileOutputStream out = new FileOutputStream(dest.getFile());
                GzipCompressorOutputStream gzOut = new GzipCompressorOutputStream(out);
                byte[] buffer = new byte[1024];
                int n = 0;
                while (-1 != (n = in.read(buffer))) {
                    gzOut.write(buffer, 0, n);
                }
                in.close();
                gzOut.close();
                if (deleteSource) {
                    src.deleteFile();
                }
            }
            catch (FileNotFoundException e) {
                if (fFeedback != null) {
                    fFeedback.error(kModule, "Cannot compress the file " + src.getAbsolutePath() + " : " + e.getMessage());
                    if (fFeedback.isDebugEnabled(kModule)) {
                        fFeedback.debug(kModule, "Cannot compress: ", (Throwable)e);
                    }
                }
            }
            catch (IOException e) {
                if (fFeedback == null) break block7;
                fFeedback.error(kModule, "Cannot compress the file " + src.getAbsolutePath() + " : " + e.getMessage());
                if (!fFeedback.isDebugEnabled(kModule)) break block7;
                fFeedback.debug(kModule, "Cannot compress: ", (Throwable)e);
            }
        }
    }

    public static boolean uncompress(ExtendedFile src, ExtendedFile dest) {
        boolean result;
        block42: {
            GzipCompressorInputStream gzIn;
            block44: {
                result = true;
                FileOutputStream out = null;
                gzIn = null;
                try {
                    FileInputStream fin = new FileInputStream(src.getFile());
                    BufferedInputStream in = new BufferedInputStream(fin);
                    out = new FileOutputStream(dest.getFile());
                    gzIn = new GzipCompressorInputStream(in);
                    byte[] buffer = new byte[1024];
                    int n = 0;
                    while (-1 != (n = gzIn.read(buffer))) {
                        out.write(buffer, 0, n);
                    }
                }
                catch (FileNotFoundException e) {
                    result = false;
                    DeploymentWatcher.fDeploymentFailed = true;
                    if (fFeedback != null) {
                        fFeedback.error(kModule, "Cannot uncompress the file " + src.getAbsolutePath() + " : " + e.getMessage());
                        if (fFeedback.isDebugEnabled(kModule)) {
                            fFeedback.debug(kModule, "Cannot uncompress: ", (Throwable)e);
                        }
                    }
                    if (dest.exists()) {
                        try {
                            dest.deleteFile();
                        }
                        catch (IOException iOException) {
                            fFeedback.debug(kModule, "Cannot remove temporary tar file: ", (Throwable)e);
                        }
                    }
                    if (out != null) {
                        try {
                            out.close();
                        }
                        catch (IOException iOException) {}
                    }
                    if (gzIn != null) {
                        try {
                            gzIn.close();
                        }
                        catch (IOException iOException) {}
                    }
                    break block42;
                }
                catch (IOException e) {
                    block43: {
                        try {
                            result = false;
                            DeploymentWatcher.fDeploymentFailed = true;
                            if (fFeedback != null) {
                                fFeedback.error(kModule, "Cannot uncompress the file " + src.getAbsolutePath() + " : " + e.getMessage());
                                if (fFeedback.isDebugEnabled(kModule)) {
                                    fFeedback.debug(kModule, "Cannot uncompress: ", (Throwable)e);
                                }
                            }
                            if (out != null) {
                                try {
                                    out.close();
                                    out = null;
                                }
                                catch (IOException iOException) {}
                            }
                            if (dest.exists()) {
                                try {
                                    dest.deleteFile();
                                }
                                catch (IOException iOException) {
                                    fFeedback.debug(kModule, "Cannot remove temporary tar file: ", (Throwable)e);
                                }
                            }
                            if (out == null) break block43;
                        }
                        catch (Throwable throwable) {
                            if (out != null) {
                                try {
                                    out.close();
                                }
                                catch (IOException iOException) {}
                            }
                            if (gzIn != null) {
                                try {
                                    gzIn.close();
                                }
                                catch (IOException iOException) {}
                            }
                            throw throwable;
                        }
                        try {
                            out.close();
                        }
                        catch (IOException iOException) {}
                    }
                    if (gzIn != null) {
                        try {
                            gzIn.close();
                        }
                        catch (IOException iOException) {}
                    }
                    break block42;
                }
                if (out == null) break block44;
                try {
                    out.close();
                }
                catch (IOException iOException) {}
            }
            if (gzIn != null) {
                try {
                    gzIn.close();
                }
                catch (IOException iOException) {}
            }
        }
        return result;
    }

    static byte[] createChecksum(ExtendedFile file) throws Exception {
        int numRead;
        FileInputStream fis = new FileInputStream(file.getFile());
        byte[] buffer = new byte[1024];
        MessageDigest complete = MessageDigest.getInstance("MD5");
        do {
            if ((numRead = ((InputStream)fis).read(buffer)) <= 0) continue;
            complete.update(buffer, 0, numRead);
        } while (numRead != -1);
        ((InputStream)fis).close();
        return complete.digest();
    }

    public static synchronized String getMD5Checksum(ExtendedFile file) {
        String name = file.getAbsolutePath();
        ChecksumCacheEntry entry = fChecksumCache.get(name);
        if (entry != null && entry.timeStamp == file.getFile().lastModified()) {
            return entry.checksum;
        }
        try {
            if (fFeedback.isDebugEnabled(kModule)) {
                fFeedback.debug(kModule, "Checksum cache size is " + fChecksumCache.size());
                fFeedback.debug(kModule, "Calculating checksum for : " + name);
            }
            byte[] b = CompressionUtils.createChecksum(file);
            String result = "";
            int i = 0;
            while (i < b.length) {
                result = String.valueOf(result) + Integer.toString((b[i] & 0xFF) + 256, 16).substring(1);
                ++i;
            }
            entry = new ChecksumCacheEntry();
            entry.timeStamp = file.getFile().lastModified();
            entry.checksum = result;
            fChecksumCache.put(name, entry);
            return result;
        }
        catch (Exception e) {
            DeploymentWatcher.fDeploymentFailed = true;
            if (fFeedback != null) {
                fFeedback.error(kModule, "Cannot calculate checksum  for the file " + file.getAbsolutePath() + " : " + e.getMessage());
                if (fFeedback.isDebugEnabled(kModule)) {
                    fFeedback.debug(kModule, "Cannot get checksum: ", (Throwable)e);
                }
            }
            return null;
        }
    }

    private static class CheckSumCache<K, V>
    extends LinkedHashMap<K, V> {
        private static final long serialVersionUID = 1L;

        private CheckSumCache() {
        }

        @Override
        protected boolean removeEldestEntry(Map.Entry<K, V> arg0) {
            return this.size() > 100;
        }
    }

    private static class ChecksumCacheEntry {
        long timeStamp;
        String checksum;

        private ChecksumCacheEntry() {
        }
    }
}

