/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.extension.deployer;

import com.google.gson.JsonParseException;
import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.extension.ExtensionAdministrator;
import com.wily.introscope.agent.extension.OptionalExtensionsManager;
import com.wily.introscope.agent.extension.deployer.CompressionUtils;
import com.wily.introscope.agent.extension.deployer.DeploymentLock;
import com.wily.introscope.agent.extension.deployer.DeploymentWatcher;
import com.wily.introscope.agent.extension.deployer.ExtensionManifest;
import com.wily.introscope.agent.extension.deployer.ProfileWriter;
import com.wily.introscope.agent.service.IAgentService;
import com.wily.util.ConfigurationWatcher;
import com.wily.util.feedback.IModuleFeedbackChannel;
import com.wily.util.feedback.Module;
import com.wily.util.io.ExtendedFile;
import com.wily.util.resource.IResource;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class DeploymentManager
implements IAgentService,
OptionalExtensionsManager.ExtensionListener {
    public static final String kDeployDirectoryName = "deploy";
    public static final String kBackupDirectoryName = "backup";
    public static final String kMetaDataDirectoryName = "metadata";
    public static final String kLockFileName = ".lock";
    public static final String kDeploymentFileName = ".deployment";
    public static final String kManifestFileName = "bundle.json";
    public static final String kDescriptorNameKey = "Name";
    public static final String kDescriptorInstallDateKey = "InstallDate";
    public static final String kDescriptorSourceKey = "Source";
    public static final String kDescriptorChecksumKey = "Checksum";
    public static final String kDescriptorDirectoryKey = "Directory";
    public static final String kDescriptorStatusKey = "Status";
    public static final int kMaxExpectedExtensions = 100;
    public static final int kMaxLockWaitTime = 60;
    private IAgent fAgent;
    private static final Module kModule = new Module("ExtensionDeployer");
    private IModuleFeedbackChannel fFeedback;
    private ConfigurationWatcher fConfigurationWatcher;
    private ExtensionAdministrator fAdministrator;
    private OptionalExtensionsManager fManager;
    private ExtendedFile fExtensionsDir;
    private ExtendedFile fDeployDir;
    private ExtendedFile fBackupDir;
    private IResource fExtensionProfileResource;
    DeploymentLock fLock;
    DeploymentWatcher fWatcher;
    ProfileWriter fWriter;
    private Map<String, LockHolder> fExtensionLockMap = new HashMap<String, LockHolder>();
    public static Map<String, DeploymentDescriptorCacheEntry> fDescriptorCache = new DeploymentDescriptorCache<String, DeploymentDescriptorCacheEntry>();

    public int IAgentService_getServiceVersion() {
        return 2;
    }

    public void IAgentService_startService(IAgent agent, Map params) throws Exception {
        this.fAdministrator = (ExtensionAdministrator)params.get("ExtensionAdministrator");
        this.fManager = this.fAdministrator.getOptionalExtensionManager();
        if (this.fManager == null) {
            return;
        }
        this.fAgent = agent;
        this.fFeedback = agent.IAgent_getModuleFeedback();
        this.fFeedback.info(kModule, "Extension Deployment Watcher Service starting");
        CompressionUtils.setFeedback(kModule, this.fFeedback);
        this.fExtensionsDir = new ExtendedFile(this.fAdministrator.getOptionalExtensionDirectory().getCanonicalPath());
        this.fExtensionProfileResource = this.fAdministrator.getOptionalExtensionProfileResource();
        if (this.fExtensionProfileResource != null) {
            this.fDeployDir = new ExtendedFile(this.fExtensionsDir + File.separator + kDeployDirectoryName);
            this.fBackupDir = new ExtendedFile(this.fExtensionsDir + File.separator + kBackupDirectoryName);
            this.fConfigurationWatcher = this.fAdministrator.getConfigurationWatcher();
            this.fLock = new DeploymentLock(this);
            if (!this.fLock.initialize()) {
                return;
            }
            this.fWatcher = new DeploymentWatcher(this);
            this.fWriter = new ProfileWriter(this);
            this.fManager.addExtensionListener((OptionalExtensionsManager.ExtensionListener)this);
            this.fWatcher.checkFilesAndDeploy(true);
            if (this.fAdministrator.isOptionalExtensionsModeDynamic()) {
                this.fWatcher.start();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private LockHolder getExtensionLock(String extension) {
        LockHolder lh;
        Map<String, LockHolder> map = this.fExtensionLockMap;
        synchronized (map) {
            lh = this.fExtensionLockMap.get(extension);
            if (lh == null) {
                lh = new LockHolder();
                this.fExtensionLockMap.put(extension, lh);
            }
        }
        return lh;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deployExtensions(List<ExtensionDeploymentDescriptor> newExtensions, List<ExtensionDeploymentDescriptor> upgradedExtensions, List<ExtensionDeploymentDescriptor> deletedExtensions, boolean bootLoad) {
        LockHolder lh;
        HashSet<String> coldExtensions;
        HashSet<String> hotExtensions;
        if (newExtensions.size() > 0 || upgradedExtensions.size() > 0 || deletedExtensions.size() > 0) {
            ++DeploymentWatcher.fDeploymentCounter;
        }
        ArrayList<String> loadList = new ArrayList<String>(newExtensions.size() + upgradedExtensions.size());
        ArrayList<ExtensionDeploymentDescriptor> loadDesc = new ArrayList<ExtensionDeploymentDescriptor>(newExtensions.size() + upgradedExtensions.size());
        ArrayList<String> unloadList = new ArrayList<String>(upgradedExtensions.size() + deletedExtensions.size());
        ArrayList<ExtensionDeploymentDescriptor> unloadDesc = new ArrayList<ExtensionDeploymentDescriptor>(upgradedExtensions.size() + deletedExtensions.size());
        ArrayList<String> bootLoadList = new ArrayList<String>();
        for (ExtensionDeploymentDescriptor desc : newExtensions) {
            loadList.add(desc.fName);
            loadDesc.add(desc);
        }
        for (ExtensionDeploymentDescriptor desc : upgradedExtensions) {
            unloadList.add(desc.fName);
            unloadDesc.add(desc);
            loadList.add(desc.fName);
            loadDesc.add(desc);
        }
        for (ExtensionDeploymentDescriptor desc : deletedExtensions) {
            unloadList.add(desc.fName);
            unloadDesc.add(desc);
        }
        if (unloadDesc.size() > 0) {
            this.fFeedback.info(kModule, "Extensions to be unloaded: " + unloadList);
            hotExtensions = new HashSet<String>(unloadList);
            coldExtensions = new HashSet<String>(unloadList);
            this.fWriter.writeProfile(hotExtensions, coldExtensions, false);
            Iterator it = unloadDesc.iterator();
            while (it.hasNext()) {
                ExtensionDeploymentDescriptor desc = (ExtensionDeploymentDescriptor)it.next();
                String extension = desc.fName;
                if (desc.fStatus == 2) continue;
                if (!bootLoad) {
                    if (desc.fManifest.isDynamic()) {
                        lh = this.getExtensionLock(extension);
                        DeploymentLock lock = null;
                        boolean unLocked = false;
                        int count = 60;
                        while (!unLocked) {
                            LockHolder lockHolder = lh;
                            synchronized (lockHolder) {
                                lock = lh.lock;
                                if (lock == null) {
                                    unLocked = true;
                                    this.fFeedback.debug(kModule, "Done with lock of " + extension);
                                    lock = new DeploymentLock(this);
                                    lock.initialize(this.getDeploymentDescriptorFile(extension));
                                    lock.acquireExclusiveLock();
                                    lock.releaseLock();
                                    lock.closeLock();
                                    this.fFeedback.info(kModule, "Extension " + extension + " unloaded by all agents.");
                                }
                            }
                            if (unLocked) continue;
                            try {
                                if (--count > 0) {
                                    this.fFeedback.debug(kModule, "Waiting for release of lock on " + extension);
                                    Thread.sleep(1000L);
                                    continue;
                                }
                                this.fFeedback.debug(kModule, "Giving up waiting on " + extension);
                                unLocked = true;
                            }
                            catch (InterruptedException interruptedException) {}
                        }
                        continue;
                    }
                    this.fFeedback.info(kModule, "Extension " + extension + " is cold and cannot be deleted or upgraded at this time.");
                    it.remove();
                    unloadList.remove(extension);
                    if (!loadList.contains(extension)) continue;
                    loadList.remove(extension);
                    loadDesc.remove(desc);
                    continue;
                }
                DeploymentLock lock = new DeploymentLock(this);
                lock.initialize(this.getDeploymentDescriptorFile(extension));
                if (lock.tryExclusiveLock() == null) {
                    lock.closeLock();
                    this.fFeedback.info(kModule, "Extension " + extension + " is locked and cannot be deleted at this time.");
                    it.remove();
                    unloadList.remove(extension);
                    if (!loadList.contains(extension)) continue;
                    loadList.remove(extension);
                    loadDesc.remove(desc);
                    continue;
                }
                lock.releaseLock();
                lock.closeLock();
            }
        }
        if (unloadDesc.size() > 0) {
            if (!this.fBackupDir.exists()) {
                this.fBackupDir.getFile().mkdirs();
            }
            if (this.fBackupDir.exists()) {
                for (ExtensionDeploymentDescriptor desc : unloadDesc) {
                    ExtendedFile tarFile = new ExtendedFile(this.fBackupDir + File.separator + desc.fName + ".tar");
                    CompressionUtils.tar(tarFile, desc.fTargetDirectory);
                    ExtendedFile tarGzFile = new ExtendedFile(tarFile + ".gz");
                    CompressionUtils.compress(tarFile, tarGzFile, true);
                }
            } else {
                this.fFeedback.warn(kModule, "Cannot create extension backup directory. No backups will be created.");
            }
            if (!bootLoad) {
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException interruptedException) {}
            }
            for (ExtensionDeploymentDescriptor desc : unloadDesc) {
                if (DeploymentManager.deleteDir(desc.fTargetDirectory.getFile())) continue;
                this.fFeedback.error(kModule, "Cannot delete extension directory " + desc.fTargetDirectory);
                DeploymentWatcher.fDeploymentFailed = true;
            }
        }
        if (loadList.size() > 0) {
            this.fFeedback.info(kModule, "Extensions to be loaded: " + loadList);
            for (ExtensionDeploymentDescriptor desc : loadDesc) {
                ExtendedFile tarGzFile = new ExtendedFile(desc.fTarGzFile);
                String tarPath = tarGzFile.getAbsolutePath();
                int gzSuffixIndex = tarPath.indexOf(".gz");
                if (gzSuffixIndex < 1) continue;
                ExtendedFile tarFile = new ExtendedFile(tarPath.substring(0, gzSuffixIndex));
                boolean result = CompressionUtils.uncompress(tarGzFile, tarFile);
                if (result) {
                    result = CompressionUtils.unTar(tarFile, desc.fTargetDirectory, true);
                }
                if (result) {
                    desc.fManifest = this.readExtensionManifest(this.getExtensionManifestFile(desc.fName));
                    if (desc.fManifest == null) {
                        DeploymentWatcher.fDeploymentFailed = true;
                        loadList.remove(desc.fName);
                        this.fFeedback.warn(kModule, "Extension " + desc.fName + " is missing or has invalid manifest.");
                    } else {
                        desc.fStatus = 0;
                        if (!desc.fManifest.isDynamic()) {
                            this.fFeedback.info(kModule, "Extension " + desc.fName + " is not hot and will be loaded at next agent restart.");
                            loadList.remove(desc.fName);
                            bootLoadList.add(desc.fName);
                        }
                    }
                }
                if (DeploymentWatcher.fDeploymentFailed) {
                    ++DeploymentWatcher.fDeploymentFailureCounter;
                    loadList.remove(desc.fName);
                    desc.fStatus = 2;
                }
                ExtendedFile deploymentFile = this.getDeploymentDescriptorFile(desc.fName);
                this.writeDeploymentFile(deploymentFile, desc);
                DeploymentWatcher.fDeploymentFailed = false;
            }
            hotExtensions = new HashSet(loadList);
            coldExtensions = new HashSet(bootLoadList);
            this.fWriter.writeProfile(hotExtensions, coldExtensions, true);
            if (!bootLoad) {
                block20: for (String extension : loadList) {
                    DeploymentLock lock = null;
                    lh = this.getExtensionLock(extension);
                    int count = 60;
                    while (lock == null || !lock.hasLock() || !lock.isLockValid()) {
                        LockHolder lockHolder = lh;
                        synchronized (lockHolder) {
                            lock = lh.lock;
                        }
                        if (lock == null || !lock.hasLock() || !lock.isLockValid()) {
                            try {
                                if (--count > 0) {
                                    this.fFeedback.debug(kModule, "Waiting for lock of " + extension);
                                    Thread.sleep(1000L);
                                    if (!this.fManager.getFailedExtensions().contains(extension)) continue;
                                    this.fFeedback.debug(kModule, "Noticed failure on " + extension);
                                    continue block20;
                                }
                                this.fFeedback.debug(kModule, "Giving up waiting on " + extension);
                                continue block20;
                            }
                            catch (InterruptedException interruptedException) {
                                continue;
                            }
                        }
                        this.fFeedback.debug(kModule, "Detected lock on " + extension + ", hasLock=" + lock.hasLock() + ", isLockValid=" + lock.isLockValid());
                    }
                }
            }
            this.fFeedback.info(kModule, "Deployment complete.");
        }
    }

    private void writeDeploymentFile(ExtendedFile dest, ExtensionDeploymentDescriptor desc) {
        block5: {
            try {
                File parent = dest.getParentFile();
                parent.mkdirs();
                FileOutputStream out = new FileOutputStream(dest.getFile());
                BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(out));
                writer.write("Name: " + desc.fName);
                writer.newLine();
                writer.write("InstallDate: " + desc.fInstallTime);
                writer.newLine();
                writer.write("Source: " + desc.fTarGzFile.getAbsolutePath());
                writer.newLine();
                writer.write("Checksum: " + desc.fChecksum);
                writer.newLine();
                writer.write("Directory: " + desc.fTargetDirectory.getAbsolutePath());
                writer.newLine();
                writer.write("Status: " + desc.fStatus);
                writer.newLine();
                writer.close();
            }
            catch (FileNotFoundException e) {
                if (this.fFeedback != null) {
                    this.fFeedback.error(kModule, "Cannot create deployment descriptor " + dest.getAbsolutePath() + " : " + e.getMessage());
                    if (this.fFeedback.isDebugEnabled(kModule)) {
                        this.fFeedback.debug(kModule, "Cannot create file: ", (Throwable)e);
                    }
                }
            }
            catch (IOException e) {
                if (this.fFeedback == null) break block5;
                this.fFeedback.error(kModule, "Cannot create deployment descriptor " + dest.getAbsolutePath() + " : " + e.getMessage());
                if (!this.fFeedback.isDebugEnabled(kModule)) break block5;
                this.fFeedback.debug(kModule, "Cannot create file: ", (Throwable)e);
            }
        }
    }

    private String readDeploymentFileValue(String line) {
        int start = line.indexOf(58);
        String result = null;
        if (start > 0) {
            result = line.substring(start + 1).trim();
        }
        return result;
    }

    public synchronized ExtensionDeploymentDescriptor readDeploymentFile(ExtendedFile file) {
        ExtensionDeploymentDescriptor result;
        block13: {
            String name = file.getAbsolutePath();
            DeploymentDescriptorCacheEntry entry = fDescriptorCache.get(name);
            if (entry != null && entry.timeStamp == file.getFile().lastModified()) {
                return entry.descriptor;
            }
            if (this.fFeedback.isDebugEnabled(kModule)) {
                this.fFeedback.debug(kModule, "Descriptor cache size is " + fDescriptorCache.size());
                this.fFeedback.debug(kModule, "Reading descriptor from: " + name);
            }
            result = new ExtensionDeploymentDescriptor();
            try {
                FileInputStream in = new FileInputStream(file.getFile());
                BufferedReader reader = new BufferedReader(new InputStreamReader(in));
                String line = reader.readLine();
                while (line != null) {
                    String dirName;
                    String fileName;
                    if (line.startsWith(kDescriptorNameKey)) {
                        result.fName = this.readDeploymentFileValue(line);
                    }
                    if (line.startsWith(kDescriptorInstallDateKey)) {
                        result.fInstallTime = this.readDeploymentFileValue(line);
                    }
                    if (line.startsWith(kDescriptorSourceKey) && (fileName = this.readDeploymentFileValue(line)) != null) {
                        result.fTarGzFile = new ExtendedFile(fileName);
                    }
                    if (line.startsWith(kDescriptorChecksumKey)) {
                        result.fChecksum = this.readDeploymentFileValue(line);
                    }
                    if (line.startsWith(kDescriptorDirectoryKey) && (dirName = this.readDeploymentFileValue(line)) != null) {
                        result.fTargetDirectory = new ExtendedFile(dirName);
                    }
                    if (line.startsWith(kDescriptorStatusKey)) {
                        result.fStatus = Integer.valueOf(this.readDeploymentFileValue(line));
                    }
                    line = reader.readLine();
                }
                reader.close();
                result.fManifest = this.readExtensionManifest(this.getExtensionManifestFile(result.fName));
                entry = new DeploymentDescriptorCacheEntry();
                entry.timeStamp = file.getFile().lastModified();
                entry.descriptor = result;
                fDescriptorCache.put(name, entry);
            }
            catch (FileNotFoundException e) {
                this.fFeedback.error(kModule, "Cannot read deployment descriptor " + file.getAbsolutePath() + " : " + e.getMessage());
                if (this.fFeedback.isDebugEnabled(kModule)) {
                    this.fFeedback.debug(kModule, "Cannot read file: ", (Throwable)e);
                }
            }
            catch (IOException e) {
                this.fFeedback.error(kModule, "Cannot read deployment descriptor " + file.getAbsolutePath() + " : " + e.getMessage());
                if (!this.fFeedback.isDebugEnabled(kModule)) break block13;
                this.fFeedback.debug(kModule, "Cannot read file: ", (Throwable)e);
            }
        }
        return result;
    }

    public ExtensionManifest readExtensionManifest(ExtendedFile file) {
        ExtensionManifest result;
        block7: {
            result = null;
            try {
                FileInputStream in = new FileInputStream(file.getFile());
                BufferedReader reader = new BufferedReader(new InputStreamReader(in));
                String line = reader.readLine();
                StringBuffer jsonBuffer = new StringBuffer(line);
                while (line != null) {
                    line = reader.readLine();
                    if (line == null) continue;
                    jsonBuffer.append(line);
                }
                reader.close();
                result = ExtensionManifest.parseManifest(jsonBuffer.toString());
            }
            catch (JsonParseException e) {
                this.fFeedback.error(kModule, "Cannot read extension manifest " + file.getAbsolutePath() + " : " + e.getMessage());
                if (this.fFeedback.isDebugEnabled(kModule)) {
                    this.fFeedback.debug(kModule, "Cannot read file: ", (Throwable)e);
                }
            }
            catch (FileNotFoundException e) {
                this.fFeedback.error(kModule, "Cannot read extension manifest " + file.getAbsolutePath() + " : " + e.getMessage());
                if (this.fFeedback.isDebugEnabled(kModule)) {
                    this.fFeedback.debug(kModule, "Cannot read file: ", (Throwable)e);
                }
            }
            catch (IOException e) {
                this.fFeedback.error(kModule, "Cannot read extension manifest " + file.getAbsolutePath() + " : " + e.getMessage());
                if (!this.fFeedback.isDebugEnabled(kModule)) break block7;
                this.fFeedback.debug(kModule, "Cannot read file: ", (Throwable)e);
            }
        }
        return result;
    }

    public static boolean deleteDir(File dir) {
        int i;
        if (dir.isDirectory()) {
            String[] children = dir.list();
            if (children.length > 0) {
                String temp = children[0];
                children[0] = children[children.length - 1];
                children[children.length - 1] = temp;
            }
            i = 0;
            while (i < children.length) {
                boolean success = DeploymentManager.deleteDir(new File(dir, children[i]));
                if (!success) {
                    return false;
                }
                ++i;
            }
        }
        boolean result = dir.delete();
        i = 0;
        while (!result && i < 5) {
            try {
                System.gc();
                Thread.sleep(500L);
            }
            catch (InterruptedException interruptedException) {}
            result = dir.delete();
            ++i;
        }
        return result;
    }

    public IModuleFeedbackChannel getFeedback() {
        return this.fFeedback;
    }

    public Module getModule() {
        return kModule;
    }

    public ExtendedFile getExtensionDirectory() {
        return this.fExtensionsDir;
    }

    public ExtendedFile getDeployDirectory() {
        return this.fDeployDir;
    }

    public IResource getExtensionProfileResource() {
        return this.fExtensionProfileResource;
    }

    public DeploymentLock getDeploymenLock() {
        return this.fLock;
    }

    public ExtendedFile getDeploymentDescriptorFile(String extension) {
        return new ExtendedFile(this.fExtensionsDir + File.separator + extension + File.separator + kDeploymentFileName);
    }

    public ExtendedFile getExtensionManifestFile(String extension) {
        return new ExtendedFile(this.fExtensionsDir + File.separator + extension + File.separator + kMetaDataDirectoryName + File.separator + kManifestFileName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyExtensionLoaded(String extension) {
        ExtendedFile file = this.getDeploymentDescriptorFile(extension);
        if (file.exists()) {
            LockHolder lh;
            this.fFeedback.info(kModule, "Notified of extension " + extension + " loaded.");
            LockHolder lockHolder = lh = this.getExtensionLock(extension);
            synchronized (lockHolder) {
                DeploymentLock lock = new DeploymentLock(this);
                if (lock.initialize(file)) {
                    lock.acquireSharedLock();
                    lh.lock = lock;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyExtensionUnloaded(String extension) {
        LockHolder lh;
        LockHolder lockHolder = lh = this.getExtensionLock(extension);
        synchronized (lockHolder) {
            DeploymentLock lock = lh.lock;
            if (lock != null) {
                this.fFeedback.info(kModule, "Notified of extension " + extension + " unloaded.");
                lock.releaseLock();
                lock.closeLock();
                lh.lock = null;
            }
        }
    }

    public void notifyConfigurationWatcher() {
        this.fConfigurationWatcher.checkForChangeNow();
    }

    public static class DeploymentDescriptorCache<K, V>
    extends LinkedHashMap<K, V> {
        private static final long serialVersionUID = 1L;

        @Override
        protected boolean removeEldestEntry(Map.Entry<K, V> arg0) {
            return this.size() > 100;
        }
    }

    public static class DeploymentDescriptorCacheEntry {
        long timeStamp;
        ExtensionDeploymentDescriptor descriptor;
    }

    public static class ExtensionDeploymentDescriptor {
        public static final int kStatusOk = 0;
        public static final int kStatusPending = 1;
        public static final int kStatusFailed = 2;
        ExtendedFile fTarGzFile;
        ExtendedFile fTargetDirectory;
        String fChecksum;
        String fName;
        String fInstallTime;
        int fStatus = 0;
        ExtensionManifest fManifest;
    }

    private static class LockHolder {
        public DeploymentLock lock;

        private LockHolder() {
        }
    }
}

