/*
 * Decompiled with CFR 0.152.
 */
package com.wily.util.io;

import com.wily.util.io.FastArrayCopy;
import com.wily.util.obfuscation.IStatefulByteTransformer;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public final class EncryptOutputStream
extends FilterOutputStream {
    private final IStatefulByteTransformer fEncryptor;
    private byte[] fTempOutBuffer;

    public EncryptOutputStream(OutputStream output, IStatefulByteTransformer encryptor) {
        super(output);
        this.fEncryptor = encryptor;
        this.fTempOutBuffer = new byte[32768];
    }

    public final void write(int b) throws IOException {
        this.out.write(this.fEncryptor.transform((byte)b));
    }

    public void write(byte[] b) throws IOException {
        this.write(b, 0, b.length);
    }

    public void write(byte[] b, int off, int len) throws IOException {
        if (len <= this.fTempOutBuffer.length) {
            FastArrayCopy.copy(b, off, this.fTempOutBuffer, 0, len);
            this.fEncryptor.transformInPlace(this.fTempOutBuffer, 0, len);
            this.out.write(this.fTempOutBuffer, 0, len);
        } else {
            int i = 0;
            while (i < len) {
                this.out.write(this.fEncryptor.transform(b[off++]));
                ++i;
            }
        }
    }
}

