/*
 * Decompiled with CFR 0.152.
 */
package com.wily.powerpack.websphereMQ.agent.extensions.encryption;

import java.security.Key;
import java.util.Properties;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.PBEParameterSpec;

public class CommonEncryptionProvider {
    protected boolean EncryptionEnabled = true;
    private static char[] alphabet = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/=".toCharArray();
    private static byte[] codes = new byte[256];

    static {
        int i = 0;
        while (i < 256) {
            CommonEncryptionProvider.codes[i] = -1;
            ++i;
        }
        i = 65;
        while (i <= 90) {
            CommonEncryptionProvider.codes[i] = (byte)(i - 65);
            ++i;
        }
        i = 97;
        while (i <= 122) {
            CommonEncryptionProvider.codes[i] = (byte)(26 + i - 97);
            ++i;
        }
        i = 48;
        while (i <= 57) {
            CommonEncryptionProvider.codes[i] = (byte)(52 + i - 48);
            ++i;
        }
        CommonEncryptionProvider.codes[43] = 62;
        CommonEncryptionProvider.codes[47] = 63;
    }

    public CommonEncryptionProvider() {
        try {
            SecretKeyFactory.getInstance("PBEWithMD5AndDES");
        }
        catch (Throwable throwable) {
            this.EncryptionEnabled = false;
        }
    }

    public void init(Properties props) {
    }

    public String encrypt(String str) throws Exception {
        if (!this.EncryptionEnabled) {
            return str;
        }
        byte[] s1 = this.encryptLevel1(str.getBytes());
        char[] charArray = this.encode(s1);
        return new String(charArray);
    }

    public String decrypt(String str) throws Exception {
        if (!this.EncryptionEnabled) {
            return str;
        }
        try {
            byte[] bytes = this.decode(str.toCharArray());
            byte[] s1 = this.decryptLevel1(bytes);
            return new String(s1);
        }
        catch (IllegalBlockSizeException illegalBlockSizeException) {
            return str;
        }
    }

    protected byte[] encryptLevel1(byte[] str) throws Exception {
        return this.runPBECipher(true, str);
    }

    protected byte[] decryptLevel1(byte[] str) throws Exception {
        return this.runPBECipher(false, str);
    }

    protected byte[] runPBECipher(boolean encrypt, byte[] str) throws Exception {
        byte[] salt = "CAUNCNTR".getBytes();
        int count = 20;
        PBEParameterSpec pbeParamSpec = new PBEParameterSpec(salt, count);
        PBEKeySpec pbeKeySpec = new PBEKeySpec("umj2ee".toCharArray());
        SecretKeyFactory keyFac = SecretKeyFactory.getInstance("PBEWithMD5AndDES");
        SecretKey pbeKey = keyFac.generateSecret(pbeKeySpec);
        Cipher pbeCipher = Cipher.getInstance("PBEWithMD5AndDES");
        if (encrypt) {
            pbeCipher.init(1, (Key)pbeKey, pbeParamSpec);
        } else {
            pbeCipher.init(2, (Key)pbeKey, pbeParamSpec);
        }
        byte[] cipherText = pbeCipher.doFinal(str);
        return cipherText;
    }

    protected char[] encode(byte[] data) {
        char[] out = new char[(data.length + 2) / 3 * 4];
        int i = 0;
        int index = 0;
        while (i < data.length) {
            boolean quad = false;
            boolean trip = false;
            int val = 0xFF & data[i];
            val <<= 8;
            if (i + 1 < data.length) {
                val |= 0xFF & data[i + 1];
                trip = true;
            }
            val <<= 8;
            if (i + 2 < data.length) {
                val |= 0xFF & data[i + 2];
                quad = true;
            }
            out[index + 3] = alphabet[quad ? val & 0x3F : 64];
            out[index + 2] = alphabet[trip ? (val >>= 6) & 0x3F : 64];
            out[index + 1] = alphabet[(val >>= 6) & 0x3F];
            out[index + 0] = alphabet[(val >>= 6) & 0x3F];
            i += 3;
            index += 4;
        }
        return out;
    }

    protected byte[] decode(char[] data) {
        int tempLen = data.length;
        int ix = 0;
        while (ix < data.length) {
            if (data[ix] > '\u00ff' || codes[data[ix]] < 0) {
                --tempLen;
            }
            ++ix;
        }
        int len = tempLen / 4 * 3;
        if (tempLen % 4 == 3) {
            len += 2;
        }
        if (tempLen % 4 == 2) {
            ++len;
        }
        byte[] out = new byte[len];
        int shift = 0;
        int accum = 0;
        int index = 0;
        int ix2 = 0;
        while (ix2 < data.length) {
            int value;
            int n = value = data[ix2] > '\u00ff' ? -1 : codes[data[ix2]];
            if (value >= 0) {
                accum <<= 6;
                accum |= value;
                if ((shift += 6) >= 8) {
                    out[index++] = (byte)(accum >> (shift -= 8) & 0xFF);
                }
            }
            ++ix2;
        }
        if (index != out.length) {
            throw new Error("Miscalculated data length (wrote " + index + " instead of " + out.length + ")");
        }
        return out;
    }

    public static void main(String[] args) {
        if (args.length != 2) {
            System.out.println("usage java CommonEncryptionProvider <encrypt/decrypt> <string>");
            System.exit(0);
        }
        try {
            CommonEncryptionProvider cep = new CommonEncryptionProvider();
            if (args[0].equalsIgnoreCase("encrypt")) {
                String s = cep.encrypt(args[1]);
                System.out.println(s);
            } else if (args[0].equalsIgnoreCase("decrypt")) {
                String s = cep.decrypt(args[1]);
                System.out.println(s);
            } else if (args[0].equalsIgnoreCase("test")) {
                String s1 = cep.encrypt(args[1]);
                System.out.println("-" + s1 + "-");
                String s2 = cep.decrypt(s1);
                System.out.println("-" + s2 + "-");
                String s3 = cep.encrypt(s1);
                System.out.println("-" + s3 + "-");
                String s4 = cep.decrypt(s3);
                System.out.println("-" + s4 + "-");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

