/*
 * Decompiled with CFR 0.152.
 */
package com.wily.powerpack.websphereMQ.agent.extensions.tracer.handshake;

import com.wily.powerpack.websphereMQ.agent.extensions.tracer.handshake.HandshakeConstants;
import com.wily.powerpack.websphereMQ.agent.extensions.tracer.handshake.Reflection;
import com.wily.util.feedback.IModuleFeedbackChannel;
import java.util.StringTokenizer;

public final class HandshakePacket
implements HandshakeConstants {
    private IModuleFeedbackChannel logger = null;
    private static HandshakePacket instance = null;
    private String agentName = null;
    public static int MQMONITOR_AGENTNAME = 0;
    public static int MQMONITOR_MESSAGE = 1;

    private HandshakePacket(String agentName, IModuleFeedbackChannel feedback) {
        this.agentName = agentName;
        this.logger = feedback;
    }

    public static synchronized HandshakePacket getInstance(String agentName, IModuleFeedbackChannel feedback) {
        if (instance == null) {
            instance = new HandshakePacket(agentName, feedback);
        }
        return instance;
    }

    public void setAgentName(String agentName) {
        this.agentName = agentName;
    }

    public Object createMessageForMQMonitorAgent(String mqMonitorAgentName) {
        Object msg = null;
        try {
            msg = Reflection.createMessageForMQMonitorAgent(mqMonitorAgentName, this.agentName);
        }
        catch (Exception e) {
            this.logger.debug((Throwable)e);
            this.logger.warn(handshakeModule, e.getMessage());
        }
        return msg;
    }

    public String[] extractMQMonitorInformation(String text) {
        this.logger.debug(handshakeModule, "Received message text: " + text);
        boolean messageFromMQMonitorAgentFlag = text.startsWith("MQMONITOR_AGENT_START_STRING");
        if (messageFromMQMonitorAgentFlag) {
            String[] s = new String[2];
            StringTokenizer st = new StringTokenizer(text, "-|-");
            if (st != null && st.countTokens() == 3) {
                st.nextToken();
                s[HandshakePacket.MQMONITOR_AGENTNAME] = st.nextToken();
                s[HandshakePacket.MQMONITOR_MESSAGE] = st.nextToken();
            }
            return s;
        }
        return null;
    }
}

