/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.intelligent.detection;

import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.intelligent.detection.Logger;
import com.wily.introscope.agent.intelligent.entrypoint.EntryPointCandidateFinder;
import com.wily.introscope.agent.intelligent.entrypoint.EntryPointDetectionConfiguration;
import com.wily.introscope.agent.intelligent.exitpoint.ExitPointCandidateFinder;
import com.wily.introscope.agent.intelligent.exitpoint.ExitPointDetectionConfiguration;
import com.wily.introscope.probebuilder.intelligent.instrumentation.FilePersistenceService;
import com.wily.introscope.probebuilder.intelligent.instrumentation.IntelligentInstrumentationConfig;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;

public class BoundaryDetectionExecutor {
    private static final long INITIAL_DELAY = 15L;
    private static ScheduledExecutorService schedulor;
    private static volatile boolean started;

    static {
        started = false;
    }

    public static void init(IAgent agent) {
        if (!started) {
            int poolSize = IntelligentInstrumentationConfig.INSTANCE.getBoundaryDetectionThreadPoolSize();
            schedulor = Executors.newScheduledThreadPool(poolSize, new DefaultThreadFactory());
            Logger.logDebugMessage((String)"Automatic boundary detection executor initiated.");
            schedulor.scheduleAtFixedRate(EntryPointCandidateFinder.getInstance(), 15L, EntryPointDetectionConfiguration.getCandidateFinderInterval(), TimeUnit.SECONDS);
            schedulor.scheduleAtFixedRate(ExitPointCandidateFinder.getInstance(), 15L, ExitPointDetectionConfiguration.getCandidateFinderInterval(), TimeUnit.SECONDS);
            schedulor.scheduleAtFixedRate(new FilePersistenceService(agent), 20L, IntelligentInstrumentationConfig.INSTANCE.getPersistencyServiceFrequencyInterval().intValue(), TimeUnit.SECONDS);
            started = true;
        }
    }

    private static class DefaultThreadFactory
    implements ThreadFactory {
        private static final AtomicInteger POOL_NUMBER = new AtomicInteger(1);
        private static final ThreadGroup THREAD_GROUP = new ThreadGroup("Agent - Intelligent Instrumentation Boundary Detection Thread Group");
        private final AtomicInteger threadNumber = new AtomicInteger(1);
        private final String namePrefix = "agent-ii-abt-pool-" + POOL_NUMBER.getAndIncrement() + "-thread-";

        DefaultThreadFactory() {
        }

        @Override
        public Thread newThread(Runnable r) {
            Thread t = new Thread(THREAD_GROUP, r, String.valueOf(this.namePrefix) + this.threadNumber.getAndIncrement());
            t.setDaemon(true);
            t.setPriority(5);
            return t;
        }
    }
}

