/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.intelligent.detection.tracers;

import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.intelligent.detection.tracers.BoundaryDetectionHelperTracer;
import com.wily.introscope.agent.trace.IStackElement;
import com.wily.introscope.agent.trace.ITracer;
import com.wily.introscope.agent.trace.InvocationData;
import com.wily.introscope.agent.trace.ProbeIdentification;
import com.wily.introscope.agent.trace.io.AddressHostNameHelper;
import com.wily.introscope.agent.trace.nio.DatagramChannelMap;
import com.wily.introscope.agent.util.InvocationDataUtils;
import com.wily.util.properties.AttributeListing;
import java.net.InetSocketAddress;
import java.nio.channels.DatagramChannel;

public final class DatagramSendBoundaryDetectionHelperTracer
extends BoundaryDetectionHelperTracer
implements ITracer {
    private final int ADDRESS_PARAM_INDEX = 1;

    public DatagramSendBoundaryDetectionHelperTracer(IAgent agent, AttributeListing parameters, ProbeIdentification probe, Object sampleTracedObject) {
        super(agent, parameters, probe, sampleTracedObject);
    }

    @Override
    public void ITracer_startTrace(int tracerIndex, InvocationData data) {
        InetSocketAddress remoteAddress;
        DatagramChannel channel;
        if (data.isSocketClamped()) {
            return;
        }
        if (data.getInvocationObject() instanceof DatagramChannel && data.hasInvocationParametersAvailable() && data.getInvocationParameterAsObject(1) instanceof InetSocketAddress && DatagramChannelMap.isClientConnection((DatagramChannel)(channel = (DatagramChannel)data.getInvocationObject()), (InetSocketAddress)(remoteAddress = (InetSocketAddress)data.getInvocationParameterAsObject(1)))) {
            super.ITracer_startTrace(tracerIndex, data);
            if (data.getEndBoundary() != null) {
                InvocationDataUtils.addRemoteServerInfo((IStackElement)data.getParent(), (String)AddressHostNameHelper.getHostName((InetSocketAddress)remoteAddress), (int)remoteAddress.getPort());
            }
        }
    }
}

