/*
 * Decompiled with CFR 0.152.
 */
package com.wily.util.adt;

import java.util.Collection;
import java.util.Map;
import java.util.Set;

public class DefaultedMap
implements Map {
    private final Map fDelegate;
    private final Object fDefaultValue;

    public static Map decorate(Map map, Object defaultValue) {
        return new DefaultedMap(map, defaultValue);
    }

    private DefaultedMap(Map delegate, Object defaultValue) {
        if (delegate == null) {
            throw new NullPointerException("A null map is not allowed.");
        }
        this.fDelegate = delegate;
        this.fDefaultValue = defaultValue;
    }

    public void clear() {
        this.fDelegate.clear();
    }

    public boolean containsKey(Object key) {
        return this.fDelegate.containsKey(key);
    }

    public boolean containsValue(Object value) {
        return this.fDelegate.containsValue(value);
    }

    public Set entrySet() {
        return this.fDelegate.entrySet();
    }

    public boolean equals(Object o) {
        return this.fDelegate.equals(o);
    }

    public Object get(Object key) {
        if (!this.containsKey(key)) {
            return this.fDefaultValue;
        }
        return this.fDelegate.get(key);
    }

    public int hashCode() {
        return this.fDelegate.hashCode();
    }

    public boolean isEmpty() {
        return this.fDelegate.isEmpty();
    }

    public Set keySet() {
        return this.fDelegate.keySet();
    }

    public Object put(Object key, Object value) {
        return this.fDelegate.put(key, value);
    }

    public void putAll(Map t) {
        this.fDelegate.putAll(t);
    }

    public Object remove(Object key) {
        return this.fDelegate.remove(key);
    }

    public int size() {
        return this.fDelegate.size();
    }

    public Collection values() {
        return this.fDelegate.values();
    }
}

