/*
 * Decompiled with CFR 0.152.
 */
package com.wily.rave.spec;

import com.wily.rave.spec.AContentChangeEventSummary;
import com.wily.rave.spec.IContent;
import com.wily.rave.spec.IContentChange;
import com.wily.rave.spec.IContentChangeEvent;
import com.wily.rave.spec.IContentChangeEventSummary;
import com.wily.rave.spec.IDataSourceInstance;
import com.wily.rave.spec.InvalidContent;
import com.wily.rave.utils.HashCodeUtils;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

public abstract class AContentChangeEvent
implements IContentChangeEvent,
Externalizable {
    private static final long serialVersionUID = 1L;
    private IContent content;
    private IContentChangeEventSummary contentChangeEventSummary;

    public AContentChangeEvent() {
    }

    private AContentChangeEvent(IContent content, IContentChangeEventSummary contentChangeEventSummary) {
        this.contentChangeEventSummary = contentChangeEventSummary;
        this.content = content;
    }

    public static IContentChangeEvent getAdditionChangeEvent(long changeDetectionTime, IContent content) {
        return new ContentAddEvent(changeDetectionTime, content, content.getResourceName(), content.getClass(), content.getResourceOwner(), content.getDataSourceInstance());
    }

    public static IContentChangeEvent getModificationChangeEvent(long changeDetectionTime, IContent content) {
        return new ContentModifyEvent(changeDetectionTime, content, content.getResourceName(), content.getClass(), content.getResourceOwner(), content.getDataSourceInstance());
    }

    public static IContentChangeEvent getDeletionChangeEvent(long changeDetectionTime, IDataSourceInstance dataSourceInstance, String resourceName, String resourceOwner, Class resourceType) {
        return new ContentDeleteEvent(changeDetectionTime, resourceName, resourceType, resourceOwner, dataSourceInstance);
    }

    public IContentChangeEventSummary getContentChangeEventSummary() {
        return this.contentChangeEventSummary;
    }

    public long getDetectionTimestamp() {
        return this.contentChangeEventSummary.getDetectionTimestamp();
    }

    public long getChangeTimestamp() {
        return this.contentChangeEventSummary.getChangeTimestamp();
    }

    public boolean isChangeTimestampAvailable() {
        return this.contentChangeEventSummary.isChangeTimestampAvailable();
    }

    public IContent getContent() {
        return this.content;
    }

    public IContentChange getChange(IContent priorContent) throws InvalidContent {
        return this.content.getChange(this.getDetectionTimestamp(), priorContent);
    }

    public String getResourceName() {
        return this.contentChangeEventSummary.getResourceName();
    }

    public Class getResourceType() {
        return this.contentChangeEventSummary.getResourceType();
    }

    public IDataSourceInstance getDataSourceInstance() {
        return this.contentChangeEventSummary.getDataSourceInstance();
    }

    public boolean isDeletionEvent() {
        return false;
    }

    public boolean isModificationEvent() {
        return false;
    }

    public boolean isAdditionEvent() {
        return false;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (other.getClass() == this.getClass()) {
            AContentChangeEvent otherContentChangeEvent = (AContentChangeEvent)other;
            if (otherContentChangeEvent.contentChangeEventSummary.equals(this.contentChangeEventSummary) && (otherContentChangeEvent.content == this.content || otherContentChangeEvent.content != null && otherContentChangeEvent.content.equals(this.content))) {
                return true;
            }
        }
        return false;
    }

    public int hashCode() {
        return HashCodeUtils.accumulateHashCode(this.contentChangeEventSummary.hashCode(), this.content);
    }

    public String toString() {
        return this.contentChangeEventSummary.toString();
    }

    public void writeExternal(ObjectOutput oo) throws IOException {
        oo.writeObject(this.content);
        oo.writeObject(this.contentChangeEventSummary);
    }

    public void readExternal(ObjectInput oi) throws ClassNotFoundException, IOException {
        this.content = (IContent)oi.readObject();
        this.contentChangeEventSummary = (IContentChangeEventSummary)oi.readObject();
    }

    /* synthetic */ AContentChangeEvent(IContent iContent, IContentChangeEventSummary iContentChangeEventSummary, AContentChangeEvent aContentChangeEvent) {
        this(iContent, iContentChangeEventSummary);
    }

    private static class ContentAddEvent
    extends AContentChangeEvent {
        private static final long serialVersionUID = 1L;

        public ContentAddEvent() {
        }

        private ContentAddEvent(long changeDetectionTime, IContent content, String resourceName, Class resourceType, String resourceOwner, IDataSourceInstance dataSourceInstance) {
            super(content, new AContentChangeEventSummary.ContentAddEventSummary(changeDetectionTime, resourceName, resourceType, resourceOwner, dataSourceInstance, content.getContentSummary()), null);
        }

        public boolean isAdditionEvent() {
            return true;
        }
    }

    private static class ContentDeleteEvent
    extends AContentChangeEvent {
        private static final long serialVersionUID = 1L;

        public ContentDeleteEvent() {
        }

        private ContentDeleteEvent(long changeDetectionTime, String resourceName, Class resourceType, String resourceOwner, IDataSourceInstance dataSourceInstance) {
            super(null, new AContentChangeEventSummary.ContentDeleteEventSummary(changeDetectionTime, resourceName, resourceType, resourceOwner, dataSourceInstance), null);
        }

        public boolean isDeletionEvent() {
            return true;
        }
    }

    private static class ContentModifyEvent
    extends AContentChangeEvent {
        private static final long serialVersionUID = 1L;

        public ContentModifyEvent() {
        }

        private ContentModifyEvent(long changeDetectionTime, IContent content, String resourceName, Class resourceType, String resourceOwner, IDataSourceInstance dataSourceInstance) {
            super(content, new AContentChangeEventSummary.ContentModifyEventSummary(changeDetectionTime, resourceName, resourceType, resourceOwner, dataSourceInstance, content.getContentSummary()), null);
        }

        public boolean isModificationEvent() {
            return true;
        }
    }
}

