/*
 * Decompiled with CFR 0.152.
 */
package com.ca.apm.introscope.upgrade;

import com.ca.apm.introscope.upgrade.InstallableUnitMetadata;
import com.ca.apm.introscope.upgrade.KLauncherConstants;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import java.util.zip.Adler32;
import java.util.zip.CheckedOutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InstallableUnit {
    private static final int kBuffer = 2048;
    private InstallableUnitMetadata fMetatdata;

    public InstallableUnitMetadata getMetadata() {
        return this.fMetatdata;
    }

    public String getFormattedMetadata() {
        String formattedData = "";
        if (this.fMetatdata != null) {
            formattedData = this.fMetatdata.getXmlFormattedMetadata();
        }
        return formattedData;
    }

    public boolean hasAgentJar(String agentJarName) {
        boolean success = false;
        if (this.fMetatdata != null) {
            success = this.fMetatdata.hasAgentJar(agentJarName);
        }
        return success;
    }

    public boolean hasAgentJars() {
        boolean success = false;
        if (this.fMetatdata != null) {
            success = this.fMetatdata.hasAgentJars();
        }
        return success;
    }

    public void create(String name, String provider, String version, String location) {
        if (!this.validateDirectory(location)) {
            return;
        }
        try {
            InstallableUnitMetadata metadata = new InstallableUnitMetadata(name, provider, version);
            FileOutputStream dest = new FileOutputStream("upgrade.zip");
            CheckedOutputStream checksum = new CheckedOutputStream(dest, new Adler32());
            ZipOutputStream zostream = new ZipOutputStream(new BufferedOutputStream(checksum));
            File file = new File(location);
            this.addZipEntry(location.length(), file, zostream, metadata);
            ZipEntry entry = new ZipEntry("upgrade" + File.separator + "au.inf");
            zostream.putNextEntry(entry);
            ByteArrayInputStream istream = new ByteArrayInputStream(metadata.toString().getBytes("UTF-8"));
            int count = 0;
            byte[] data = new byte[2048];
            while ((count = ((InputStream)istream).read(data, 0, 2048)) != -1) {
                zostream.write(data, 0, count);
            }
            ((InputStream)istream).close();
            zostream.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private boolean validateDirectory(String location) {
        File locationDir = new File(location);
        if (!locationDir.exists()) {
            System.out.println("Invalid location " + location);
            return false;
        }
        if (!locationDir.isDirectory()) {
            System.out.println(String.valueOf(location) + " is not a directory");
            return false;
        }
        int count = this.isDirectoryEmpty(locationDir, 0);
        if (count <= 0) {
            System.out.println(String.valueOf(location) + " is empty!");
            return false;
        }
        return true;
    }

    private int isDirectoryEmpty(File file, int numOfFiles) {
        int count = numOfFiles;
        if (file.isDirectory()) {
            File[] children;
            File[] fileArray = children = file.listFiles();
            int n = children.length;
            int n2 = 0;
            while (n2 < n) {
                File child = fileArray[n2];
                count += this.isDirectoryEmpty(child, count);
                ++n2;
            }
        } else {
            ++count;
        }
        return count;
    }

    private void addZipEntry(int pathToRootDirLength, File file, ZipOutputStream zostream, InstallableUnitMetadata metadata) throws IOException {
        if (file.isDirectory()) {
            File[] children;
            File[] fileArray = children = file.listFiles();
            int n = children.length;
            int n2 = 0;
            while (n2 < n) {
                File child = fileArray[n2];
                this.addZipEntry(pathToRootDirLength, child, zostream, metadata);
                ++n2;
            }
        } else {
            int count;
            FileInputStream fi = new FileInputStream(file);
            BufferedInputStream origin = new BufferedInputStream(fi, 2048);
            ZipEntry entry = new ZipEntry("upgrade" + file.getPath().substring(pathToRootDirLength));
            zostream.putNextEntry(entry);
            byte[] data = new byte[2048];
            long size = 0L;
            while ((count = origin.read(data, 0, 2048)) != -1) {
                zostream.write(data, 0, count);
                size += (long)count;
            }
            entry.setSize(size);
            origin.close();
            metadata.addUnit(entry.getName(), entry.getSize());
        }
    }

    public boolean validate(String filename) {
        boolean success;
        block20: {
            success = true;
            this.fMetatdata = new InstallableUnitMetadata();
            ZipFile zipFile = null;
            BufferedReader br = null;
            try {
                try {
                    ArrayList<InstallableUnitMetadata.Unit> units = new ArrayList<InstallableUnitMetadata.Unit>();
                    zipFile = new ZipFile(filename);
                    Enumeration<? extends ZipEntry> entries = zipFile.entries();
                    while (entries.hasMoreElements()) {
                        ZipEntry entry = entries.nextElement();
                        if (entry.getName().equalsIgnoreCase("upgrade/au.inf") || entry.getName().equalsIgnoreCase("upgrade\\au.inf")) {
                            br = new BufferedReader(new InputStreamReader(zipFile.getInputStream(entry)));
                            String line = null;
                            while ((line = br.readLine()) != null) {
                                if (this.fMetatdata.addEntry(line)) continue;
                                success = false;
                            }
                            br.close();
                            continue;
                        }
                        if (entry.isDirectory()) continue;
                        entry.getName();
                        InstallableUnitMetadata.Unit unit = new InstallableUnitMetadata.Unit(entry.getName(), entry.getSize());
                        units.add(unit);
                    }
                    success = this.fMetatdata != null && success && units.size() > 0 ? this.fMetatdata.validate(units) : false;
                }
                catch (IOException e) {
                    e.printStackTrace();
                    try {
                        if (zipFile != null) {
                            zipFile.close();
                        }
                        if (br != null) {
                            br.close();
                        }
                        break block20;
                    }
                    catch (IOException iOException) {
                        System.out.println("Problems during cleaning up the I/O.");
                    }
                    break block20;
                }
            }
            catch (Throwable throwable) {
                try {
                    if (zipFile != null) {
                        zipFile.close();
                    }
                    if (br != null) {
                        br.close();
                    }
                }
                catch (IOException iOException) {
                    System.out.println("Problems during cleaning up the I/O.");
                }
                throw throwable;
            }
            try {
                if (zipFile != null) {
                    zipFile.close();
                }
                if (br != null) {
                    br.close();
                }
            }
            catch (IOException iOException) {
                System.out.println("Problems during cleaning up the I/O.");
            }
        }
        return success;
    }

    public Set<String> unzip(String src, String dest) throws IOException {
        HashSet<String> profiles = new HashSet<String>();
        InputStream istream = null;
        ZipFile zipFile = null;
        try {
            zipFile = new ZipFile(src);
            Enumeration<? extends ZipEntry> entries = zipFile.entries();
            while (entries.hasMoreElements()) {
                ZipEntry entry = entries.nextElement();
                String filePath = String.valueOf(dest) + File.separator + entry.getName();
                File file = new File(filePath);
                if (KLauncherConstants.sProfilePattern.matcher(entry.getName()).matches()) {
                    profiles.add(file.getName());
                }
                if (entry.isDirectory()) {
                    if (file.mkdirs()) continue;
                    throw new IOException("Failed to make directory " + file.getName());
                }
                if (!file.getParentFile().exists() && !file.getParentFile().mkdirs()) {
                    throw new IOException("Failed to make directory " + file.getParentFile().getName());
                }
                istream = zipFile.getInputStream(entry);
                this.write(istream, file);
            }
        }
        catch (Throwable throwable) {
            try {
                if (zipFile != null) {
                    zipFile.close();
                }
                if (istream != null) {
                    istream.close();
                }
            }
            catch (IOException iOException) {
                System.out.println("Problems during cleaning up the I/O.");
            }
            throw throwable;
        }
        try {
            if (zipFile != null) {
                zipFile.close();
            }
            if (istream != null) {
                istream.close();
            }
        }
        catch (IOException iOException) {
            System.out.println("Problems during cleaning up the I/O.");
        }
        return profiles;
    }

    private void write(InputStream istream, File fileToWrite) throws IOException {
        BufferedInputStream bistream = null;
        FileOutputStream fos = null;
        FilterOutputStream bos = null;
        try {
            int count;
            bistream = new BufferedInputStream(istream);
            fos = new FileOutputStream(fileToWrite);
            bos = new BufferedOutputStream(fos);
            byte[] data = new byte[2048];
            while ((count = bistream.read(data, 0, 2048)) != -1) {
                ((BufferedOutputStream)bos).write(data, 0, count);
            }
        }
        catch (Throwable throwable) {
            try {
                if (bos != null) {
                    bos.close();
                }
                if (fos != null) {
                    fos.close();
                }
                if (bistream != null) {
                    bistream.close();
                }
            }
            catch (IOException iOException) {
                System.out.println("Problems during cleaning up the I/O.");
            }
            throw throwable;
        }
        try {
            if (bos != null) {
                bos.close();
            }
            if (fos != null) {
                fos.close();
            }
            if (bistream != null) {
                bistream.close();
            }
        }
        catch (IOException iOException) {
            System.out.println("Problems during cleaning up the I/O.");
        }
    }
}

