/*
 * Decompiled with CFR 0.152.
 */
package com.ca.apm.introscope.upgrade;

import com.ca.apm.introscope.upgrade.KLauncherConstants;
import com.ca.apm.introscope.upgrade.LauncherException;
import java.io.File;
import java.io.FileFilter;
import java.util.regex.Matcher;

public class LauncherOrderOracle {
    private int fOrderLowerLimit;
    private int fOrderUpperLimit;
    private String fAgentDirectory;
    private String fAgentJarName;
    private String fAgentName;
    private int fLauncherOrder;

    public LauncherOrderOracle(String order, String agentDirectory, String agentJarName, String agentName, int launcherOrder) throws LauncherException {
        this.parseOrder(order);
        this.fAgentDirectory = agentDirectory;
        this.fAgentJarName = agentJarName;
        this.fAgentName = agentName;
        this.fLauncherOrder = launcherOrder;
    }

    private void parseOrder(String order) throws LauncherException {
        String[] tokens = order.split("-");
        if (tokens.length == 1) {
            try {
                this.fOrderLowerLimit = Integer.parseInt(tokens[0]);
                this.fOrderUpperLimit = Integer.parseInt(tokens[0]);
            }
            catch (NumberFormatException numberFormatException) {
                throw new LauncherException("Invalid format of agent launcher order.");
            }
        } else if (tokens.length == 2) {
            try {
                this.fOrderLowerLimit = Integer.parseInt(tokens[0]);
                this.fOrderUpperLimit = Integer.parseInt(tokens[1]);
            }
            catch (NumberFormatException numberFormatException) {
                throw new LauncherException("Invalid format of agent launcher order.");
            }
        } else {
            throw new LauncherException("Invalid format of agent launcher order.");
        }
    }

    public boolean isLauncherTurnToUpdate() {
        boolean success = false;
        String latestAgentJar = this.checkForLatestAgentJar();
        int latestAgentJarOrder = this.getOrderFromAgentJar(latestAgentJar);
        if (latestAgentJarOrder - this.fLauncherOrder == 1 && this.fLauncherOrder >= this.fOrderLowerLimit && this.fLauncherOrder <= this.fOrderUpperLimit || latestAgentJarOrder == this.fLauncherOrder && this.fLauncherOrder >= this.fOrderLowerLimit && this.fLauncherOrder == this.fOrderUpperLimit) {
            success = true;
        }
        return success;
    }

    public boolean isLauncherTurnToStart() {
        boolean success = false;
        String latestAgentJar = this.checkForLatestAgentJar();
        if (this.fAgentJarName.equalsIgnoreCase(latestAgentJar)) {
            success = true;
        }
        return success;
    }

    public boolean isLauncherTurnToCopyBack() {
        boolean success = false;
        return success;
    }

    private String checkForLatestAgentJar() {
        String latestAgentJar = null;
        File sourceDir = new File(this.fAgentDirectory);
        if (sourceDir.exists()) {
            File[] files = sourceDir.listFiles(new FileFilter(){

                public boolean accept(File pathname) {
                    String name;
                    boolean retValue = false;
                    if (pathname.isFile() && (name = pathname.getName().toLowerCase()).startsWith(LauncherOrderOracle.this.fAgentName)) {
                        retValue = true;
                    }
                    return retValue;
                }
            });
            long lastModified = 0L;
            int i = 0;
            while (i < files.length) {
                if (files[i].lastModified() > lastModified) {
                    latestAgentJar = files[i].getName();
                    lastModified = files[i].lastModified();
                }
                ++i;
            }
        }
        return latestAgentJar;
    }

    private int getOrderFromAgentJar(String agentJar) {
        String group;
        Matcher matcher = KLauncherConstants.sPattern.matcher(agentJar.trim());
        int order = 0;
        if (matcher.matches() && matcher.groupCount() == 3 && (group = matcher.group(2)) != null) {
            try {
                order = Integer.parseInt(group);
            }
            catch (NumberFormatException numberFormatException) {}
        }
        return order;
    }
}

