/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.sustainability;

import com.wily.introscope.agent.sustainability.ISustainabilityService;
import com.wily.introscope.agent.sustainability.ISustainabilityServiceTrace;
import com.wily.introscope.agent.sustainability.ProbeInfoOverheadInfo;
import com.wily.introscope.agent.trace.ProbeInformation;

public class SustainabilityServiceTrace
implements ISustainabilityServiceTrace {
    private ISustainabilityService service;
    private long fStartTraceTime;
    private long fEndStartTraceTime;
    private long fStartEndTraceTime;
    private long fEndEndTraceTime;
    private ProbeInfoOverheadInfo info;

    public SustainabilityServiceTrace(ISustainabilityService sustainabilityService) {
        this.service = sustainabilityService;
        this.fStartTraceTime = sustainabilityService.getNanoTime();
    }

    public void endStartTrace() {
        this.fEndStartTraceTime = this.service.getNanoTime();
    }

    public void setProbeInfo(ProbeInformation probeInformation) {
        this.info = this.service.getProbeInfoOverheadInfo(probeInformation);
    }

    public void startEndTrace() {
        this.fStartEndTraceTime = this.service.getNanoTime();
    }

    public void endEndTrace() {
        this.fEndEndTraceTime = this.service.getNanoTime();
        this.service.storeAway(this);
    }

    public ProbeInformation getProbeInfo() {
        return this.info.getProbeInfo();
    }

    public long getTotalElapsedTime() {
        return this.fEndEndTraceTime - this.fStartTraceTime;
    }

    public long getTotalTimeInTracers() {
        return this.fEndEndTraceTime - this.fStartTraceTime - (this.fStartEndTraceTime - this.fEndStartTraceTime);
    }
}

