/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.trace.hc2;

import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.blame.VirtualStack;
import com.wily.introscope.agent.trace.IStackElement;
import com.wily.introscope.agent.trace.InvocationData;
import com.wily.introscope.agent.trace.ProbeIdentification;
import com.wily.introscope.agent.trace.ReentrancyLevel;
import com.wily.introscope.agent.trace.cas.ITransactionElement;
import com.wily.introscope.agent.trace.hc2.ASingleInstanceTracerFactoryHC;
import com.wily.util.properties.AttributeListing;

public class EntryPointBoundaryMarkerTracer
extends ASingleInstanceTracerFactoryHC {
    private final String COMPONENT_NAME;

    public EntryPointBoundaryMarkerTracer(IAgent agent, AttributeListing parameters, ProbeIdentification probe, Object sampleTracedObject) {
        super(agent, parameters, probe, sampleTracedObject);
        this.COMPONENT_NAME = String.format("EntryPoint-%s.%s", probe.getProbeClassName(), probe.getProbeMethodName());
    }

    @Override
    public boolean ITracerFactory_isShutoff() {
        return VirtualStack.getTransactionCache().getEntryPoint() != null;
    }

    @Override
    public void ITracer_startTrace(int tracerIndex, InvocationData data) {
        data.setComponentNameAt(this.COMPONENT_NAME, tracerIndex);
        data.setEntryPointBoundary(tracerIndex);
    }

    @Override
    public void ITracer_finishTrace(int tracerIndex, InvocationData data) {
        data.unsetEntryPointBoundary(tracerIndex);
    }

    @Override
    public void doOnStartTrace(int tracerIndex, IStackElement data, ITransactionElement element) {
    }

    @Override
    public void doOnEndTrace(int tracerIndex, IStackElement data, ITransactionElement element) {
    }

    @Override
    public ReentrancyLevel ITracerFactory_getReentrancyLevel() {
        return ReentrancyLevel.kMethodName;
    }

    @Override
    protected void doOnAbortedTransactionEndTrace(int tracerIndex, IStackElement data) {
    }
}

