/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.trace.nano;

import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.stat.IDataAccumulator;
import com.wily.introscope.agent.stat.ILongAverageDataAccumulator;
import com.wily.introscope.agent.trace.ASingleMetricTracerFactory;
import com.wily.introscope.agent.trace.InvocationData;
import com.wily.introscope.agent.trace.ProbeIdentification;
import com.wily.introscope.stat.blame.BlameStackSnapshot;
import com.wily.util.properties.AttributeListing;

public class MethodNanoTimer
extends ASingleMetricTracerFactory {
    public MethodNanoTimer(IAgent agent, AttributeListing parameters, ProbeIdentification probe, Object sampleTracedObject) {
        super(agent, parameters, probe, sampleTracedObject);
    }

    @Override
    protected IDataAccumulator createDataAccumulator(String formattedMetricName) {
        return this.getDataAccumulatorFactory().safeGetLongAverageDataAccumulator(formattedMetricName);
    }

    @Override
    public void ITracer_startTrace(int tracerIndex, InvocationData data) {
        data.setWallClockStartTimeNanos(System.nanoTime());
        this.addToBlameStackIfEnabled(data);
    }

    @Override
    public void ITracer_finishTrace(int tracerIndex, InvocationData data) {
        BlameStackSnapshot snapshot = this.removeFromBlameStackIfEnabledAndReturnSnapshot(data);
        ILongAverageDataAccumulator average = (ILongAverageDataAccumulator)this.getDataAccumulator(data);
        if (!average.IDataAccumulator_isShutOff()) {
            data.setWallClockFinishTimeNanos(System.nanoTime());
            average.ILongAggregatingDataAccumulator_recordDataPoint(data.getWallClockElapsedTimeNanos(), snapshot);
        }
    }
}

