/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.trace.nio;

import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.trace.InvocationData;
import com.wily.introscope.agent.trace.io.ASocketNameFormatter;
import com.wily.introscope.agent.trace.nio.DatagramChannelMap;
import java.net.InetSocketAddress;
import java.nio.channels.DatagramChannel;

public class DatagramReceiveMethodNameFormatter
extends ASocketNameFormatter {
    public DatagramReceiveMethodNameFormatter(IAgent agent) {
        super(agent);
    }

    @Override
    protected ASocketNameFormatter.ResourceAndAddress getResourceAndAddress(InvocationData data) {
        Object result;
        Object invocationObject = data.getInvocationObject();
        if (invocationObject instanceof DatagramChannel && data.hasMethodResultAvailable() && (result = data.getInvocationReturnValueAsObject()) != null && result instanceof InetSocketAddress) {
            DatagramChannel channel = (DatagramChannel)invocationObject;
            InetSocketAddress remoteAddress = (InetSocketAddress)result;
            String resourceName = DatagramChannelMap.getResourceName(channel, remoteAddress);
            InetSocketAddress address = DatagramChannelMap.getAddress(channel, remoteAddress);
            if (resourceName != null && address != null) {
                return new ASocketNameFormatter.ResourceAndAddress(resourceName, address);
            }
        }
        return null;
    }
}

