/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.spec.server.graph;

import com.wily.introscope.common15.properties.Messages;
import com.wily.introscope.spec.server.graph.ADirectedGraphVisitor;
import com.wily.introscope.spec.server.graph.IEdge;
import com.wily.introscope.spec.server.graph.IVertex;
import com.wily.introscope.spec.server.graph.TraversalEdgeType;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DirectedGraph<V extends IVertex, E extends IEdge>
implements Serializable {
    private static final long serialVersionUID = 2007845605784530839L;
    private transient HashMap<String, VertexNode<V, E>> fVertices = new HashMap();
    private transient boolean fChanged = false;
    private transient boolean fAcyclic = true;
    private transient int fVertexId = 0;
    private transient long fTimestamp = 0L;

    public synchronized boolean addVertex(V v) {
        if (v == null) {
            throw new IllegalArgumentException(Messages.getString("DirectedGraph.NullVertexErrorMsg"));
        }
        VertexNode<Object, Object> vn = this.fVertices.get(v.getLabel());
        if (vn == null) {
            vn = new VertexNode((IVertex)v, null);
            this.fVertices.put(v.getLabel(), vn);
            this.fChanged = true;
            this.fTimestamp = System.nanoTime();
            return true;
        }
        ((VertexNode)vn).v = v;
        return false;
    }

    public synchronized V removeVertex(String label) {
        VertexNode<V, E> vn = this.fVertices.remove(label);
        if (vn != null) {
            for (VertexNode<V, E> incoming : this.fVertices.values()) {
                if (!((VertexNode)incoming).hasEdge(((VertexNode)vn).v)) continue;
                ((VertexNode)incoming).removeEdge(((VertexNode)vn).v);
            }
            ((VertexNode)vn).clear();
            this.fChanged = true;
            this.fTimestamp = System.nanoTime();
            return (V)((VertexNode)vn).v;
        }
        return null;
    }

    public synchronized V getVertex(String label) {
        VertexNode<V, E> vn = this.fVertices.get(label);
        if (vn == null) {
            return null;
        }
        return (V)((VertexNode)vn).v;
    }

    public synchronized void clear() {
        this.fVertices.clear();
        this.fChanged = true;
        this.fTimestamp = System.nanoTime();
    }

    public synchronized boolean addEdge(String fromLabel, String toLabel, E e) {
        VertexNode<V, E> from = this.fVertices.get(fromLabel);
        VertexNode<V, E> to = this.fVertices.get(toLabel);
        if (e == null) {
            throw new IllegalArgumentException(Messages.getString("DirectedGraph.NullEdgeErrorMsg"));
        }
        if (from == null) {
            throw new IllegalArgumentException(Messages.getString("DirectedGraph.VertexNotFoundErrorMsg", (Object)fromLabel));
        }
        if (to == null) {
            throw new IllegalArgumentException(Messages.getString("DirectedGraph.VertexNotFoundErrorMsg", (Object)toLabel));
        }
        if (from.equals(to)) {
            throw new IllegalArgumentException(Messages.getString("DirectedGraph.EdgeVertexConnectionErrorMsg"));
        }
        boolean added = ((VertexNode)from).addEdge(e, ((VertexNode)to).v);
        this.fChanged |= added;
        if (added) {
            this.fTimestamp = System.nanoTime();
        }
        return added;
    }

    public synchronized List<V> getAdjacentVertices(String label) {
        VertexNode<V, E> vn = this.fVertices.get(label);
        if (vn == null) {
            throw new IllegalArgumentException(Messages.getString("DirectedGraph.VertexNotFoundErrorMsg", (Object)label));
        }
        Collection edges = ((VertexNode)vn).edges.values();
        ArrayList<IVertex> res = new ArrayList<IVertex>(edges.size());
        for (EdgeNode en : edges) {
            res.add(en.to);
        }
        return res;
    }

    public synchronized List<IArc<V, E>> getEdgeVertices(String label) {
        VertexNode<V, E> vn = this.fVertices.get(label);
        if (vn == null) {
            throw new IllegalArgumentException(Messages.getString("DirectedGraph.VertexNotFoundErrorMsg", (Object)label));
        }
        ArrayList edges = new ArrayList(((VertexNode)vn).edges.values());
        return Collections.unmodifiableList(edges);
    }

    public synchronized List<E> getEdges(String label) {
        VertexNode<V, E> vn = this.fVertices.get(label);
        if (vn == null) {
            throw new IllegalArgumentException(Messages.getString("DirectedGraph.VertexNotFoundErrorMsg", (Object)label));
        }
        Collection edges = ((VertexNode)vn).edges.values();
        ArrayList<IEdge> res = new ArrayList<IEdge>(edges.size());
        for (EdgeNode en : edges) {
            res.add(en.e);
        }
        return res;
    }

    public synchronized E removeEdge(String fromLabel, String toLabel) {
        VertexNode<V, E> from = this.fVertices.get(fromLabel);
        VertexNode<V, E> to = this.fVertices.get(toLabel);
        if (from == null) {
            throw new IllegalArgumentException(Messages.getString("DirectedGraph.VertexNotFoundErrorMsg", (Object)fromLabel));
        }
        if (to == null) {
            throw new IllegalArgumentException(Messages.getString("DirectedGraph.VertexNotFoundErrorMsg", (Object)toLabel));
        }
        IEdge e = ((VertexNode)from).removeEdge(((VertexNode)to).v);
        this.fChanged |= e != null;
        if (e != null) {
            this.fTimestamp = System.nanoTime();
        }
        return (E)e;
    }

    public synchronized boolean hasEdge(String fromLabel, String toLabel) {
        VertexNode<V, E> from = this.fVertices.get(fromLabel);
        VertexNode<V, E> to = this.fVertices.get(toLabel);
        if (from == null) {
            throw new IllegalArgumentException(Messages.getString("DirectedGraph.VertexNotFoundErrorMsg", (Object)fromLabel));
        }
        if (to == null) {
            throw new IllegalArgumentException(Messages.getString("DirectedGraph.VertexNotFoundErrorMsg", (Object)toLabel));
        }
        return ((VertexNode)from).hasEdge(((VertexNode)to).v);
    }

    public synchronized int numberVertices() {
        return this.fVertices.size();
    }

    public synchronized int numberEdges() {
        int ec = 0;
        for (VertexNode<V, E> vn : this.fVertices.values()) {
            ec += ((VertexNode)vn).edges.size();
        }
        return ec;
    }

    public synchronized List<V> findVertices(String regEx) {
        Pattern p = Pattern.compile(regEx);
        ArrayList<IVertex> res = new ArrayList<IVertex>();
        for (String label : this.fVertices.keySet()) {
            Matcher m = p.matcher(label);
            if (!m.matches()) continue;
            res.add(((VertexNode)this.fVertices.get(label)).v);
        }
        return res;
    }

    public synchronized List<V> findVerticesWithPrefix(String prefix) {
        ArrayList<IVertex> res = new ArrayList<IVertex>();
        for (String label : this.fVertices.keySet()) {
            if (!label.startsWith(prefix)) continue;
            res.add(((VertexNode)this.fVertices.get(label)).v);
        }
        return res;
    }

    public synchronized List<V> findVerticesWithSuffix(String suffix) {
        ArrayList<IVertex> res = new ArrayList<IVertex>();
        for (String label : this.fVertices.keySet()) {
            if (!label.endsWith(suffix)) continue;
            res.add(((VertexNode)this.fVertices.get(label)).v);
        }
        return res;
    }

    public synchronized boolean isAcyclic() {
        if (!this.fChanged) {
            return this.fAcyclic;
        }
        AcyclicVisitor av = new AcyclicVisitor();
        av = this.depthFirstSearch(av);
        this.fAcyclic = av.isAcyclic();
        this.fChanged = false;
        return this.fAcyclic;
    }

    public synchronized <T extends ADirectedGraphVisitor<V, E>> T depthFirstSearch(T visitor) {
        this.fVertexId = 0;
        for (VertexNode<V, E> vn : this.fVertices.values()) {
            ((VertexNode)vn).walk = VertexVisitType.UNVISITED;
        }
        for (VertexNode<V, E> vn : this.fVertices.values()) {
            if (((VertexNode)vn).walk != VertexVisitType.UNVISITED) continue;
            this.dfsVisitVisitor(visitor, vn);
        }
        return visitor;
    }

    public synchronized <T extends ADirectedGraphVisitor<V, E>> T breadthFirstSearch(T visitor) {
        this.fVertexId = 0;
        for (VertexNode<V, E> vn : this.fVertices.values()) {
            ((VertexNode)vn).walk = VertexVisitType.UNVISITED;
        }
        for (VertexNode<V, E> vn : this.fVertices.values()) {
            if (((VertexNode)vn).walk != VertexVisitType.UNVISITED) continue;
            this.bfsVisitVisitor(visitor, vn);
        }
        return visitor;
    }

    public synchronized <T extends ADirectedGraphVisitor<V, E>> T depthFirstSearch(String label, T visitor) {
        VertexNode<V, E> vn2;
        for (VertexNode<V, E> vn2 : this.fVertices.values()) {
            ((VertexNode)vn2).walk = VertexVisitType.UNVISITED;
        }
        this.fVertexId = 0;
        vn2 = this.fVertices.get(label);
        if (vn2 != null) {
            this.dfsVisitVisitor(visitor, vn2);
        }
        return visitor;
    }

    public synchronized <T extends ADirectedGraphVisitor<V, E>> T breadthFirstSearch(String label, T visitor) {
        VertexNode<V, E> vn2;
        for (VertexNode<V, E> vn2 : this.fVertices.values()) {
            ((VertexNode)vn2).walk = VertexVisitType.UNVISITED;
        }
        this.fVertexId = 0;
        vn2 = this.fVertices.get(label);
        if (vn2 != null) {
            this.bfsVisitVisitor(visitor, vn2);
        }
        return visitor;
    }

    private <T extends ADirectedGraphVisitor<V, E>> T bfsVisitVisitor(T visitor, VertexNode<V, E> vn) {
        LinkedList<VertexNode<V, E>> q = new LinkedList<VertexNode<V, E>>();
        ((VertexNode)vn).walk = VertexVisitType.VISITING;
        ((VertexNode)vn).walkId = ++this.fVertexId;
        q.offer(vn);
        do {
            VertexNode k = (VertexNode)q.poll();
            visitor.acceptVertex((IVertex)k.v);
            for (EdgeNode en : k.edges.values()) {
                VertexNode<V, E> next = this.fVertices.get(en.to.getLabel());
                if (((VertexNode)next).walk == VertexVisitType.UNVISITED) {
                    visitor.acceptEdge((IVertex)k.v, (IEdge)en.e, TraversalEdgeType.TREE, (IVertex)en.to);
                    ((VertexNode)next).walk = VertexVisitType.VISITING;
                    ((VertexNode)next).walkId = ++this.fVertexId;
                    q.offer(next);
                    continue;
                }
                visitor.acceptEdge((IVertex)k.v, (IEdge)en.e, TraversalEdgeType.CROSS, (IVertex)en.to);
            }
            k.walk = VertexVisitType.VISITED;
        } while (!q.isEmpty());
        return visitor;
    }

    private <T extends ADirectedGraphVisitor<V, E>> T dfsVisitVisitor(T visitor, VertexNode<V, E> vn) {
        LinkedList<VertexNode<V, E>> stk = new LinkedList<VertexNode<V, E>>();
        LinkedList itStk = new LinkedList();
        ((VertexNode)vn).walk = VertexVisitType.VISITING;
        ((VertexNode)vn).walkId = ++this.fVertexId;
        visitor.acceptVertex((IVertex)((VertexNode)vn).v);
        stk.addFirst(vn);
        itStk.addFirst(((VertexNode)vn).edges.values().iterator());
        do {
            VertexNode k = (VertexNode)stk.getFirst();
            Iterator adj = (Iterator)itStk.getFirst();
            if (adj.hasNext()) {
                EdgeNode en = (EdgeNode)adj.next();
                VertexNode<V, E> next = this.fVertices.get(en.to.getLabel());
                if (((VertexNode)next).walk == VertexVisitType.UNVISITED) {
                    visitor.acceptEdge((IVertex)k.v, (IEdge)en.e, TraversalEdgeType.TREE, (IVertex)en.to);
                    visitor.acceptVertex((IVertex)((VertexNode)next).v);
                    ((VertexNode)next).walk = VertexVisitType.VISITING;
                    ((VertexNode)next).walkId = ++this.fVertexId;
                    stk.addFirst(next);
                    itStk.addFirst(((VertexNode)next).edges.values().iterator());
                    continue;
                }
                if (((VertexNode)next).walk == VertexVisitType.VISITING && ((VertexNode)next).walkId < k.walkId) {
                    visitor.acceptEdge((IVertex)k.v, (IEdge)en.e, TraversalEdgeType.BACK, (IVertex)en.to);
                    continue;
                }
                if (((VertexNode)next).walkId > k.walkId) {
                    visitor.acceptEdge((IVertex)k.v, (IEdge)en.e, TraversalEdgeType.FORWARD, (IVertex)en.to);
                    continue;
                }
                visitor.acceptEdge((IVertex)k.v, (IEdge)en.e, TraversalEdgeType.CROSS, (IVertex)en.to);
                continue;
            }
            k.walk = VertexVisitType.VISITED;
            stk.removeFirst();
            itStk.removeFirst();
        } while (!stk.isEmpty());
        return visitor;
    }

    public synchronized long getTimestamp() {
        return this.fTimestamp;
    }

    private synchronized void writeObject(ObjectOutputStream out) throws IOException {
        out.writeLong(this.fTimestamp);
        out.writeInt(this.fVertices.size());
        int nrEdges = 0;
        for (Map.Entry<String, VertexNode<V, E>> e : this.fVertices.entrySet()) {
            out.writeObject(((VertexNode)e.getValue()).v);
            nrEdges += ((VertexNode)e.getValue()).edges.size();
        }
        out.writeInt(nrEdges);
        for (Map.Entry<String, VertexNode<V, E>> e : this.fVertices.entrySet()) {
            HashMap edges = ((VertexNode)e.getValue()).edges;
            for (Map.Entry edge : edges.entrySet()) {
                out.writeObject(e.getKey());
                out.writeObject(edge.getKey());
                out.writeObject(((EdgeNode)edge.getValue()).e);
            }
        }
    }

    private synchronized void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        this.fTimestamp = in.readLong();
        int nrVertices = in.readInt();
        this.fVertices = new HashMap();
        int i = 0;
        while (i < nrVertices) {
            IVertex vertex = (IVertex)in.readObject();
            VertexNode vn = new VertexNode(vertex, null);
            this.fVertices.put(vertex.getLabel(), vn);
            ++i;
        }
        int nrEdges = in.readInt();
        int i2 = 0;
        while (i2 < nrEdges) {
            String fromLabel = (String)in.readObject();
            String toLabel = (String)in.readObject();
            IEdge edge = (IEdge)in.readObject();
            VertexNode<V, E> from = this.fVertices.get(fromLabel);
            VertexNode<V, E> to = this.fVertices.get(toLabel);
            ((VertexNode)from).addEdge(edge, ((VertexNode)to).v);
            ++i2;
        }
        this.fChanged = true;
    }

    public synchronized void markAsChanged() {
        this.fChanged = true;
        this.fTimestamp = System.nanoTime();
    }

    public synchronized Set<String> getVertexLables() {
        return new HashSet<String>(this.fVertices.keySet());
    }

    public synchronized Set<V> getVertices() {
        HashSet<IVertex> result = new HashSet<IVertex>();
        for (VertexNode<V, E> vn : this.fVertices.values()) {
            if (vn == null) continue;
            result.add(((VertexNode)vn).v);
        }
        return result;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class AcyclicVisitor<N extends IVertex, C extends IEdge>
    extends ADirectedGraphVisitor<N, C> {
        private boolean acyclic = true;

        @Override
        public void acceptEdge(N fromVertex, C visitEdge, TraversalEdgeType et, N toVertex) {
            this.acyclic &= et != TraversalEdgeType.BACK;
        }

        public boolean isAcyclic() {
            return this.acyclic;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class EdgeNode<N extends IVertex, C extends IEdge>
    implements IArc<N, C>,
    Serializable {
        private static final long serialVersionUID = 3105718241631303059L;
        private transient C e = null;
        private transient N to = null;

        private EdgeNode(C e, N to) {
            this.e = e;
            this.to = to;
        }

        @Override
        public C getEdge() {
            return this.e;
        }

        @Override
        public N getVertex() {
            return this.to;
        }

        /* synthetic */ EdgeNode(IEdge iEdge, IVertex iVertex, EdgeNode edgeNode) {
            this(iEdge, iVertex);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface IArc<V extends IVertex, E extends IEdge> {
        public E getEdge();

        public V getVertex();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class VertexNode<N extends IVertex, C extends IEdge>
    implements Serializable {
        private static final long serialVersionUID = -4571684152086690329L;
        private transient N v = null;
        private transient HashMap<String, EdgeNode<N, C>> edges = new HashMap();
        private transient int walkId = 0;
        private transient VertexVisitType walk = VertexVisitType.UNVISITED;

        private VertexNode(N v) {
            this.v = v;
        }

        private boolean addEdge(C e, N to) {
            EdgeNode<N, C> en = this.edges.get(to.getLabel());
            boolean added = false;
            if (en == null) {
                en = new EdgeNode((IEdge)e, (IVertex)to, null);
                added = true;
            } else {
                ((EdgeNode)en).e = e;
            }
            this.edges.put(to.getLabel(), en);
            return added;
        }

        private C removeEdge(N to) {
            EdgeNode<N, C> en = this.edges.remove(to.getLabel());
            if (en == null) {
                return null;
            }
            return (C)((EdgeNode)en).e;
        }

        private boolean hasEdge(N to) {
            return this.edges.containsKey(to.getLabel());
        }

        private void clear() {
            this.edges.clear();
        }

        /* synthetic */ VertexNode(IVertex iVertex, VertexNode vertexNode) {
            this(iVertex);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum VertexVisitType {
        UNVISITED,
        VISITING,
        VISITED;

    }
}

