/*
 * Decompiled with CFR 0.152.
 */
package com.wily.util.finder;

import com.wily.util.finder.IResourceFinder;
import com.wily.util.finder.IResourceFinderFeedback;
import com.wily.util.io.ExtendedFile;
import com.wily.util.resource.FileBasedResource;
import com.wily.util.resource.IResource;
import com.wily.util.text.IStringLocalizer;
import com.wily.wilyassert.Assertion;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;

public class AgentJarDirectoryBasedResourceFinder
implements IResourceFinder {
    private final String fFileName;
    private final String fResourceToFindNameKey;
    private final String fSubFolder;

    public AgentJarDirectoryBasedResourceFinder(String subFolder, String fileName, String resourceToFindNameKey) {
        Assertion.wilyAssert(resourceToFindNameKey != null);
        Assertion.wilyAssert(fileName != null);
        this.fSubFolder = subFolder;
        this.fFileName = fileName;
        this.fResourceToFindNameKey = resourceToFindNameKey;
    }

    public IResource IResourceFinder_findResource(IResourceFinderFeedback feedback) {
        FileBasedResource resultResource;
        block14: {
            resultResource = null;
            String statusMessage = "";
            InputStream testStream = null;
            IStringLocalizer localizer = feedback.IResourceFinderFeedback_getStringLocalizer();
            try {
                try {
                    String agentJarDirectory = this.IResourceFinder_findAgentJarLocation(feedback);
                    String extensionDirectory = String.valueOf(agentJarDirectory) + this.fSubFolder;
                    ExtendedFile directory = new ExtendedFile(extensionDirectory);
                    String fullPath = new ExtendedFile(directory, this.fFileName).getAbsolutePath();
                    statusMessage = localizer.IStringLocalizer_getFormattedLocalizedString("Resource_Finder_Working_Directory_Attempt_Message", this.fResourceToFindNameKey, true, fullPath, false);
                    feedback.IResourceFinderFeedback_feedbackStatus(statusMessage);
                    resultResource = new FileBasedResource(fullPath);
                    testStream = resultResource.IResource_getContents();
                    statusMessage = localizer.IStringLocalizer_getFormattedLocalizedString("Resource_Finder_Succeeded_Message", this.fFileName, fullPath);
                    feedback.IResourceFinderFeedback_feedbackSuccess(statusMessage);
                }
                catch (Throwable t) {
                    statusMessage = localizer.IStringLocalizer_getFormattedLocalizedString("Resource_Finder_Failed_Message", this.fResourceToFindNameKey, true, t.getClass().getName(), false, t.getMessage(), false);
                    feedback.IResourceFinderFeedback_feedbackFailure(statusMessage);
                    resultResource = null;
                    if (testStream != null) {
                        try {
                            testStream.close();
                        }
                        catch (IOException iOException) {}
                    }
                    break block14;
                }
            }
            catch (Throwable throwable) {
                if (testStream != null) {
                    try {
                        testStream.close();
                    }
                    catch (IOException iOException) {}
                }
                throw throwable;
            }
            if (testStream != null) {
                try {
                    testStream.close();
                }
                catch (IOException iOException) {}
            }
        }
        return resultResource;
    }

    public String IResourceFinder_findAgentJarLocation(IResourceFinderFeedback feedback) {
        String jarDir = null;
        String statusMessage = "";
        IStringLocalizer localizer = feedback.IResourceFinderFeedback_getStringLocalizer();
        try {
            URL urlPath = AgentJarDirectoryBasedResourceFinder.class.getResource(String.valueOf(AgentJarDirectoryBasedResourceFinder.class.getSimpleName()) + ".class");
            String classPath = urlPath.getPath();
            if (classPath != null && classPath.length() > 1) {
                String loweCasePath = classPath.toLowerCase();
                int indexOfAgentJar = loweCasePath.indexOf("agent.jar");
                int indexOfFile = loweCasePath.indexOf("file:/");
                jarDir = classPath.substring(indexOfFile + "file:/".length(), indexOfAgentJar);
            }
            statusMessage = localizer.IStringLocalizer_getFormattedLocalizedString("Resource_Finder_Succeeded_Message", "agent.jar", jarDir);
            feedback.IResourceFinderFeedback_feedbackSuccess(statusMessage);
        }
        catch (Throwable t) {
            statusMessage = localizer.IStringLocalizer_getFormattedLocalizedString("Resource_Finder_Failed_Message", this.fResourceToFindNameKey, true, t.getClass().getName(), false, t.getMessage(), false);
            feedback.IResourceFinderFeedback_feedbackFailure(statusMessage);
        }
        return jarDir;
    }
}

